import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

/**
 * Klasse, die die Konvertierung von Sonderzeichen ins \TeX-Format bernimmt
 * 
 * @author Jolle
 * @since 13.05.2008
 * @version 1.0
 */
public class TexPrintStream extends PrintStream {

	/**
	 * Konstruktor, der den Stream in die bergebene Datei erzeugt.
	 * @param f Datei, die geschrieben werden soll
	 * @since Version 1.0 vom 13.05.2008
	 * @author Jolle
	 * @throws FileNotFoundException Wenn die Datei nicht vorhanden ist.
	 */
	public TexPrintStream(File f) throws FileNotFoundException{ super(f); }
	
	/**
	 * Wandelt die Sonderzeichen im String ins \TeX-format um und schreibt den String in die Datei
	 * @param ausgabe Der String, der (noch) Sonderzeichen enthlt und in die Datei geschrieben werden soll.
	 * @since Version 1.0 vom 13.05.2008
	 * @author Jolle
	 * 
	 */
	public void printTex( String ausgabe ){
		print(umwandlung(ausgabe));
	}
	
	/**
	 * Wandelt die Sonderzeichen im String ins \TeX-format um und schreibt den String in die Datei
	 * Folgende Sonderzeichen werden umgewandelt:
	 * { } _ ^ & # [ ]
	 * @param unformatted Der String, der (noch) Sonderzeichen enthlt und in die Datei geschrieben werden soll.
	 * @return den String mit umgewandelten Sonderzeichen
	 * @since Version 1.0 vom 13.05.2008
	 * @author Jolle
	 * 
	 */
	public static String umwandlung(String unformatted){
		return unformatted.replace("{","\\{").replace("}","\\}").replace("_","\\_").replace("^","\\^{}").replace("&","\\&{}").replace("#","\\#{}").replace("]", "\\rbrack{}").replace("[", "\\lbrack{}");
	}
	
}
