/********************************************************************
*
* $Workfile:$
* $Revision: 1.1 $
* $Modtime:$
* $Author: svenwiegand $
*
* nderungen:
*	$History:$
*
*********************************************************************/

/********************************************************************
*
* Declarations for files generated by COM Interface Wrapper Wizard
* (CIWW)
*
* Copyright  2001 Sven Wiegand (sven.wiegand@web.de)
*
********************************************************************/

#include "stdafx.h"
#include "../Include/InterfaceWrapper.h"
#include <comdef.h>


//-------------------------------------------------------------------
// globals
//-------------------------------------------------------------------

void AfxThrowComException(HRESULT hr, IUnknown *pInterface /*= NULL*/, const GUID *piid /*= NULL*/)
{
	CComException::Throw(hr, pInterface, piid);
}


//-------------------------------------------------------------------
// class CComException
//-------------------------------------------------------------------

CComException::CComException(HRESULT hr, IUnknown *pInterface /*= NULL*/, const GUID *piid /*= NULL*/)
:	CException(TRUE),
	m_hr(hr),
	m_guidInterface(GUID_NULL),
	m_dwHelpContext(0)
{
	if (pInterface && piid)
	{
		ISupportErrorInfo	*pSupportErrorInfo;
		if (pInterface->QueryInterface(IID_ISupportErrorInfo, (void**)&pSupportErrorInfo) == S_OK)
		{
			if (pSupportErrorInfo->InterfaceSupportsErrorInfo(*piid) == S_OK)
			{
				// get error info
				IErrorInfo	*pErrorInfo;

				if (GetErrorInfo(0, &pErrorInfo) == S_OK)
				{
					BSTR	bstrDescription, bstrHelpFile, bstrSource;
					pErrorInfo->GetDescription(&bstrDescription);
					pErrorInfo->GetHelpFile(&bstrHelpFile);
					pErrorInfo->GetSource(&bstrSource);
					m_strDescription = (LPCTSTR)_bstr_t(bstrDescription, false);
					m_strHelpFile = (LPCTSTR)_bstr_t(bstrHelpFile, false);
					m_strSource = (LPCTSTR)_bstr_t(bstrSource, false);

					pErrorInfo->GetGUID(&m_guidInterface);
					pErrorInfo->GetHelpContext(&m_dwHelpContext);

					pErrorInfo->Release();
				}
			}

			pSupportErrorInfo->Release();
		}
		else
			m_guidInterface = *piid;
	}
}


void CComException::Throw(HRESULT hr, IUnknown *pInterface /*= NULL*/, const GUID *piid /*= NULL*/)
{
	CComException	*pE = new CComException(hr, pInterface, piid);
	if (!pE)
		return;

	throw pE;
}


HRESULT CComException::GetResult() const
{
	return m_hr;
}


GUID CComException::GetInterfaceId() const
{
	return m_guidInterface;
}


CString CComException::GetDescription() const
{
	return m_strDescription;
}


CString CComException::GetHelpFile() const
{
	return m_strHelpFile;
}


CString CComException::GetSource() const
{
	return m_strSource;
}


DWORD CComException::GetHelpContext() const
{
	return m_dwHelpContext;
}


BOOL CComException::GetErrorMessage(LPTSTR strError, UINT nMaxError, PUINT pnHelpContext /*= NULL*/)
{
	CString	strMessage;

	if (!m_strDescription.IsEmpty())
		strMessage = m_strDescription + _T("\n\n");
	else
		strMessage = _T("Generic COM-Error!\n\n");

	if (!m_strSource.IsEmpty())
		strMessage+= _T("ProgID: ") + m_strSource + _T("\n");

	if (m_guidInterface != GUID_NULL)
	{
		CString	strInterface;
		strInterface.Format(
			_T("COM-Interface: (%08X-%04X-%04X-%02X-%02X-%02X-%02X-%02X-%02X-%02X-%02X)\n"),
			m_guidInterface.Data1, m_guidInterface.Data2, m_guidInterface.Data3,
			m_guidInterface.Data4[0], m_guidInterface.Data4[1], m_guidInterface.Data4[2], m_guidInterface.Data4[3],
			m_guidInterface.Data4[4], m_guidInterface.Data4[5], m_guidInterface.Data4[6], m_guidInterface.Data4[7]);

		strMessage+= strInterface;
	}

	CString	strResult;
	strResult.Format(_T("HRESULT: 0x%08X"), m_hr);
	strMessage+= strResult;

	_tcsncpy(strError, strMessage, nMaxError-1);
	strError[nMaxError-1] = _T('\0');

	if (pnHelpContext)
		*pnHelpContext = m_dwHelpContext;

	return TRUE;
}


int CComException::ReportError(UINT nType /*= MB_OK*/, UINT nMessageID /*= 0*/)
{
	CString	strMessage;

	if (!m_strDescription.IsEmpty())
		strMessage = m_strDescription + _T("\n\n");
	else
		strMessage = _T("Generic COM-Error!\n\n");

	if (!m_strSource.IsEmpty())
		strMessage+= _T("ProgID: ") + m_strSource + _T("\n");

	if (m_guidInterface != GUID_NULL)
	{
		CString	strInterface;
		strInterface.Format(
			_T("COM-Interface: (%08X-%04X-%04X-%02X-%02X-%02X-%02X-%02X-%02X-%02X-%02X)\n"),
			m_guidInterface.Data1, m_guidInterface.Data2, m_guidInterface.Data3,
			m_guidInterface.Data4[0], m_guidInterface.Data4[1], m_guidInterface.Data4[2], m_guidInterface.Data4[3],
			m_guidInterface.Data4[4], m_guidInterface.Data4[5], m_guidInterface.Data4[6], m_guidInterface.Data4[7]);

		strMessage+= strInterface;
	}

	CString	strResult;
	strResult.Format(_T("HRESULT: 0x%08X"), m_hr);
	strMessage+= strResult;

	return AfxMessageBox(strMessage, nType, m_dwHelpContext);
}


//-------------------------------------------------------------------
// class CInterfaceAggregate
//-------------------------------------------------------------------

CInterfaceAggregate::CInterfaceAggregate(AFX_MODULE_STATE* pModuleState, BOOL bNoDelete /*= FALSE*/)
:	CInterfaceImplementationWrapper<IUnknown>(pModuleState, bNoDelete)
{}


CInterfaceAggregate::CInterfaceAggregate(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, BOOL bNoDelete /*= FALSE*/)
:	CInterfaceImplementationWrapper<IUnknown>(pGetModuleStateFunction, bNoDelete)
{}


CInterfaceAggregate::CInterfaceAggregate(AFX_MODULE_STATE* pModuleState, IUnknown *pOwner)
:	CInterfaceImplementationWrapper<IUnknown>(pModuleState, pOwner)
{}


CInterfaceAggregate::CInterfaceAggregate(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, IUnknown *pOwner)
:	CInterfaceImplementationWrapper<IUnknown>(pGetModuleStateFunction, pOwner)
{}


CInterfaceAggregate::~CInterfaceAggregate()
{}


IUnknown* CInterfaceAggregate::GetInterface()
{
	return &m_xUnknown;
}


STDMETHODIMP CInterfaceAggregate::XUnknown::QueryInterface(REFIID riid, void **ppv)
{
	GETTHIS(CInterfaceAggregate, m_xUnknown);
	return pThis->QueryInterface(riid, ppv);
}


STDMETHODIMP_(ULONG) CInterfaceAggregate::XUnknown::AddRef()
{
	GETTHIS(CInterfaceAggregate, m_xUnknown);
	return pThis->AddRef();
}


STDMETHODIMP_(ULONG) CInterfaceAggregate::XUnknown::Release()
{
	GETTHIS(CInterfaceAggregate, m_xUnknown);
	return pThis->Release();
}