/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMElementWriter {
    private static String lSep = System.getProperty("line.separator");
    protected String[] knownEntities = new String[]{"gt", "amp", "lt", "apos", "quot"};

    public void write(Element root, OutputStream out) throws IOException {
        OutputStreamWriter wri = new OutputStreamWriter(out, "UTF8");
        wri.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write(root, wri, 0, "  ");
        ((Writer)wri).flush();
    }

    public void write(Element element, Writer out, int indent, String indentWith) throws IOException {
        int i = 0;
        while (i < indent) {
            out.write(indentWith);
            ++i;
        }
        out.write("<");
        out.write(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        int i2 = 0;
        while (i2 < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i2);
            out.write(" ");
            out.write(attr.getName());
            out.write("=\"");
            out.write(this.encode(attr.getValue()));
            out.write("\"");
            ++i2;
        }
        out.write(">");
        boolean hasChildren = false;
        NodeList children = element.getChildNodes();
        int i3 = 0;
        while (i3 < children.getLength()) {
            Node child = children.item(i3);
            switch (child.getNodeType()) {
                case 1: {
                    if (!hasChildren) {
                        out.write(lSep);
                        hasChildren = true;
                    }
                    this.write((Element)child, out, indent + 1, indentWith);
                    break;
                }
                case 3: {
                    out.write(this.encode(child.getNodeValue()));
                    break;
                }
                case 8: {
                    out.write("<!--");
                    out.write(this.encode(child.getNodeValue()));
                    out.write("-->");
                    break;
                }
                case 4: {
                    out.write("<![CDATA[");
                    out.write(this.encodedata(((Text)child).getData()));
                    out.write("]]>");
                    break;
                }
                case 5: {
                    out.write(38);
                    out.write(child.getNodeName());
                    out.write(59);
                    break;
                }
                case 7: {
                    out.write("<?");
                    out.write(child.getNodeName());
                    String data = child.getNodeValue();
                    if (data != null && data.length() > 0) {
                        out.write(32);
                        out.write(data);
                    }
                    out.write("?>");
                }
            }
            ++i3;
        }
        if (hasChildren) {
            int i4 = 0;
            while (i4 < indent) {
                out.write(indentWith);
                ++i4;
            }
        }
        out.write("</");
        out.write(element.getTagName());
        out.write(">");
        out.write(lSep);
        out.flush();
    }

    public String encode(String value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '\'': {
                    sb.append("&apos;");
                    break;
                }
                case '\"': {
                    sb.append("&quot;");
                    break;
                }
                case '&': {
                    int nextSemi = value.indexOf(";", i);
                    if (nextSemi < 0 || !this.isReference(value.substring(i, nextSemi + 1))) {
                        sb.append("&amp;");
                        break;
                    }
                    sb.append('&');
                    break;
                }
                default: {
                    if (!this.isLegalCharacter(c)) break;
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.substring(0);
    }

    public String encodedata(String value) {
        StringBuffer sb = new StringBuffer();
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (this.isLegalCharacter(c)) {
                sb.append(c);
            }
            ++i;
        }
        String result = sb.substring(0);
        int cdEnd = result.indexOf("]]>");
        while (cdEnd != -1) {
            sb.setLength(cdEnd);
            sb.append("&#x5d;&#x5d;&gt;").append(result.substring(cdEnd + 3));
            result = sb.substring(0);
            cdEnd = result.indexOf("]]>");
        }
        return result;
    }

    public boolean isReference(String ent) {
        if (ent.charAt(0) != '&' || !ent.endsWith(";")) {
            return false;
        }
        if (ent.charAt(1) == '#') {
            if (ent.charAt(2) == 'x') {
                try {
                    Integer.parseInt(ent.substring(3, ent.length() - 1), 16);
                    return true;
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            try {
                Integer.parseInt(ent.substring(2, ent.length() - 1));
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        String name = ent.substring(1, ent.length() - 1);
        int i = 0;
        while (i < this.knownEntities.length) {
            if (name.equals(this.knownEntities[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLegalCharacter(char c) {
        if (c == '\t' || c == '\n' || c == '\r') {
            return true;
        }
        if (c < ' ') {
            return false;
        }
        if (c <= '\ud7ff') {
            return true;
        }
        if (c < '\ue000') {
            return false;
        }
        return c <= '\ufffd';
    }
}

