/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class DomainsToken
extends AbstractTokenWithSeparator<Spell>
implements CDOMPrimaryToken<Spell> {
    private static final Class<DomainSpellList> SPELLLIST_CLASS = DomainSpellList.class;

    public String getTokenName() {
        return "DOMAINS";
    }

    public ParseResult parseToken(LoadContext context, Spell spell, String value) {
        if (".CLEARALL".equals(value)) {
            context.getListContext().clearAllMasterLists(this.getTokenName(), (CDOMObject)spell);
            return ParseResult.SUCCESS;
        }
        return super.parseToken(context, (Object)spell, value);
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Spell spell, String value) {
        String domainKey;
        Prerequisite prereq = null;
        int openBracketLoc = value.indexOf(91);
        if (openBracketLoc == -1) {
            domainKey = value;
        } else {
            if (value.lastIndexOf(93) != value.length() - 1) {
                return new ParseResult.Fail("Invalid " + this.getTokenName() + " must end with ']' if it contains a PREREQ tag", context);
            }
            domainKey = value.substring(0, openBracketLoc);
            String prereqString = value.substring(openBracketLoc + 1, value.length() - 1);
            if (prereqString.length() == 0) {
                return new ParseResult.Fail(this.getTokenName() + " cannot have empty prerequisite : " + value, context);
            }
            prereq = this.getPrerequisite(prereqString);
            if (prereq == null) {
                return new ParseResult.Fail(this.getTokenName() + " had invalid prerequisite : " + prereqString, context);
            }
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer pipeTok = new StringTokenizer(domainKey, "|");
        while (pipeTok.hasMoreTokens()) {
            Integer level;
            String tokString = pipeTok.nextToken();
            int equalLoc = tokString.indexOf("=");
            if (equalLoc == -1) {
                return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (expecting an =): " + tokString, context);
            }
            if (equalLoc != tokString.lastIndexOf("=")) {
                return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (more than one =): " + tokString, context);
            }
            String nameList = tokString.substring(0, equalLoc);
            String levelString = tokString.substring(equalLoc + 1);
            try {
                level = Integer.valueOf(levelString);
                if (level < -1) {
                    return new ParseResult.Fail(this.getTokenName() + " may not use a negative level: " + value, context);
                }
                if (level == -1 && prereq != null) {
                    return new ParseResult.Fail(this.getTokenName() + " may not use -1 with a PREREQ: " + value, context);
                }
            }
            catch (NumberFormatException nfe) {
                return new ParseResult.Fail("Malformed Level in " + this.getTokenName() + " (expected an Integer): " + levelString, context);
            }
            ParseResult pr = this.checkForIllegalSeparator(',', nameList);
            if (!pr.passed()) {
                return pr;
            }
            StringTokenizer commaTok = new StringTokenizer(nameList, ",");
            while (commaTok.hasMoreTokens()) {
                CDOMGroupRef ref;
                String token = commaTok.nextToken();
                if ("ALL".equals(token)) {
                    foundAny = true;
                    ref = context.getReferenceContext().getCDOMAllReference(SPELLLIST_CLASS);
                } else {
                    foundOther = true;
                    ref = TokenUtilities.getTypeOrPrimitive((LoadContext)context, SPELLLIST_CLASS, (String)token);
                }
                if (ref == null) {
                    return new ParseResult.Fail("  Error was in " + this.getTokenName(), context);
                }
                if (level == -1) {
                    context.getListContext().removeFromMasterList(this.getTokenName(), (CDOMObject)spell, (CDOMReference)ref, (CDOMObject)spell);
                    continue;
                }
                AssociatedPrereqObject edge = context.getListContext().addToMasterList(this.getTokenName(), (CDOMObject)spell, (CDOMReference)ref, (CDOMObject)spell);
                edge.setAssociation(AssociationKey.SPELL_LEVEL, (Object)level);
                if (prereq != null) {
                    edge.addPrerequisite(prereq);
                }
                context.getObjectContext().addToList((CDOMObject)spell, ListKey.SPELL_DOMAINLEVEL, (Object)(token + " " + level));
            }
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Spell spell) {
        AssociatedChanges changes;
        DoubleKeyMapToList dkmtl = new DoubleKeyMapToList();
        ArrayList<String> list = new ArrayList<String>();
        Changes masterChanges = context.getListContext().getMasterListChanges(this.getTokenName(), (CDOMObject)spell, SPELLLIST_CLASS);
        if (masterChanges.includesGlobalClear()) {
            list.add(".CLEARALL");
        }
        if (masterChanges.hasRemovedItems()) {
            for (CDOMReference swl : masterChanges.getRemoved()) {
                changes = context.getListContext().getChangesInMasterList(this.getTokenName(), (CDOMObject)spell, swl);
                MapToList map = changes.getRemovedAssociations();
                if (map == null || map.isEmpty()) continue;
                for (Spell added : map.getKeySet()) {
                    if (!spell.getLSTformat().equals(added.getLSTformat())) {
                        context.addWriteMessage("Spell " + this.getTokenName() + " token cannot remove another Spell " + "(must only remove itself)");
                        return null;
                    }
                    for (AssociatedPrereqObject assoc : map.getListFor((Object)added)) {
                        List prereqs = assoc.getPrerequisiteList();
                        if (prereqs != null && prereqs.size() != 0) {
                            context.addWriteMessage("Incoming Remove Edge to " + spell.getKeyName() + " had a " + "Prerequisite: " + prereqs.size());
                            return null;
                        }
                        dkmtl.addToListFor(null, (Object)-1, (Object)swl);
                    }
                }
            }
        }
        for (CDOMReference swl : masterChanges.getAdded()) {
            changes = context.getListContext().getChangesInMasterList(this.getTokenName(), (CDOMObject)spell, swl);
            Collection removedItems = changes.getRemoved();
            if (removedItems != null && !removedItems.isEmpty() || changes.includesGlobalClear()) {
                context.addWriteMessage(this.getTokenName() + " does not support .CLEAR.");
                return null;
            }
            MapToList map = changes.getAddedAssociations();
            if (map == null || map.isEmpty()) continue;
            for (Spell added : map.getKeySet()) {
                if (!spell.getLSTformat().equals(added.getLSTformat())) {
                    context.addWriteMessage("Spell " + this.getTokenName() + " token cannot allow another Spell " + "(must only allow itself)");
                    return null;
                }
                for (AssociatedPrereqObject assoc : map.getListFor((Object)added)) {
                    Prerequisite prereq;
                    List prereqs = assoc.getPrerequisiteList();
                    if (prereqs == null || prereqs.size() == 0) {
                        prereq = null;
                    } else if (prereqs.size() == 1) {
                        prereq = (Prerequisite)prereqs.get(0);
                    } else {
                        context.addWriteMessage("Incoming Edge to " + spell.getKeyName() + " had more than one " + "Prerequisite: " + prereqs.size());
                        return null;
                    }
                    Integer level = (Integer)assoc.getAssociation(AssociationKey.SPELL_LEVEL);
                    if (level == null) {
                        context.addWriteMessage("Incoming Allows Edge to " + spell.getKeyName() + " had no Spell Level defined");
                        return null;
                    }
                    if (level < 0) {
                        context.addWriteMessage("Incoming Allows Edge to " + spell.getKeyName() + " had invalid Level: " + level + ". Must be >= 0.");
                        return null;
                    }
                    dkmtl.addToListFor((Object)prereq, (Object)level, (Object)swl);
                }
            }
        }
        if (dkmtl.isEmpty()) {
            if (list.isEmpty()) {
                return null;
            }
            return list.toArray(new String[list.size()]);
        }
        PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
        TreeSet set = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        TreeSet levelSet = new TreeSet();
        for (Prerequisite prereq : dkmtl.getKeySet()) {
            StringBuilder sb = new StringBuilder();
            boolean needPipe = false;
            levelSet.clear();
            levelSet.addAll(dkmtl.getSecondaryKeySet((Object)prereq));
            for (Integer i : levelSet) {
                set.clear();
                set.addAll(dkmtl.getListFor((Object)prereq, (Object)i));
                if (needPipe) {
                    sb.append("|");
                }
                sb.append(ReferenceUtilities.joinLstFormat(set, (String)","));
                sb.append('=').append(i);
                needPipe = true;
            }
            if (prereq != null) {
                sb.append('[');
                StringWriter swriter = new StringWriter();
                try {
                    prereqWriter.write((Writer)swriter, prereq);
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
                sb.append(swriter.toString());
                sb.append(']');
            }
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

