/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import java.util.Iterator;
import java.util.List;
import pcgen.cdom.base.ItemFacet;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.fact.AgeFacet;
import pcgen.cdom.facet.fact.RegionFacet;
import pcgen.cdom.facet.model.BioSetFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.core.AgeSet;
import pcgen.core.BioSet;
import pcgen.core.Race;
import pcgen.output.publish.OutputDB;

public class AgeSetFacet
extends AbstractItemFacet<CharID, AgeSet>
implements DataFacetChangeListener<CharID, Object>,
ItemFacet<CharID, AgeSet> {
    private AgeFacet ageFacet;
    private RegionFacet regionFacet;
    private RaceFacet raceFacet;
    private BioSetFacet bioSetFacet;

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, Object> dfce) {
        this.update(dfce.getCharID());
    }

    private void update(CharID id) {
        Region region = Region.getConstant(this.regionFacet.getRegion(id));
        AgeSet ageSet = ((BioSet)this.bioSetFacet.get(id)).getAgeSet(region, this.getAgeSetIndex(id));
        if (ageSet == null) {
            this.remove(id);
        } else {
            this.set(id, ageSet);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, Object> dfce) {
        this.update(dfce.getCharID());
    }

    public int getAgeSetIndex(CharID id) {
        String s;
        int setBaseAge;
        Race race;
        String raceName;
        String region;
        BioSet bioSet = (BioSet)this.bioSetFacet.get(id);
        List<String> values = bioSet.getValueInMaps(region = this.regionFacet.getRegion(id), raceName = (race = (Race)((AbstractItemFacet)this.raceFacet).get(id)) == null ? "" : race.getKeyName().trim(), "BASEAGE");
        if (values == null) {
            return 0;
        }
        int pcAge = this.ageFacet.getAge(id);
        int ageSet = -1;
        Iterator<String> i$ = values.iterator();
        while (i$.hasNext() && pcAge >= (setBaseAge = Integer.parseInt(s = i$.next()))) {
            ++ageSet;
        }
        if (ageSet < 0) {
            ageSet = 0;
        }
        return ageSet;
    }

    public void setAgeFacet(AgeFacet ageFacet) {
        this.ageFacet = ageFacet;
    }

    public void setRegionFacet(RegionFacet regionFacet) {
        this.regionFacet = regionFacet;
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setBioSetFacet(BioSetFacet bioSetFacet) {
        this.bioSetFacet = bioSetFacet;
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(this);
        this.regionFacet.addDataFacetChangeListener(this);
        this.ageFacet.addDataFacetChangeListener(this);
        this.bioSetFacet.addDataFacetChangeListener(this);
        OutputDB.register("ageset", this);
    }
}

