/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.Constants;
import pcgen.cdom.content.LevelExchange;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.facade.core.ChooserFacade;
import pcgen.system.LanguageBundle;
import pcgen.util.chooser.ChooserFactory;

public class ExchangeLevelApplication {
    public static void exchangeLevels(PlayerCharacter aPC, PCClass newcl) {
        LevelExchange le = newcl.get(ObjectKey.EXCHANGE_LEVEL);
        try {
            int iNumOrigClassLevel;
            PCClass cl = le.getExchangeClass().resolvesTo();
            int iMinLevel = le.getMinDonatingLevel();
            int iMaxDonation = le.getMaxDonatedLevels();
            int iLowest = le.getDonatingLowerLevelBound();
            PCClass aClass = aPC.getClassKeyed(cl.getKeyName());
            if (aClass != null && (iNumOrigClassLevel = aPC.getLevel(aClass)) >= iMinLevel) {
                iMaxDonation = Math.min(iMaxDonation, iNumOrigClassLevel - iLowest + 1);
                if (newcl.hasMaxLevel()) {
                    iMaxDonation = Math.min(iMaxDonation, newcl.getSafe(IntegerKey.LEVEL_LIMIT) - aPC.getLevel(newcl));
                }
                if (iMaxDonation > 0) {
                    ArrayList<Integer> choiceNames = new ArrayList<Integer>();
                    for (int i = 0; i <= iMaxDonation; ++i) {
                        choiceNames.add(i);
                    }
                    String title = LanguageBundle.getFormattedString("in_exchangeLevelsChoice", aClass.getDisplayName(), newcl.getDisplayName());
                    CDOMChooserFacadeImpl chooserFacade = new CDOMChooserFacadeImpl(title, choiceNames, new ArrayList(), 1);
                    chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
                    ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
                    List selectedList = chooserFacade.getFinalSelected();
                    int iLevels = 0;
                    if (!selectedList.isEmpty()) {
                        iLevels = (Integer)selectedList.get(0);
                    }
                    if (iLevels > 0) {
                        aPC.giveClassesAway(newcl, aClass, iLevels);
                    }
                }
            }
        }
        catch (NumberFormatException exc) {
            ShowMessageDelegate.showMessageDialog("levelExchange:" + Constants.LINE_SEPARATOR + exc.getMessage(), "PCGen", MessageType.ERROR);
        }
    }
}

