/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.chooser.InfoWrapper;
import pcgen.facade.core.ChooserFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.InfoFactory;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.system.LanguageBundle;

public class CDOMChooserFacadeImpl<T>
implements ChooserFacade {
    private final String name;
    private final List<T> origAvailable;
    private final List<? extends T> origSelected;
    private final int maxNewSelections;
    private final List<T> finalSelected;
    private DefaultListFacade<InfoFacade> availableList;
    private DefaultListFacade<InfoFacade> selectedList;
    private DefaultReferenceFacade<Integer> numSelectionsRemain;
    private final String availableTableTypeNameTitle;
    private final String selectedTableTitle;
    private final String selectionCountName;
    private final String addButtonName;
    private final String removeButtonName;
    private final String availableTableTitle;
    private ChooserFacade.ChooserTreeViewType defaultView = ChooserFacade.ChooserTreeViewType.TYPE_NAME;
    private boolean dupsAllowed = false;
    private boolean requireCompleteSelection;
    private boolean preferRadioSelection = false;
    private boolean userInput = false;
    private final String stringDelimiter;
    private boolean infoAvailable = false;
    private InfoFactory infoFactory = null;

    public CDOMChooserFacadeImpl(String name, List<T> available, List<? extends T> selected, int maxNewSelections) {
        this(name, available, selected, maxNewSelections, LanguageBundle.getString("in_available"), LanguageBundle.getString("in_typeName"), LanguageBundle.getString("in_selected"), LanguageBundle.getString("in_selRemain"), LanguageBundle.getString("in_add"), LanguageBundle.getString("in_remove"), null);
    }

    public CDOMChooserFacadeImpl(String name, List<T> available, List<? extends T> selected, int maxNewSelections, String stringDelimiter) {
        this(name, available, selected, maxNewSelections, LanguageBundle.getString("in_available"), LanguageBundle.getString("in_typeName"), LanguageBundle.getString("in_selected"), LanguageBundle.getString("in_selRemain"), LanguageBundle.getString("in_add"), LanguageBundle.getString("in_remove"), stringDelimiter);
    }

    public CDOMChooserFacadeImpl(String name, List<T> available, List<? extends T> selected, int maxNewSelections, String availableTableTitle, String availableTableTypeNameTitle, String selectedTableTitle, String selectionCountName, String addButtonName, String removeButtonName, String stringDelimiter) {
        this.name = name;
        this.origAvailable = available;
        this.origSelected = selected;
        this.maxNewSelections = maxNewSelections;
        this.availableTableTitle = availableTableTitle;
        this.availableTableTypeNameTitle = availableTableTypeNameTitle;
        this.selectedTableTitle = selectedTableTitle;
        this.selectionCountName = selectionCountName;
        this.addButtonName = addButtonName;
        this.removeButtonName = removeButtonName;
        this.stringDelimiter = stringDelimiter;
        this.availableList = new DefaultListFacade<InfoFacade>(this.createInfoFacadeList(this.origAvailable, stringDelimiter));
        this.selectedList = new DefaultListFacade<InfoFacade>(this.createInfoFacadeList(this.origSelected, stringDelimiter));
        this.numSelectionsRemain = new DefaultReferenceFacade<Integer>(maxNewSelections);
        this.finalSelected = new ArrayList<T>(this.origSelected);
    }

    private List<InfoFacade> createInfoFacadeList(List<? extends T> origAvailable2, String stringDelimiter) {
        ArrayList<InfoFacade> infoFacadeList = new ArrayList<InfoFacade>(origAvailable2.size());
        for (T object : origAvailable2) {
            InfoFacade wrapper;
            if (object instanceof InfoFacade) {
                infoFacadeList.add((InfoFacade)object);
                this.infoAvailable = true;
                continue;
            }
            if (object instanceof CDOMObject) {
                wrapper = new CDOMInfoWrapper((CDOMObject)object);
                infoFacadeList.add(wrapper);
                continue;
            }
            if (!StringUtils.isEmpty(stringDelimiter) && object instanceof String) {
                wrapper = new DelimitedStringInfoWrapper((String)object, stringDelimiter);
                infoFacadeList.add(wrapper);
                continue;
            }
            wrapper = new InfoWrapper(object);
            infoFacadeList.add(wrapper);
        }
        return infoFacadeList;
    }

    @Override
    public final ListFacade<InfoFacade> getAvailableList() {
        return this.availableList;
    }

    @Override
    public final ListFacade<InfoFacade> getSelectedList() {
        return this.selectedList;
    }

    @Override
    public final void addSelected(InfoFacade item) {
        if (this.numSelectionsRemain.getReference() <= 0) {
            return;
        }
        this.selectedList.addElement(item);
        if (!this.dupsAllowed) {
            this.availableList.removeElement(item);
        }
        this.numSelectionsRemain.setReference(this.numSelectionsRemain.getReference() - 1);
    }

    @Override
    public final void removeSelected(InfoFacade item) {
        this.selectedList.removeElement(item);
        if (!this.dupsAllowed) {
            this.availableList.addElement(item);
        }
        this.numSelectionsRemain.setReference(this.numSelectionsRemain.getReference() + 1);
    }

    @Override
    public ReferenceFacade<Integer> getRemainingSelections() {
        return this.numSelectionsRemain;
    }

    @Override
    public void commit() {
        this.finalSelected.clear();
        for (InfoFacade object : this.selectedList) {
            Object selected = object instanceof CDOMInfoWrapper ? ((CDOMInfoWrapper)object).getCdomObj() : (object instanceof InfoWrapper ? ((InfoWrapper)object).getObj() : object);
            this.finalSelected.add(selected);
        }
    }

    @Override
    public final void rollback() {
        this.availableList.setContents(this.createInfoFacadeList(this.origAvailable, this.stringDelimiter));
        this.selectedList.setContents(this.createInfoFacadeList(this.origSelected, this.stringDelimiter));
        this.numSelectionsRemain.setReference(this.maxNewSelections);
        this.finalSelected.clear();
        this.finalSelected.addAll(this.origSelected);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public String getAvailableTableTypeNameTitle() {
        return this.availableTableTypeNameTitle;
    }

    @Override
    public String getAvailableTableTitle() {
        return this.availableTableTitle;
    }

    @Override
    public String getSelectedTableTitle() {
        return this.selectedTableTitle;
    }

    @Override
    public String getAddButtonName() {
        return this.addButtonName;
    }

    @Override
    public String getRemoveButtonName() {
        return this.removeButtonName;
    }

    @Override
    public String getSelectionCountName() {
        return this.selectionCountName;
    }

    @Override
    public List<String> getBranchNames(InfoFacade item) {
        ArrayList<String> branches = new ArrayList<String>();
        if (item instanceof PObject) {
            PObject pObject = (PObject)((Object)item);
            for (Type type : pObject.getTrueTypeList(true)) {
                branches.add(type.toString());
            }
        }
        return branches;
    }

    @Override
    public ChooserFacade.ChooserTreeViewType getDefaultView() {
        return this.defaultView;
    }

    public void setDefaultView(ChooserFacade.ChooserTreeViewType defaultView) {
        this.defaultView = defaultView;
    }

    public List<T> getFinalSelected() {
        return this.finalSelected;
    }

    public void setAllowsDups(boolean dupsAllowed) {
        this.dupsAllowed = dupsAllowed;
    }

    public void setRequireCompleteSelection(boolean requireCompleteSelection) {
        this.requireCompleteSelection = requireCompleteSelection;
    }

    @Override
    public boolean isRequireCompleteSelection() {
        return this.requireCompleteSelection;
    }

    public void setPreferRadioSelection(boolean preferRadioSelection) {
        this.preferRadioSelection = preferRadioSelection;
    }

    @Override
    public boolean isPreferRadioSelection() {
        return this.preferRadioSelection;
    }

    @Override
    public boolean isUserInput() {
        return this.userInput;
    }

    public void setUserInput(boolean userInput) {
        this.userInput = userInput;
    }

    @Override
    public boolean isInfoAvailable() {
        return this.infoAvailable;
    }

    @Override
    public InfoFactory getInfoFactory() {
        return this.infoFactory;
    }

    public void setInfoFactory(InfoFactory infoFactory) {
        this.infoFactory = infoFactory;
    }

    private class DelimitedStringInfoWrapper
    implements InfoFacade {
        private final String string;
        private final String delimiter;

        public DelimitedStringInfoWrapper(String string, String delimiter) {
            this.string = string;
            this.delimiter = StringUtils.trimToNull(delimiter);
        }

        @Override
        public String toString() {
            int idx;
            if (this.delimiter != null && (idx = this.string.indexOf(this.delimiter)) > -1) {
                return this.string.substring(0, idx);
            }
            return this.string;
        }

        @Override
        public String getSource() {
            return "";
        }

        @Override
        public String getSourceForNodeDisplay() {
            return "";
        }

        @Override
        public String getKeyName() {
            return this.string;
        }

        @Override
        public boolean isNamePI() {
            return false;
        }

        @Override
        public String getType() {
            return "";
        }
    }

    private class CDOMInfoWrapper
    implements InfoFacade {
        private final CDOMObject cdomObj;

        public CDOMInfoWrapper(CDOMObject cdomObj) {
            this.cdomObj = cdomObj;
        }

        @Override
        public String toString() {
            return String.valueOf(this.cdomObj);
        }

        @Override
        public String getSource() {
            return SourceFormat.getFormattedString(this.cdomObj, Globals.getSourceDisplay(), true);
        }

        @Override
        public String getSourceForNodeDisplay() {
            return SourceFormat.getFormattedString(this.cdomObj, SourceFormat.LONG, false);
        }

        @Override
        public String getKeyName() {
            return this.cdomObj.getKeyName();
        }

        @Override
        public boolean isNamePI() {
            return this.cdomObj.getSafe(ObjectKey.NAME_PI);
        }

        public CDOMObject getCdomObj() {
            return this.cdomObj;
        }

        @Override
        public String getType() {
            List<Type> types = this.cdomObj.getSafeListFor(ListKey.TYPE);
            return StringUtil.join(types, (String)".");
        }
    }
}

