/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.UserSelection;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.AbilityCategory;
import pcgen.core.Kit;
import pcgen.core.Language;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.kit.BaseKit;

public class KitLangBonus
extends BaseKit {
    private List<CDOMSingleRef<Language>> langList = new ArrayList<CDOMSingleRef<Language>>();
    private transient List<Language> theLanguages = new ArrayList<Language>();

    @Override
    public void apply(PlayerCharacter aPC) {
        CNAbility cna = aPC.getBonusLanguageAbility();
        for (Language l : this.theLanguages) {
            aPC.addAbility(new CNAbilitySelection(cna, l.getKeyName()), UserSelection.getInstance(), UserSelection.getInstance());
        }
    }

    @Override
    public boolean testApply(Kit aKit, PlayerCharacter aPC, List<String> warnings) {
        int allowedCount;
        ArrayList<String> reservedList;
        this.theLanguages = new ArrayList<Language>();
        CNAbility cna = aPC.getBonusLanguageAbility();
        ChoiceManagerList<Language> controller = ChooserUtilities.getConfiguredController(cna, aPC, AbilityCategory.LANGBONUS, reservedList = new ArrayList<String>());
        if (controller == null) {
            return false;
        }
        int remaining = allowedCount = aPC.getAvailableAbilityPool(AbilityCategory.LANGBONUS).intValue();
        for (CDOMSingleRef<Language> ref : this.langList) {
            Language lang = ref.resolvesTo();
            if (remaining > 0 && controller.conditionallyApply(aPC, lang)) {
                this.theLanguages.add(lang);
                --remaining;
                continue;
            }
            warnings.add("LANGUAGE: Could not add bonus language \"" + lang.getKeyName() + "\"");
        }
        if (this.langList.size() > allowedCount) {
            warnings.add("LANGUAGE: Too many bonus languages specified. " + (this.langList.size() - allowedCount) + " had to be ignored.");
        }
        return this.theLanguages.size() > 0;
    }

    @Override
    public String getObjectName() {
        return "Languages";
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (CDOMSingleRef<Language> lang : this.langList) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(lang.getLSTformat(false));
        }
        return result.toString();
    }

    public void addLanguage(CDOMSingleRef<Language> reference) {
        this.langList.add(reference);
    }

    public List<CDOMSingleRef<Language>> getLanguages() {
        return this.langList;
    }
}

