/*
 * Decompiled with CFR 0.152.
 */
package pcgen.facade.util;

import javax.swing.event.EventListenerList;
import org.apache.commons.lang.ObjectUtils;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;

public class DefaultReferenceFacade<E>
implements ReferenceFacade<E> {
    private EventListenerList listenerList = new EventListenerList();
    protected E object;

    public DefaultReferenceFacade() {
        this(null);
    }

    public DefaultReferenceFacade(E object) {
        this.object = object;
    }

    @Override
    public void addReferenceListener(ReferenceListener<? super E> listener) {
        this.listenerList.add(ReferenceListener.class, listener);
    }

    @Override
    public void removeReferenceListener(ReferenceListener<? super E> listener) {
        this.listenerList.remove(ReferenceListener.class, listener);
    }

    @Override
    public E getReference() {
        return this.object;
    }

    public void setReference(E object) {
        if (ObjectUtils.equals(this.object, object)) {
            return;
        }
        E old = this.object;
        this.object = object;
        this.fireReferenceChangedEvent(this, old, object);
    }

    protected void fireReferenceChangedEvent(Object source, E old, E newer) {
        Object[] listeners = this.listenerList.getListenerList();
        ReferenceEvent<E> e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ReferenceListener.class) continue;
            if (e == null) {
                e = new ReferenceEvent<E>(source, old, newer);
            }
            ((ReferenceListener)listeners[i + 1]).referenceChanged(e);
        }
    }

    public String toString() {
        return String.valueOf(this.object);
    }
}

