/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.io.File;
import pcgen.facade.core.CompanionFacade;
import pcgen.facade.core.RaceFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;

public class CompanionFacadeDelegate
implements CompanionFacade {
    private CompanionFacade delegate;
    private DelegateReferenceFacade<String> nameDelegate = new DelegateReferenceFacade();
    private DelegateReferenceFacade<File> fileDelegate = new DelegateReferenceFacade();
    private DelegateReferenceFacade<RaceFacade> raceDelegate = new DelegateReferenceFacade();

    public void setCompanionFacade(CompanionFacade companionFacade) {
        this.delegate = companionFacade;
        this.nameDelegate.setDelegate(companionFacade.getNameRef());
        this.fileDelegate.setDelegate(companionFacade.getFileRef());
        this.raceDelegate.setDelegate(companionFacade.getRaceRef());
    }

    CompanionFacade getDelegate() {
        return this.delegate;
    }

    @Override
    public ReferenceFacade<String> getNameRef() {
        return this.nameDelegate;
    }

    @Override
    public ReferenceFacade<File> getFileRef() {
        return this.fileDelegate;
    }

    @Override
    public ReferenceFacade<RaceFacade> getRaceRef() {
        return this.raceDelegate;
    }

    @Override
    public String getCompanionType() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getCompanionType();
    }

    private static class DelegateReferenceFacade<T>
    extends DefaultReferenceFacade<T>
    implements ReferenceListener<T> {
        private ReferenceFacade<T> delegate;

        private DelegateReferenceFacade() {
        }

        public void setDelegate(ReferenceFacade<T> newDelegate) {
            if (this.delegate != null) {
                this.delegate.removeReferenceListener(this);
            }
            this.delegate = newDelegate;
            if (this.delegate != null) {
                this.delegate.addReferenceListener(this);
                this.setReference(this.delegate.getReference());
            } else {
                this.setReference(null);
            }
        }

        @Override
        public void referenceChanged(ReferenceEvent<T> e) {
            this.setReference(e.getNewReference());
        }
    }
}

