/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.persistence.lst.EquipIconLstToken;
import pcgen.persistence.lst.EquipSlotLstToken;
import pcgen.persistence.lst.GameModeLstToken;
import pcgen.persistence.lst.InstallLstToken;
import pcgen.persistence.lst.LevelLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.MigrationLstToken;
import pcgen.system.PluginLoader;
import pcgen.util.Logging;

public class TokenStore
implements PluginLoader {
    private static TokenStore inst;
    private HashMap<Class<? extends LstToken>, Map<String, LstToken>> tokenTypeMap = new HashMap();
    private final List<Class<? extends LstToken>> tokenTypeList = new ArrayList<Class<? extends LstToken>>();

    private TokenStore() {
        this.populateTokenTypeList();
    }

    public static TokenStore inst() {
        if (inst == null) {
            inst = new TokenStore();
        }
        return inst;
    }

    public static void reset() {
        inst = new TokenStore();
    }

    private void populateTokenTypeList() {
        this.tokenTypeList.add(GameModeLstToken.class);
        this.tokenTypeList.add(LevelLstToken.class);
        this.tokenTypeList.add(EquipIconLstToken.class);
        this.tokenTypeList.add(EquipSlotLstToken.class);
        this.tokenTypeList.add(InstallLstToken.class);
        this.tokenTypeList.add(MigrationLstToken.class);
    }

    @Override
    public void loadPlugin(Class<?> clazz) throws Exception {
        this.addToTokenMap((LstToken)clazz.newInstance());
    }

    public Class[] getPluginClasses() {
        return new Class[]{LstToken.class};
    }

    public void addToTokenMap(LstToken newToken) {
        for (Class<? extends LstToken> tokClass : this.tokenTypeList) {
            Map<String, LstToken> tokenMap;
            LstToken test;
            if (!tokClass.isAssignableFrom(newToken.getClass()) || (test = (tokenMap = this.getTokenMap(tokClass)).put(newToken.getTokenName(), newToken)) == null) continue;
            Logging.errorPrint("More than one " + tokClass.getName() + " has the same token name: '" + newToken.getTokenName() + "'. " + "Classes were " + test.getClass().getName() + " and " + newToken.getClass().getName());
        }
    }

    public Map<String, LstToken> getTokenMap(Class<? extends LstToken> tokInterface) {
        Map<String, LstToken> tokenMap = this.tokenTypeMap.get(tokInterface);
        if (tokenMap == null) {
            tokenMap = new HashMap<String, LstToken>();
            this.tokenTypeMap.put(tokInterface, tokenMap);
        }
        return tokenMap;
    }
}

