/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.content.fact.FactDefinition;
import pcgen.cdom.content.factset.FactSetDefinition;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.CDOMSubLineLoader;
import pcgen.util.Logging;

public class CDOMControlLoader
extends LstLineFileLoader {
    private final Map<String, CDOMSubLineLoader<?>> loadMap = new HashMap();

    public CDOMControlLoader() {
        this.addLineLoader(new CDOMSubLineLoader<FactDefinition>("FACTDEF", FactDefinition.class));
        this.addLineLoader(new CDOMSubLineLoader<FactSetDefinition>("FACTSETDEF", FactSetDefinition.class));
    }

    public void addLineLoader(CDOMSubLineLoader<?> loader) {
        if (loader == null) {
            throw new IllegalArgumentException("Cannot add null loader to Control Loader");
        }
        String prefix = loader.getPrefix();
        if (this.loadMap.containsKey(prefix)) {
            throw new IllegalArgumentException("Cannot add a second loader for prefix: " + prefix);
        }
        this.loadMap.put(loader.getPrefix(), loader);
    }

    public boolean parseSubLine(LoadContext context, String val, URI source) {
        int sepLoc = val.indexOf(9);
        String firstToken = sepLoc == -1 ? val : val.substring(0, sepLoc);
        int colonLoc = firstToken.indexOf(58);
        if (colonLoc == -1) {
            Logging.addParseMessage(Logging.LST_ERROR, "Unsure what to do with line without a colon in first token: " + val + " in file: " + source);
            return false;
        }
        String prefix = firstToken.substring(0, colonLoc);
        CDOMSubLineLoader<?> loader = this.loadMap.get(prefix);
        if (loader == null) {
            Logging.addParseMessage(Logging.LST_ERROR, "Unsure what to do with line with prefix: " + prefix + ".  Line was: " + val + " in file: " + source);
            return false;
        }
        try {
            if (!this.subParse(context, loader, val)) {
                return false;
            }
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint("Exception in Load: ", ple);
            return false;
        }
        return true;
    }

    private <CC extends Loadable> boolean subParse(LoadContext context, CDOMSubLineLoader<CC> loader, String line) throws PersistenceLayerException {
        int tabLoc = line.indexOf("\t");
        String lineIdentifier = tabLoc == -1 ? line : line.substring(0, tabLoc);
        int colonLoc = lineIdentifier.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint("First token on line had no colon: " + line, context);
            return false;
        }
        String name = lineIdentifier.substring(colonLoc + 1);
        if (name == null || name.isEmpty()) {
            Logging.errorPrint("First token on line had no content: " + line, context);
            return false;
        }
        AbstractReferenceContext refContext = context.getReferenceContext();
        CC obj = refContext.constructNowIfNecessary(loader.getLoadedClass(), name.replace('|', ' '));
        return loader.parseLine(context, obj, line);
    }

    @Override
    public void parseLine(LoadContext context, String inputLine, URI sourceURI) throws PersistenceLayerException {
        context.rollback();
        if (this.parseSubLine(context, inputLine, sourceURI)) {
            Logging.clearParseMessages();
            context.commit();
        } else {
            context.rollback();
            Logging.replayParsedMessages();
            Logging.clearParseMessages();
        }
    }
}

