/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.ParseResult;

public abstract class AbstractIntToken<T extends CDOMObject> {
    protected int maxValue() {
        return Integer.MAX_VALUE;
    }

    protected int minValue() {
        return Integer.MIN_VALUE;
    }

    protected ParseResult checkValue(Integer value) {
        int max = this.maxValue();
        int min = this.minValue();
        if (max == Integer.MAX_VALUE) {
            if (value < min) {
                return new ParseResult.Fail(this.getTokenName() + " must be an integer >= " + min);
            }
        } else if (min == Integer.MIN_VALUE) {
            if (value > max) {
                return new ParseResult.Fail(this.getTokenName() + " must be an integer <= " + max);
            }
        } else if (value > max || value < min) {
            return new ParseResult.Fail(this.getTokenName() + " must be an integer betwen " + min + " and " + max);
        }
        return ParseResult.SUCCESS;
    }

    protected abstract String getTokenName();

    protected abstract IntegerKey integerKey();

    public ParseResult parseToken(LoadContext context, T obj, String value) {
        try {
            Integer intValue = Integer.valueOf(value);
            ParseResult pr = this.checkValue(intValue);
            if (!pr.passed()) {
                return pr;
            }
            context.getObjectContext().put((CDOMObject)obj, this.integerKey(), intValue);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>");
        }
    }

    public String[] unparse(LoadContext context, T obj) {
        Integer value = context.getObjectContext().getInteger((CDOMObject)obj, this.integerKey());
        if (value == null) {
            return null;
        }
        ParseResult checkValue = this.checkValue(value);
        if (!checkValue.passed()) {
            context.addWriteMessage(checkValue.toString());
            return null;
        }
        return new String[]{value.toString()};
    }
}

