/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.util.Collection;
import org.apache.xml.utils.XMLChar;
import pcgen.base.lang.UnreachableError;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public abstract class AbstractToken {
    private final PreParserFactory prereqParser;

    protected AbstractToken() {
        try {
            this.prereqParser = PreParserFactory.getInstance();
        }
        catch (PersistenceLayerException ple) {
            Logging.errorPrint("Error Initializing PreParserFactory");
            Logging.errorPrint("  " + ple.getMessage(), ple);
            throw new UnreachableError();
        }
    }

    protected boolean looksLikeAPrerequisite(String activeValue) {
        return (activeValue.startsWith("PRE") || activeValue.startsWith("!PRE")) && activeValue.contains(":");
    }

    protected Prerequisite getPrerequisite(String token) {
        try {
            return this.prereqParser.parse(token);
        }
        catch (PersistenceLayerException ple) {
            Logging.addParseMessage(Logging.LST_ERROR, "Error parsing Prerequisite in " + this.getTokenName() + ": " + token + "\n  " + ple.getMessage());
            return null;
        }
    }

    protected ParseResult checkSeparatorsAndNonEmpty(char separator, String value) {
        ParseResult pr = this.checkNonEmpty(value);
        if (pr.passed()) {
            pr = this.checkForIllegalSeparator(separator, value);
        }
        return pr;
    }

    protected ParseResult checkForIllegalSeparator(char separator, String value) {
        if (value.charAt(0) == separator) {
            return new ParseResult.Fail(this.getTokenName() + " arguments may not start with " + separator + " : " + value);
        }
        if (value.charAt(value.length() - 1) == separator) {
            return new ParseResult.Fail(this.getTokenName() + " arguments may not end with " + separator + " : " + value);
        }
        if (value.indexOf(String.valueOf(new char[]{separator, separator})) != -1) {
            return new ParseResult.Fail(this.getTokenName() + " arguments uses double separator " + separator + separator + " : " + value);
        }
        return ParseResult.SUCCESS;
    }

    protected boolean hasIllegalSeparator(char separator, String value) {
        ParseResult pr = this.checkForIllegalSeparator(separator, value);
        if (pr.passed()) {
            pr.addMessagesToLog();
        }
        return !pr.passed();
    }

    protected ParseResult checkNonEmpty(String value) {
        if (value == null) {
            return new ParseResult.Fail(this.getTokenName() + " may not have null argument");
        }
        if (value.length() == 0) {
            return new ParseResult.Fail(this.getTokenName() + " may not have empty argument");
        }
        return ParseResult.SUCCESS;
    }

    protected boolean isEmpty(String value) {
        ParseResult pr = this.checkNonEmpty(value);
        if (pr.passed()) {
            pr.addMessagesToLog();
        }
        return !pr.passed();
    }

    protected ParseResult checkForInvalidXMLChars(String value) {
        for (char character : value.toCharArray()) {
            if (XMLChar.isValid((int)character)) continue;
            return new ParseResult.Fail("Invalid XML character 0x" + Integer.toString(character, 16) + " in " + value);
        }
        return ParseResult.SUCCESS;
    }

    public abstract String getTokenName();

    protected String getPrerequisiteString(LoadContext context, Collection<Prerequisite> prereqs) {
        return context.getPrerequisiteString(prereqs);
    }
}

