/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbstractExportToken;
import pcgen.util.Logging;

public class PortraitToken
extends AbstractExportToken {
    @Override
    public String getTokenName() {
        return "PORTRAIT";
    }

    @Override
    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        if ("PORTRAIT.THUMB".equals(tokenSource)) {
            return this.getThumbnailToken(display);
        }
        return display.getPortraitPath();
    }

    private String getThumbnailToken(CharacterDisplay display) {
        File thumbFile;
        BufferedImage thumb = this.generateThumb(display);
        if (thumb == null) {
            return null;
        }
        String pcgFilename = display.getFileName();
        if (StringUtils.isNotBlank(pcgFilename)) {
            String baseName = new File(pcgFilename).getName();
            if (baseName.indexOf(".pcg") > 0) {
                baseName = baseName.substring(0, baseName.indexOf(".pcg"));
            }
        } else {
            String baseName = display.getName();
        }
        try {
            thumbFile = File.createTempFile("pcgentmb_", ".png");
        }
        catch (IOException e1) {
            Logging.errorPrint("PortraitToken.getThumbnailToken failed", e1);
            return null;
        }
        try {
            ImageIO.write((RenderedImage)thumb, "PNG", thumbFile);
        }
        catch (IOException e) {
            Logging.errorPrint("PortraitToken.getThumbnailToken failed", e);
            return null;
        }
        return thumbFile.getAbsolutePath();
    }

    private BufferedImage generateThumb(CharacterDisplay display) {
        Rectangle cropRect = display.getPortraitThumbnailRect();
        BufferedImage portrait = null;
        try {
            File file = new File(display.getPortraitPath());
            if (file.isFile()) {
                portrait = ImageIO.read(file);
            }
        }
        catch (IOException ex) {
            Logging.errorPrint("Could not load image", ex);
        }
        if (portrait == null || cropRect == null) {
            return null;
        }
        BufferedImage thumb = portrait.getSubimage(cropRect.x, cropRect.y, cropRect.width, cropRect.height);
        thumb = this.getScaledInstance(thumb, 100, 100, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
        return thumb;
    }

    public BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        if (w < targetWidth || h < targetWidth) {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }
}

