/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.companionmod;

import java.util.Collection;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.list.CompanionList;
import pcgen.core.character.CompanionMod;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class TypeToken
extends AbstractNonEmptyToken<CompanionMod>
implements CDOMPrimaryToken<CompanionMod> {
    private static final Class<CompanionList> COMPANIONLIST_CLASS = CompanionList.class;

    @Override
    public String getTokenName() {
        return "TYPE";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CompanionMod mod, String value) {
        Type type = Type.getConstant(value);
        context.getObjectContext().addToList(mod, ListKey.TYPE, type);
        Category cat = context.getReferenceContext().constructNowIfNecessary(COMPANIONLIST_CLASS, value);
        if (cat == null) {
            return new ParseResult.Fail("Cannot find Companion List: " + value, context);
        }
        context.getReferenceContext().reassociateCategory(cat, mod);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CompanionMod mod) {
        Changes<Type> changes = context.getObjectContext().getListChanges(mod, ListKey.TYPE);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection<Type> added = changes.getAdded();
        if (added != null && !added.isEmpty()) {
            if (added.size() == 1) {
                return new String[]{((Object)added.iterator().next()).toString()};
            }
            Logging.errorPrint("CompanionMod " + mod.getKeyName() + " had more than one TYPE specified.  " + "A single TYPE is required for a CompanionMod.");
        }
        return null;
    }

    @Override
    public Class<CompanionMod> getTokenClass() {
        return CompanionMod.class;
    }
}

