/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.skill;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Skill;
import pcgen.core.kit.KitSkill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class SkillToken
extends AbstractTokenWithSeparator<KitSkill>
implements CDOMPrimaryToken<KitSkill> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    @Override
    public String getTokenName() {
        return "SKILL";
    }

    @Override
    public Class<KitSkill> getTokenClass() {
        return KitSkill.class;
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, KitSkill kitSkill, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            CDOMReference<Skill> ref = TokenUtilities.getTypeOrPrimitive(context, SKILL_CLASS, tokText);
            if (ref == null) {
                return ParseResult.INTERNAL_ERROR;
            }
            kitSkill.addSkill(ref);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitSkill kitSkill) {
        Collection<CDOMReference<Skill>> ref = kitSkill.getSkills();
        if (ref == null || ref.isEmpty()) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat(ref, "|")};
    }
}

