/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.Collection;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Race;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class StartfeatsToken
extends AbstractToken
implements CDOMPrimaryToken<Race> {
    @Override
    public String getTokenName() {
        return "STARTFEATS";
    }

    @Override
    public ParseResult parseToken(LoadContext context, Race race, String value) {
        int bonusValue;
        try {
            bonusValue = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Error encountered in " + this.getTokenName() + " was expecting value to be an integer, found: " + value, context);
        }
        BonusObj bon = Bonus.newBonus(context, "FEAT|POOL|" + bonusValue);
        if (bon == null) {
            return new ParseResult.Fail("Internal Error: " + this.getTokenName() + " had invalid bonus", context);
        }
        Prerequisite prereq = this.getPrerequisite("PREMULT:1,[PREHD:MIN=1],[PRELEVEL:MIN=1]");
        if (prereq == null) {
            return new ParseResult.Fail("Internal Error: " + this.getTokenName() + " had invalid prerequisite", context);
        }
        bon.addPrerequisite(prereq);
        bon.setTokenSource(this.getTokenName());
        context.getObjectContext().addToList(race, ListKey.BONUS, bon);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Race race) {
        Changes<BonusObj> changes = context.getObjectContext().getListChanges(race, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection<BonusObj> added = changes.getAdded();
        String tokenName = this.getTokenName();
        WeightedCollection<String> bonusSet = new WeightedCollection<String>(String.CASE_INSENSITIVE_ORDER);
        for (BonusObj bonus : added) {
            if (!tokenName.equals(bonus.getTokenSource())) continue;
            bonusSet.add(bonus.getValue());
        }
        if (bonusSet.isEmpty()) {
            return null;
        }
        return bonusSet.toArray(new String[bonusSet.size()]);
    }

    @Override
    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

