/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.ListStyle;

class BaseRListElement
extends RBlock {
    protected static final String DEFAULT_COUNTER_NAME = "$cobra.counter";
    protected ListStyle listStyle = null;

    public BaseRListElement(NodeImpl modelNode, int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext, RenderableContainer parentContainer) {
        super(modelNode, listNesting, pcontext, rcontext, frameContext, parentContainer);
    }

    protected void applyStyle(int availWidth, int availHeight) {
        int newStyleType;
        String typeAttributeText;
        int listType;
        String listStyleTypeText;
        this.listStyle = null;
        super.applyStyle(availWidth, availHeight);
        ModelNode rootNode = this.modelNode;
        if (!(rootNode instanceof HTMLElementImpl)) {
            return;
        }
        HTMLElementImpl rootElement = (HTMLElementImpl)rootNode;
        AbstractCSS2Properties props = rootElement.getCurrentStyle();
        if (props == null) {
            return;
        }
        ListStyle listStyle = null;
        String listStyleText = props.getListStyle();
        if (listStyleText != null) {
            listStyle = HtmlValues.getListStyle(listStyleText);
        }
        if ((listStyleTypeText = props.getListStyleType()) != null && (listType = HtmlValues.getListStyleType(listStyleTypeText)) != 256) {
            if (listStyle == null) {
                listStyle = new ListStyle();
            }
            listStyle.type = listType;
        }
        if ((listStyle == null || listStyle.type == 256) && (typeAttributeText = rootElement.getAttribute("type")) != null && (newStyleType = HtmlValues.getListStyleTypeDeprecated(typeAttributeText)) != 256) {
            if (listStyle == null) {
                this.listStyle = listStyle = new ListStyle();
            }
            listStyle.type = newStyleType;
        }
        this.listStyle = listStyle;
    }

    public String toString() {
        return "BaseRListElement[node=" + this.modelNode + "]";
    }
}

