/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.graph.inst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.base.graph.base.DirectionalHyperEdge;

public class DefaultDirectionalHyperEdge<N>
implements DirectionalHyperEdge<N> {
    private final List<N> sourceNodes;
    private final List<N> sinkNodes;

    public DefaultDirectionalHyperEdge(Collection<N> sourceNode, Collection<N> sinkNode) {
        if (sourceNode == null && sinkNode == null) {
            throw new IllegalArgumentException("Both Collections to DefaultDirectionalGraphEdge cannot be null");
        }
        this.sourceNodes = this.setNodes(sourceNode);
        this.sinkNodes = this.setNodes(sinkNode);
        if (this.sourceNodes == null && this.sinkNodes == null) {
            throw new IllegalArgumentException("GraphNode List of DefaultHyperEdge cannot be empty");
        }
    }

    private final List<N> setNodes(Collection<N> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        ArrayList<N> returnList = new ArrayList<N>(nodes.size());
        returnList.addAll(nodes);
        for (Object node : returnList) {
            if (node != null) continue;
            throw new IllegalArgumentException("List contains null");
        }
        return returnList;
    }

    @Override
    public N getNodeAt(int index) {
        if (this.sourceNodes != null && index < this.sourceNodes.size()) {
            return this.sourceNodes.get(index);
        }
        if (this.sinkNodes != null) {
            int sinkIndex = this.sourceNodes == null ? index : index - this.sourceNodes.size();
            return this.sinkNodes.get(sinkIndex);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<N> getAdjacentNodes() {
        ArrayList<N> returnList = new ArrayList<N>(this.getAdjacentNodeCount());
        if (this.sourceNodes != null) {
            returnList.addAll(this.sourceNodes);
        }
        if (this.sinkNodes != null) {
            returnList.addAll(this.sinkNodes);
        }
        return returnList;
    }

    @Override
    public boolean isAdjacentNode(N node) {
        if (this.sourceNodes != null && this.sourceNodes.contains(node)) {
            return true;
        }
        return this.sinkNodes != null && this.sinkNodes.contains(node);
    }

    @Override
    public int getAdjacentNodeCount() {
        if (this.sourceNodes == null) {
            return this.sinkNodes.size();
        }
        if (this.sinkNodes == null) {
            return this.sourceNodes.size();
        }
        int size = this.sourceNodes.size();
        for (N node : this.sinkNodes) {
            if (this.sourceNodes.contains(node)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public int getNodeInterfaceType(N node) {
        int type = 0;
        if (this.sourceNodes != null && this.sourceNodes.contains(node)) {
            type |= 1;
        }
        if (this.sinkNodes != null && this.sinkNodes.contains(node)) {
            type |= 2;
        }
        return type;
    }

    @Override
    public List<N> getSinkNodes() {
        return this.sinkNodes == null ? null : new ArrayList<N>(this.sinkNodes);
    }

    @Override
    public List<N> getSourceNodes() {
        return this.sourceNodes == null ? null : new ArrayList<N>(this.sourceNodes);
    }

    @Override
    public DefaultDirectionalHyperEdge<N> createReplacementEdge(Collection<N> newSourceNodes, Collection<N> newSinkNodes) {
        if (newSourceNodes == null) {
            throw new IllegalArgumentException("Incoming Collection to createReplacementEdge in DefaultGraphEdge cannot be null");
        }
        if (newSinkNodes == null) {
            throw new IllegalArgumentException("Outgoing Collection to createReplacementEdge in DefaultGraphEdge cannot be null");
        }
        return new DefaultDirectionalHyperEdge<N>(newSourceNodes, newSinkNodes);
    }
}

