/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;

public class RuntimeEnvironment {
    private static Boolean containsLine(String path, String line) {
        Boolean bl;
        block8: {
            Stream<String> stream2 = Files.lines(Paths.get(path, new String[0]));
            try {
                bl = stream2.anyMatch(test -> test.contains(line));
                if (stream2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream2 != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            stream2.close();
        }
        return bl;
    }

    public static Boolean inContainer() {
        return RuntimeEnvironment.inDocker() != false || RuntimeEnvironment.inPodman() != false;
    }

    static Boolean inDocker() {
        return RuntimeEnvironment.containsLine("/proc/1/cgroup", "/docker");
    }

    static Boolean inPodman() {
        return RuntimeEnvironment.containsLine("/proc/1/environ", "container=podman");
    }

    static Boolean inWsl() {
        return RuntimeEnvironment.containsLine("/proc/1/environ", "container=wslcontainer_host_id");
    }

    @Deprecated
    public RuntimeEnvironment() {
    }
}

