/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.sc.transformers;

import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.transform.sc.StaticCompilationMetadataKeys;
import org.codehaus.groovy.transform.sc.transformers.StaticCompilationTransformer;
import org.codehaus.groovy.transform.stc.StaticTypesMarker;

class PropertyExpressionTransformer {
    private final StaticCompilationTransformer scTransformer;

    PropertyExpressionTransformer(StaticCompilationTransformer scTransformer) {
        this.scTransformer = scTransformer;
    }

    Expression transformPropertyExpression(PropertyExpression pe) {
        MethodNode dmct = (MethodNode)pe.getNodeMetaData((Object)StaticTypesMarker.DIRECT_METHOD_CALL_TARGET);
        if (dmct != null && dmct.getParameters().length == 0) {
            MethodCallExpression mce = GeneralUtils.callX(this.scTransformer.transform(pe.getObjectExpression()), dmct.getName());
            mce.setImplicitThis(pe.isImplicitThis());
            mce.setMethodTarget(dmct);
            mce.setSourcePosition(pe);
            mce.setSpreadSafe(pe.isSpreadSafe());
            mce.setSafe(pe.isSafe());
            mce.copyNodeMetaData(pe);
            return mce;
        }
        FieldNode field = (FieldNode)pe.getNodeMetaData((Object)StaticTypesMarker.PV_FIELDS_ACCESS);
        if (field == null) {
            field = (FieldNode)pe.getNodeMetaData((Object)StaticTypesMarker.PV_FIELDS_MUTATION);
        }
        if (field != null) {
            AttributeExpression ae;
            if (field.isStatic()) {
                ae = new AttributeExpression((Expression)GeneralUtils.classX(field.getDeclaringClass()), pe.getProperty());
            } else if (!ExpressionUtils.isThisExpression(pe.getObjectExpression())) {
                ae = new AttributeExpression(this.scTransformer.transform(pe.getObjectExpression()), pe.getProperty(), pe.isSafe());
            } else {
                ae = new AttributeExpression(new PropertyExpression((Expression)GeneralUtils.classX(field.getDeclaringClass()), "this"), pe.getProperty(), pe.isSafe());
                ae.getObjectExpression().putNodeMetaData((Object)StaticCompilationMetadataKeys.PROPERTY_OWNER, field.getDeclaringClass());
                ae.getObjectExpression().putNodeMetaData((Object)StaticTypesMarker.INFERRED_TYPE, field.getDeclaringClass());
            }
            ae.setSpreadSafe(pe.isSpreadSafe());
            ae.setSourcePosition(pe);
            ae.copyNodeMetaData(pe);
            return ae;
        }
        return this.scTransformer.superTransform(pe);
    }
}

