/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jlibs.core.io.EncodingDetector;
import jlibs.core.io.IOUtil;

public class UnicodeInputStream
extends FilterInputStream {
    private ByteBuffer marker = ByteBuffer.allocate(4);
    public final String encoding;
    public final boolean hasBOM;

    public UnicodeInputStream(InputStream delegate) throws IOException {
        this(delegate, EncodingDetector.DEFAULT);
    }

    public UnicodeInputStream(InputStream delegate, EncodingDetector detector) throws IOException {
        super(delegate);
        int len = IOUtil.readFully(delegate, this.marker.array());
        this.marker.limit(len);
        this.encoding = detector.detect(this.marker);
        boolean bl = this.hasBOM = this.marker.position() > 0;
        if (!this.marker.hasRemaining()) {
            this.marker = null;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.marker != null) {
            int b = this.marker.get() & 0xFF;
            if (!this.marker.hasRemaining()) {
                this.marker = null;
            }
            return b;
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.marker != null) {
            int read = Math.min(this.marker.remaining(), len);
            System.arraycopy(this.marker.array(), this.marker.position(), b, off, read);
            if (read == this.marker.remaining()) {
                this.marker = null;
            } else {
                this.marker.position(this.marker.position() + read);
            }
            return read;
        }
        return super.read(b, off, len);
    }

    public InputStreamReader createReader() {
        if (this.encoding == null) {
            return new InputStreamReader(this);
        }
        return new InputStreamReader((InputStream)this, Charset.forName(this.encoding));
    }
}

