/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import org.gradle.api.Describable;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.internal.Describables;
import org.gradle.util.Path;

public final class ProjectIdentity
implements Describable {
    private final BuildIdentifier buildIdentifier;
    private final Path buildTreePath;
    private final Path projectPath;
    private final String projectName;
    private final Describable displayName;

    public ProjectIdentity(BuildIdentifier buildIdentifier, Path buildTreePath, Path projectPath, String projectName) {
        this.buildIdentifier = buildIdentifier;
        this.buildTreePath = buildTreePath;
        this.projectPath = projectPath;
        this.projectName = projectName;
        String prefix = Path.ROOT.equals((Object)buildTreePath) ? "root project" : "project";
        this.displayName = Describables.memoize((Describable)Describables.of((Object)prefix, (Object)buildTreePath.getPath()));
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    public Path getBuildTreePath() {
        return this.buildTreePath;
    }

    public Path getProjectPath() {
        return this.projectPath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectIdentity that = (ProjectIdentity)o;
        return this.buildTreePath.equals((Object)that.buildTreePath);
    }

    public int hashCode() {
        return this.buildTreePath.hashCode();
    }
}

