/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline.libclone;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.hsqldb.cmdline.libclone.BasicTextJdkLogFormatter;

public class FrameworkLogger {
    private static Map loggerInstances = new HashMap();
    private static Map jdkToLog4jLevels = new HashMap();
    private static Method log4jGetLogger;
    private static Method log4jLogMethod;
    private static boolean callerFqcnAvailable;
    private Object log4jLogger;
    private Logger jdkLogger;
    private static boolean noopMode;

    public static synchronized String report() {
        return loggerInstances.size() + " logger instances:  " + loggerInstances.keySet();
    }

    public static synchronized void clearLoggers(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = loggerInstances.keySet().iterator();
        String string2 = string + '.';
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string3.equals(string) && !string3.startsWith(string2)) continue;
            hashSet.add(string3);
        }
        loggerInstances.keySet().removeAll(hashSet);
    }

    private static synchronized void populateJdkToLog4jLevels(String string) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method method = Class.forName(string).getMethod("toLevel", String.class);
        jdkToLog4jLevels.put(Level.ALL, method.invoke(null, "ALL"));
        jdkToLog4jLevels.put(Level.FINER, method.invoke(null, "DEBUG"));
        jdkToLog4jLevels.put(Level.SEVERE, method.invoke(null, "FATAL"));
        jdkToLog4jLevels.put(Level.INFO, method.invoke(null, "INFO"));
        jdkToLog4jLevels.put(Level.OFF, method.invoke(null, "OFF"));
        jdkToLog4jLevels.put(Level.FINEST, method.invoke(null, "TRACE"));
        jdkToLog4jLevels.put(Level.WARNING, method.invoke(null, "WARN"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reconfigure() {
        noopMode = false;
        Class<?> clazz = null;
        Class<?> clazz2 = null;
        loggerInstances.clear();
        jdkToLog4jLevels.clear();
        log4jGetLogger = null;
        log4jLogMethod = null;
        callerFqcnAvailable = false;
        try {
            clazz = Class.forName("org.apache.logging.log4j.Logger");
            clazz2 = Class.forName("org.apache.logging.log4j.LogManager");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                FrameworkLogger.populateJdkToLog4jLevels("org.apache.logging.log4j.Level");
                log4jLogMethod = clazz.getMethod("log", Class.forName("org.apache.logging.log4j.Level"), Object.class, Throwable.class);
                log4jGetLogger = clazz2.getMethod("getLogger", String.class);
                return;
            }
            catch (Exception exception) {
                try {
                    System.err.println("<clinit> failure instantiating configured Log4j v2 system: " + exception);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        clazz = null;
        clazz2 = null;
        log4jLogMethod = null;
        log4jGetLogger = null;
        jdkToLog4jLevels.clear();
        try {
            clazz = Class.forName("org.apache.log4j.Logger");
            clazz2 = clazz;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                FrameworkLogger.populateJdkToLog4jLevels("org.apache.log4j.Level");
                log4jLogMethod = clazz.getMethod("log", String.class, Class.forName("org.apache.log4j.Priority"), Object.class, Throwable.class);
                log4jGetLogger = clazz2.getMethod("getLogger", String.class);
                callerFqcnAvailable = true;
                return;
            }
            catch (Exception exception) {
                try {
                    System.err.println("<clinit> failure instantiating configured Log4j v1 system: " + exception);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        clazz = null;
        clazz2 = null;
        log4jLogMethod = null;
        log4jGetLogger = null;
        callerFqcnAvailable = false;
        jdkToLog4jLevels.clear();
        String string = System.getProperty("hsqldb.reconfig_logging");
        if (string == null || !string.equalsIgnoreCase("true")) {
            return;
        }
        InputStream inputStream = null;
        try {
            LogManager logManager = LogManager.getLogManager();
            if (System.getProperty("java.util.logging.config.class") != null || System.getProperty("java.util.logging.config.file") != null) {
                logManager.readConfiguration();
                return;
            }
            String string2 = "/org/hsqldb/cmdline/jdklogging-default.properties";
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new BasicTextJdkLogFormatter(false));
            consoleHandler.setLevel(Level.INFO);
            inputStream = FrameworkLogger.class.getResourceAsStream(string2);
            if (inputStream == null) {
                throw new Exception("Failed to resolve default logging config from'" + string2 + "'");
            }
            logManager.readConfiguration(inputStream);
            Logger logger = Logger.getLogger("org.hsqldb.cmdline");
            logger.addHandler(consoleHandler);
            logger.setUseParentHandlers(false);
        }
        catch (Exception exception) {
            noopMode = true;
            System.err.println("<clinit> failure initializing JDK logging system.  Continuing without Application logging.  " + exception);
            exception.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to close logging input stream: " + iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameworkLogger(String string) {
        if (!noopMode) {
            if (log4jGetLogger == null) {
                this.jdkLogger = Logger.getLogger(string);
            } else {
                try {
                    this.log4jLogger = log4jGetLogger.invoke(null, string);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Failed to instantiate Log4j Logger", exception);
                }
            }
        }
        Class<FrameworkLogger> clazz = FrameworkLogger.class;
        synchronized (FrameworkLogger.class) {
            loggerInstances.put(string, this);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static FrameworkLogger getLog(Class clazz) {
        return FrameworkLogger.getLog(clazz.getName());
    }

    public static FrameworkLogger getLog(Class clazz, String string) {
        return string == null ? FrameworkLogger.getLog(clazz) : FrameworkLogger.getLog(string + '.' + clazz.getName());
    }

    public static FrameworkLogger getLog(String string, String string2) {
        return string2 == null ? FrameworkLogger.getLog(string) : FrameworkLogger.getLog(string2 + '.' + string);
    }

    public static synchronized FrameworkLogger getLog(String string) {
        if (loggerInstances.containsKey(string)) {
            return (FrameworkLogger)loggerInstances.get(string);
        }
        return new FrameworkLogger(string);
    }

    public void log(Level level, String string, Throwable throwable) {
        this.privlog(level, string, throwable, 2, FrameworkLogger.class);
    }

    public void privlog(Level level, String string, Throwable throwable, int n, Class clazz) {
        if (noopMode) {
            return;
        }
        if (this.log4jLogger == null) {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            String string2 = "";
            String string3 = "";
            if (stackTraceElementArray.length > n) {
                string2 = stackTraceElementArray[n].getClassName();
                string3 = stackTraceElementArray[n].getMethodName();
            }
            if (throwable == null) {
                this.jdkLogger.logp(level, string2, string3, string);
            } else {
                this.jdkLogger.logp(level, string2, string3, string, throwable);
            }
        } else {
            try {
                Object[] objectArray = callerFqcnAvailable ? new Object[]{clazz.getName(), jdkToLog4jLevels.get(level), string, throwable} : new Object[]{jdkToLog4jLevels.get(level), string, throwable};
                log4jLogMethod.invoke(this.log4jLogger, objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Logging failed when attempting to log: " + string, exception);
            }
        }
    }

    public void enduserlog(Level level, String string) {
        if (noopMode) {
            return;
        }
        if (this.log4jLogger == null) {
            String string2 = FrameworkLogger.class.getName();
            String string3 = "\\l";
            this.jdkLogger.logp(level, string2, string3, string);
        } else {
            try {
                Object[] objectArray = callerFqcnAvailable ? new Object[]{FrameworkLogger.class.getName(), jdkToLog4jLevels.get(level), string, null} : new Object[]{jdkToLog4jLevels.get(level), string, null};
                log4jLogMethod.invoke(this.log4jLogger, objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Logging failed when attempting to log: " + string, exception);
            }
        }
    }

    public void log(Level level, String string) {
        this.privlog(level, string, null, 2, FrameworkLogger.class);
    }

    public void finer(String string) {
        this.privlog(Level.FINER, string, null, 2, FrameworkLogger.class);
    }

    public void warning(String string) {
        this.privlog(Level.WARNING, string, null, 2, FrameworkLogger.class);
    }

    public void severe(String string) {
        this.privlog(Level.SEVERE, string, null, 2, FrameworkLogger.class);
    }

    public void info(String string) {
        this.privlog(Level.INFO, string, null, 2, FrameworkLogger.class);
    }

    public void finest(String string) {
        this.privlog(Level.FINEST, string, null, 2, FrameworkLogger.class);
    }

    public void error(String string) {
        this.privlog(Level.WARNING, string, null, 2, FrameworkLogger.class);
    }

    public void finer(String string, Throwable throwable) {
        this.privlog(Level.FINER, string, throwable, 2, FrameworkLogger.class);
    }

    public void warning(String string, Throwable throwable) {
        this.privlog(Level.WARNING, string, throwable, 2, FrameworkLogger.class);
    }

    public void severe(String string, Throwable throwable) {
        this.privlog(Level.SEVERE, string, throwable, 2, FrameworkLogger.class);
    }

    public void info(String string, Throwable throwable) {
        this.privlog(Level.INFO, string, throwable, 2, FrameworkLogger.class);
    }

    public void finest(String string, Throwable throwable) {
        this.privlog(Level.FINEST, string, throwable, 2, FrameworkLogger.class);
    }

    public void error(String string, Throwable throwable) {
        this.privlog(Level.WARNING, string, throwable, 2, FrameworkLogger.class);
    }

    static {
        callerFqcnAvailable = false;
        try {
            FrameworkLogger.reconfigure();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

