/*
 *  arch/arm/mach-dw/include/mach/headset.h
 *
 *  Copyright (C) 2009 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_HEADSET_H
#define __ASM_ARCH_HEADSET_H
#include <linux/switch.h>
#include <linux/spinlock.h>
#include <linux/semaphore.h>
#include <linux/device.h>
#include <linux/timer.h>
#include <linux/workqueue.h>


#define HSDET_POLL_PERIOD	 130 /* mSec */
#define HSDET_DEBOUNCE_PERIOD	  20 /* mSec */
#define HSDET_DEBOUNCE_TIMES	   4

/* TEL changes: for Headset detection event */
// FIXME: A.M. This decleration should be in a using .c file, IMO,
// 	since 'struct headset_device' is not known here.
//	Currently there is no reference to it in the kernel .c or .h files
//	at all !
#define to_headset_device(obj) container_of(obj, struct headset_device, dev)


struct dwheadset_config {
	unsigned int headsetdetpin;
	unsigned int mic_select_pin;
	struct gpio_switch_platform_data switch_platform_data;
	struct resource *headset_resource;
};

struct headset_dev {
	struct class *headset_class;
	int headset_det_state;
	spinlock_t headset_state_lock;
	int poll_period;
	int debounce_period;
	int debounce_times;
	struct device *g_dev;	
	struct device dev;
	struct switch_dev headset_sdev;
	struct platform_device *pdev;
	struct dp52* dp52;
	const char *name_on;
	const char *name_off;
	const char *state_on;
	const char *state_off;
	int dp52_interrupt;
	struct dwheadset_config *conf;
};

struct headsetdet_cb {
	void (*pHeadsetDetCBfn)(int);
	struct list_head list;

};


void dw_headset_det_init(void);
bool dw_headsetdet_cb_register(void (*pfn)(int));
bool dw_headsetdet_cb_unregister(void (*pfn)(int));
int dw_headsetdet_get_headsetstate(void);

#endif /* __ASM_ARCH_HEADSET_H */

