/*
 *  linux/arch/arm/mach-dmw/include/mach/system.h
 *
 *  Copyright (C) 2010 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __MACH_SYSTEM_H
#define __MACH_SYSTEM_H

#include <mach/hardware.h>
#include <asm/io.h>
#include <mach/platform.h>
#include <asm/setup.h>


#define DMW_RECOVERY_DATASIZE 64

static inline void arch_idle(void)
{
	/*
	 * This should do all the clock switching
	 * and wait for interrupt tricks
	 */
	cpu_do_idle();
}

static inline void arch_reset(char mode, const char *cmd)
{
	unsigned int value;
	u32 pRecovery;

	/*Since the MMU mappings are remapped to  1:1 in case of soft reboot , so PA == VA */
	pRecovery = (u32)((DMW_SRAM_BASE + SZ_64K) - DMW_RECOVERY_DATASIZE);
	memset((void*)pRecovery,0,DMW_RECOVERY_DATASIZE);
	strncpy((char*)pRecovery,cmd,DMW_RECOVERY_DATASIZE);

	//Clear WDRSTIND and SWRSTIND before SW resetting the DW
	value = readl(IO_ADDRESS(DMW_CMU_BASE) + DMW_CMU_RSTSR);
	value |= (1<<5) | (1<<4) | (1<<3);
	writel(value, IO_ADDRESS(DMW_CMU_BASE) + DMW_CMU_RSTSR);
	writel(0x7496398B, IO_ADDRESS(DMW_CMU_BASE) + DMW_CMU_SWSYSRST);
	writel(0xB5C9C674, IO_ADDRESS(DMW_CMU_BASE) + DMW_CMU_SWSYSRST);
}

#endif
