/*
 *  linux/arch/arm/mach-dmw/pm.h
 *
 *  Copyright (C) 2011 DSP Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __MACH_PM_H
#define __MACH_PM_H

#define SLEEP_DDR_MODE_1	(1 << 4)
#define SLEEP_DDR_MODE_2	(1 << 3)
#define SLEEP_DDR_MODE_3	(1 << 2)
#define SLEEP_DDR_MODE_4	(1 << 1)

#define SLEEP_CHECK_BM		0x0100	/* Don't enter if a bus master is active */
#define SLEEP_DDR_PLL_OFF	0x0600	/* (Try to) switch off PLL3 */
#define __SLEEP_PLL3_OFF	0x0200
#define __SLEEP_DDR_12M		0x0400
#define SLEEP_CPU_PLL_OFF	0x1800	/* (Try to) switch off PLL2 */
#define __SLEEP_PLL2_OFF	0x0800
#define __SLEEP_CPU_12M		0x1000

#define SLEEP_QUIRK_DIS_INP	0x10000	/* Disable input buffer in self refresh */

#ifndef __ASSEMBLER__

#include <asm/atomic.h>

struct dmw_pm_pdata {
	unsigned overdrive_gpio;
	unsigned dram_rtt_gpio;
};

extern atomic_t dmw_active_bm_cnt; /* Number of active bus masters */
void dmw_clk_print_active(void);

extern void
dmw_sleep_selfrefresh(int flags, void *denali_base, unsigned overdrive_gpio, unsigned dram_rtt_gpio);

extern void dmw_wifi_busy(void);
extern void dmw_wifi_idle(void);
extern void dmw_usb1_busy(void);
extern void dmw_usb1_idle(void);
extern void dmw_usb2_busy(void);
extern void dmw_usb2_idle(void);
extern void dmw_css_busy(void);
extern void dmw_css_idle(void);

#endif

#endif
