/*
 * drivers/media/video/ov3640.c
 *
 * ov3640 sensor driver
 *
 *
 * Copyright (C) 2008 Texas Instruments.
 *
 * Leverage ov3640.c
 *
 * This file is licensed under the terms of the GNU General Public License
 * version 2. This program is licensed "as is" without any warranty of any
 * kind, whether express or implied.
 */

#include <linux/io.h>
#include <linux/i2c.h>
#include <linux/delay.h>
#include <media/v4l2-int-device.h>
#include <media/ov3640.h>
#include <linux/dma-mapping.h> /*For page align*/
#include "ov3640_regs.h"
#include <media/dmw96ciu.h>
#include <mach/hardware.h>
#include <mach/camera.h>

//#define CONFIG_SENSOR_FPS_MULTI_SUPPORT

#define OV3640_DRIVER_NAME  "ov3640"
#define MOD_NAME "OV3640: "

#define I2C_M_WR 0

#define OV3640_USE_XCLKA       0
#define OV3640_USE_XCLKB       1

#define OV3640_CSI2_VIRTUAL_ID 0x1

/* FPS Capabilities */
#define OV3640_MIN_FPS                 3
#define OV3640_DEF_FPS                 15
#define OV3640_MAX_FPS                 30

#define OV3640_MIN_BRIGHT              0
#define OV3640_MAX_BRIGHT              6
#define OV3640_DEF_BRIGHT              0
#define OV3640_BRIGHT_STEP             1

#define OV3640_DEF_CONTRAST            0
#define OV3640_MIN_CONTRAST            0
#define OV3640_MAX_CONTRAST            6
#define OV3640_CONTRAST_STEP           1

#define OV3640_DEF_COLOR               0
#define OV3640_MIN_COLOR               0
#define OV3640_MAX_COLOR               2
#define OV3640_COLOR_STEP              1

#define OV3640_DEF_FLIP               	0

#define OV3640_DEF_MIRRO               	0

#define SENSOR_DETECTED                1
#define SENSOR_NOT_DETECTED    0

/* NOTE: Set this as 0 for enabling SoC mode */
#define OV3640_RAW_MODE        0

/* XCLK Frequency in Hz*/
#define OV3640_XCLK_MIN                24000000
#define OV3640_XCLK_MAX                24000000


/* High byte of product ID */
#define OV3640_PIDH_MAGIC      0x36
/* Low byte of product ID  */
#define OV3640_PIDL_MAGIC1     0x41
#define OV3640_PIDL_MAGIC2     0x4C

#define OV3640_REG_TERM 0xFFFF /* terminating list entry for reg */
#define OV3640_VAL_TERM 0xFF   /* terminating list entry for val */

#define vidioc_int_s_reg_num (vidioc_int_priv_start_num + 1)
V4L2_INT_WRAPPER_1(s_reg, const struct v4l2_dbg_register, *);

#define vidioc_int_g_reg_num (vidioc_int_priv_start_num + 2)
V4L2_INT_WRAPPER_1(g_reg, const struct v4l2_dbg_register, *);

static dmw_camera_sensor_desc_t ov3640_sensor_desc;

struct ov3640_reg {
	unsigned int reg;
	unsigned char val;
};

#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
enum image_size_ov {
	XGA,
	QXGA,
};
#else
enum image_size_ov {
	QQVGA,
	QCIF,
	QVGA,
	CIF,
	VGA,
	XGA,
	QXGA,
};	
#endif

enum pixel_format_ov {
	YUV,
	RGB565,
	RGB555,
	RAW10
};

#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
enum ov3640_frameintervals_type {
	OV34_3_FPS,
	OV34_5_FPS,
	OV34_7_5_FPS,
	OV34_10_FPS,
	OV34_15_FPS,
	OV34_20_FPS,
	OV34_30_FPS,
};
#else
enum ov3640_frameintervals_type {
	OV34_15_FPS,
	OV34_30_FPS,
};
#endif

#define OV_NUM_IMAGE_SIZES             2
#define OV_NUM_PIXEL_FORMATS           4

struct capture_size_ov {
	unsigned long width;
	unsigned long height;
};

#ifndef CONFIG_SENSOR_FPS_MULTI_SUPPORT
struct reg_value {
	u16 u16RegAddr;
	u8 u8Val;
	u8 u8Mask;
	u32 u32Delay_ms;
};

enum ov3640_mode {
	OV3640_MODE_MIN = 0,
	OV3640_MODE_QQVGA_160_120 = 0,
	OV3640_MODE_QCIF_176_144 = 1,
	OV3640_MODE_QVGA_320_240 = 2,
	OV3640_MODE_CIF_352_288 = 3,
	OV3640_MODE_VGA_640_480 = 4,
	OV3640_MODE_XGA_1024_768 = 5,
	OV3640_MODE_QXGA_2048_1536 = 6,
	OV3640_MODE_MAX = 6
};

struct ov3640_mode_info {
	enum ov3640_mode mode;
	u32 width;
	u32 height;
	struct reg_value *init_data_ptr;
	u32 init_data_size;
};

static struct reg_value ov3640_setting_30fps_QQVGA_160_120[] = {
	{0x304d, 0x45}, {0x30a7, 0x5e}, {0x3087, 0x16}, {0x309C, 0x1a}, 
	{0x30a2, 0xe4}, {0x30aa, 0x42}, {0x30b0, 0xff}, {0x30b1, 0xff}, 
	{0x30b2, 0x18}, {0x300e, 0x39}, {0x300f, 0x21}, {0x3010, 0x20}, 
	{0x304c, 0x81}, {0x30d7, 0x10}, {0x30d9, 0x0d}, {0x30db, 0x08}, 
	{0x3016, 0x82}, {0x3018, 0x48}, {0x3019, 0x40}, {0x301a, 0x82}, 
	{0x307d, 0x00}, {0x3087, 0x02}, {0x3082, 0x20}, {0x3015, 0x12}, 
	{0x3014, 0x84}, {0x3013, 0xf7}, {0x303c, 0x08}, {0x303d, 0x18}, 
	{0x303e, 0x06}, {0x303F, 0x0c}, {0x3030, 0x62}, {0x3031, 0x26}, 
	{0x3032, 0xe6}, {0x3033, 0x6e}, {0x3034, 0xea}, {0x3035, 0xae}, 
	{0x3036, 0xa6}, {0x3037, 0x6a}, {0x3104, 0x02}, {0x3105, 0xfd}, 
	{0x3106, 0x00}, {0x3107, 0xff}, {0x3300, 0x13}, {0x3301, 0xde}, 
	{0x3302, 0xcf}, {0x3312, 0x26}, {0x3314, 0x42}, {0x3313, 0x2b}, 
	{0x3315, 0x42}, {0x3310, 0xd0}, {0x3311, 0xbd}, {0x330c, 0x18}, 
	{0x330d, 0x18}, {0x330e, 0x56}, {0x330f, 0x5c}, {0x330b, 0x1c}, 
	{0x3306, 0x5c}, {0x3307, 0x11}, {0x336a, 0x52}, {0x3370, 0x46}, 
	{0x3376, 0x38}, {0x30b8, 0x20}, {0x30b9, 0x17}, {0x30ba, 0x00}, 
	{0x30bb, 0x08}, {0x3507, 0x06}, {0x350a, 0x4f}, {0x3100, 0x02}, 
	{0x3301, 0xde}, {0x3304, 0xfc}, {0x3400, 0x00}, {0x3404, 0x02}, 
	{0x3600, 0xc0}, {0x3088, 0x08}, {0x3089, 0x00}, {0x308a, 0x06}, 
	{0x308b, 0x00}, {0x308d, 0x04}, {0x3086, 0x03}, {0x3086, 0x00}, 
	{0x30a9, 0xb5}, {0x3317, 0x04}, {0x3316, 0xf8}, {0x3312, 0x31}, 
	{0x3314, 0x57}, {0x3313, 0x28}, {0x3315, 0x3d}, {0x3311, 0xd0}, 
	{0x3310, 0xb6}, {0x330c, 0x16}, {0x330d, 0x16}, {0x330e, 0x5f}, 
	{0x330f, 0x5c}, {0x330b, 0x18}, {0x3306, 0x5c}, {0x3307, 0x11}, 
	{0x3308, 0x25}, {0x3340, 0x20}, {0x3341, 0x58}, {0x3342, 0x08}, 
	{0x3343, 0x21}, {0x3344, 0xbe}, {0x3345, 0xe0}, {0x3346, 0xca}, 
	{0x3347, 0xc6}, {0x3348, 0x04}, {0x3349, 0x98}, {0x3355, 0x02}, 
	{0x3358, 0x44}, {0x3359, 0x44}, {0x3300, 0x13}, {0x3367, 0x23}, 
	{0x3368, 0xBB}, {0x3369, 0xD6}, {0x336A, 0x2A}, {0x336B, 0x07}, 
	{0x336C, 0x00}, {0x336D, 0x23}, {0x336E, 0xC3}, {0x336F, 0xDE}, 
	{0x3370, 0x2b}, {0x3371, 0x07}, {0x3372, 0x00}, {0x3373, 0x23}, 
	{0x3374, 0x9e}, {0x3375, 0xD6}, {0x3376, 0x29}, {0x3377, 0x07}, 
	{0x3378, 0x00}, {0x332a, 0x1d}, {0x331b, 0x08}, {0x331c, 0x16}, 
	{0x331d, 0x2d}, {0x331e, 0x54}, {0x331f, 0x66}, {0x3320, 0x73}, 
	{0x3321, 0x80}, {0x3322, 0x8c}, {0x3323, 0x95}, {0x3324, 0x9d}, 
	{0x3325, 0xac}, {0x3326, 0xb8}, {0x3327, 0xcc}, {0x3328, 0xdd}, 
	{0x3329, 0xee}, {0x332e, 0x04}, {0x332f, 0x06}, {0x3331, 0x03}, 

	{0x3013, 0xf7}, {0x3012, 0x10}, {0x3023, 0x06}, {0x3026, 0x03}, 
	{0x3027, 0x04}, {0x302a, 0x03}, {0x302b, 0x10}, {0x301c, 0x03}, 
	{0x301d, 0x04}, {0x3071, 0xc9}, {0x3073, 0xc2}, {0x3075, 0x24}, 
	{0x300d, 0x01}, {0x30d7, 0x90}, {0x3069, 0x04}, {0x303e, 0x00}, 
	{0x303f, 0xc0}, {0x300e, 0x32}, {0x300f, 0x21}, {0x3010, 0x20}, 
	{0x3011, 0x00}, {0x3302, 0xef}, 

	{0x335f, 0x34, 0, 0}, {0x3360, 0x08, 0, 0}, {0x3361, 0x04, 0, 0}, /* ISP Input */
	{0x3362, 0x00, 0, 0}, {0x3363, 0xA8, 0, 0}, {0x3364, 0x7c, 0, 0}, /* ISP Output */
	{0x3403, 0x42, 0, 0}, 
	{0x3088, 0x00, 0, 0}, {0x3089, 0xA0, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x00, 0, 0}, {0x308b, 0x78, 0, 0}, 		/* DVP Vertical Output */
	{0x304c, 0x89, 0, 0}, 

	{0x300e, 0x32}, {0x300f, 0x21}, {0x3011, 0x00}, 
	{0x302a, 0x03}, {0x302b, 0x10}, {0x301c, 0x03}, 
	{0x301d, 0x04}, {0x3071, 0xc9}, {0x3073, 0xc2}, {0x363f, 0x13, 0, 0},
};

static struct reg_value ov3640_setting_15fps_QQVGA_160_120[] = {
	{0x304d, 0x45}, {0x30a7, 0x5e}, {0x3087, 0x16}, {0x309C, 0x1a}, 
	{0x30a2, 0xe4}, {0x30aa, 0x42}, {0x30b0, 0xff}, {0x30b1, 0xff}, 
	{0x30b2, 0x18}, {0x300e, 0x39}, {0x300f, 0x21}, {0x3010, 0x20}, 
	{0x304c, 0x81}, {0x30d7, 0x10}, {0x30d9, 0x0d}, {0x30db, 0x08}, 
	{0x3016, 0x82}, {0x3018, 0x48}, {0x3019, 0x40}, {0x301a, 0x82}, 
	{0x307d, 0x00}, {0x3087, 0x02}, {0x3082, 0x20}, {0x3015, 0x12}, 
	{0x3014, 0x84}, {0x3013, 0xf7}, {0x303c, 0x08}, {0x303d, 0x18}, 
	{0x303e, 0x06}, {0x303F, 0x0c}, {0x3030, 0x62}, {0x3031, 0x26}, 
	{0x3032, 0xe6}, {0x3033, 0x6e}, {0x3034, 0xea}, {0x3035, 0xae}, 
	{0x3036, 0xa6}, {0x3037, 0x6a}, {0x3104, 0x02}, {0x3105, 0xfd}, 
	{0x3106, 0x00}, {0x3107, 0xff}, {0x3300, 0x13}, {0x3301, 0xde}, 
	{0x3302, 0xcf}, {0x3312, 0x26}, {0x3314, 0x42}, {0x3313, 0x2b}, 
	{0x3315, 0x42}, {0x3310, 0xd0}, {0x3311, 0xbd}, {0x330c, 0x18}, 
	{0x330d, 0x18}, {0x330e, 0x56}, {0x330f, 0x5c}, {0x330b, 0x1c}, 
	{0x3306, 0x5c}, {0x3307, 0x11}, {0x336a, 0x52}, {0x3370, 0x46}, 
	{0x3376, 0x38}, {0x30b8, 0x20}, {0x30b9, 0x17}, {0x30ba, 0x00}, 
	{0x30bb, 0x08}, {0x3507, 0x06}, {0x350a, 0x4f}, {0x3100, 0x02}, 
	{0x3301, 0xde}, {0x3304, 0xfc}, {0x3400, 0x00}, {0x3404, 0x02}, 
	{0x3600, 0xc0}, {0x3088, 0x08}, {0x3089, 0x00}, {0x308a, 0x06}, 
	{0x308b, 0x00}, {0x308d, 0x04}, {0x3086, 0x03}, {0x3086, 0x00}, 
	{0x30a9, 0xb5}, {0x3317, 0x04}, {0x3316, 0xf8}, {0x3312, 0x31}, 
	{0x3314, 0x57}, {0x3313, 0x28}, {0x3315, 0x3d}, {0x3311, 0xd0}, 
	{0x3310, 0xb6}, {0x330c, 0x16}, {0x330d, 0x16}, {0x330e, 0x5f}, 
	{0x330f, 0x5c}, {0x330b, 0x18}, {0x3306, 0x5c}, {0x3307, 0x11}, 
	{0x3308, 0x25}, {0x3340, 0x20}, {0x3341, 0x58}, {0x3342, 0x08}, 
	{0x3343, 0x21}, {0x3344, 0xbe}, {0x3345, 0xe0}, {0x3346, 0xca}, 
	{0x3347, 0xc6}, {0x3348, 0x04}, {0x3349, 0x98}, {0x3355, 0x02}, 
	{0x3358, 0x44}, {0x3359, 0x44}, {0x3300, 0x13}, {0x3367, 0x23}, 
	{0x3368, 0xBB}, {0x3369, 0xD6}, {0x336A, 0x2A}, {0x336B, 0x07}, 
	{0x336C, 0x00}, {0x336D, 0x23}, {0x336E, 0xC3}, {0x336F, 0xDE}, 
	{0x3370, 0x2b}, {0x3371, 0x07}, {0x3372, 0x00}, {0x3373, 0x23}, 
	{0x3374, 0x9e}, {0x3375, 0xD6}, {0x3376, 0x29}, {0x3377, 0x07}, 
	{0x3378, 0x00}, {0x332a, 0x1d}, {0x331b, 0x08}, {0x331c, 0x16}, 
	{0x331d, 0x2d}, {0x331e, 0x54}, {0x331f, 0x66}, {0x3320, 0x73}, 
	{0x3321, 0x80}, {0x3322, 0x8c}, {0x3323, 0x95}, {0x3324, 0x9d}, 
	{0x3325, 0xac}, {0x3326, 0xb8}, {0x3327, 0xcc}, {0x3328, 0xdd}, 
	{0x3329, 0xee}, {0x332e, 0x04}, {0x332f, 0x06}, {0x3331, 0x03},

	{0x3013, 0xf7}, {0x3012, 0x10}, {0x3023, 0x06}, {0x3026, 0x03}, 
	{0x3027, 0x04}, {0x302a, 0x03}, {0x302b, 0x10}, {0x301c, 0x03}, 
	{0x301d, 0x04}, {0x3071, 0xc9}, {0x3073, 0xc2}, {0x3075, 0x24}, 
	{0x300d, 0x01}, {0x30d7, 0x90}, {0x3069, 0x04}, {0x303e, 0x00}, 
	{0x303f, 0xc0}, {0x300e, 0x32}, {0x300f, 0x21}, {0x3010, 0x20}, 
	{0x3011, 0x00}, {0x3302, 0xef}, 

	{0x335f, 0x34, 0, 0}, {0x3360, 0x08, 0, 0}, {0x3361, 0x04, 0, 0}, /* ISP Input */
	{0x3362, 0x00, 0, 0}, {0x3363, 0xA8, 0, 0}, {0x3364, 0x7c, 0, 0}, /* ISP Output */
	{0x3403, 0x42, 0, 0}, 
	{0x3088, 0x00, 0, 0}, {0x3089, 0xA0, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x00, 0, 0}, {0x308b, 0x78, 0, 0}, 		/* DVP Vertical Output */
	{0x304c, 0x89, 0, 0}, 

	{0x300e, 0x35}, {0x300f, 0x21}, {0x3011, 0x00}, 
	{0x302a, 0x03}, {0x302b, 0x10}, {0x301c, 0x05}, 
	{0x301d, 0x07}, {0x3071, 0x75}, {0x3073, 0x61}, {0x302d, 0x01, 0, 0}, {0x302e, 0xcf, 0, 0},
	{0x363f, 0xa, 0, 0},
};

static struct reg_value ov3640_setting_30fps_QVGA_320_240[] = {
	{0x3012, 0x10, 0, 0}, 							/* XGA Mode */
	{0x302a, 0x03, 0, 0}, {0x302b, 0x10, 0, 0}, 	/* change this reg between XGA or QXGA mode */
	{0x304d, 0x45, 0, 0}, {0x30d7, 0x90, 0, 0}, {0x304a, 0x20, 0, 0}, {0x304b, 0x00, 0, 0}, 
	{0x304c, 0x84, 0, 0}, {0x30a5, 0x03, 0, 0}, {0x30ab, 0x03, 0, 0}, {0x30a7, 0x5e, 0, 0}, 
	{0x3087, 0x02, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0}, {0x30aa, 0x42, 0, 0}, 
	{0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0}, {0x30b2, 0x10, 0, 0}, 
	{0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0}, {0x3010, 0x20, 0, 0}, 
	{0x3011, 0x00, 0, 0}, 									/* 00 - 30fps, 01 - 15fps */
	{0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0}, {0x3016, 0x82, 0, 0}, 
	{0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0}, {0x301a, 0x61, 0, 0}, 
	{0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0}, {0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, 
	{0x3014, 0x44, 0, 0}, {0x3013, 0xf7, 0, 0}, {0x300d, 0x01, 0, 0}, {0x303c, 0x08, 0, 0}, 
	{0x303d, 0x18, 0, 0}, {0x303e, 0x06, 0, 0}, {0x303f, 0x0c, 0, 0}, {0x3030, 0x62, 0, 0}, 
	{0x3031, 0x26, 0, 0}, {0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0}, {0x3034, 0xea, 0, 0}, 
	{0x3035, 0xae, 0, 0}, {0x3036, 0xa6, 0, 0}, {0x3037, 0x6a, 0, 0}, {0x3104, 0x02, 0, 0}, 
	{0x3105, 0xfd, 0, 0}, {0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x13, 0, 0}, 
	{0x3301, 0xde, 0, 0}, {0x3302, 0xef, 0, 0}, {0x3312, 0x26, 0, 0}, {0x3314, 0x42, 0, 0}, 
	{0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0}, {0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, 
	{0x330c, 0x18, 0, 0}, {0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0}, 
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0}, {0x336a, 0x52, 0, 0}, 
	{0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0}, {0x3300, 0x13, 0, 0}, {0x30b8, 0x20, 0, 0}, 
	{0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0}, {0x30bb, 0x08, 0, 0}, {0x3507, 0x06, 0, 0}, 
	{0x350a, 0x4f, 0, 0}, {0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, {0x3500, 0x00, 0, 0}, 
	{0x3600, 0xc0, 0, 0}, {0x3610, 0x60, 0, 0}, {0x350a, 0x4f, 0, 0}, {0x3088, 0x01, 0, 0}, 
	{0x3089, 0x40, 0, 0}, {0x308a, 0x00, 0, 0}, {0x308b, 0xf0, 0, 0}, {0x3302, 0xef, 0, 0}, 
	{0x335f, 0x34, 0, 0}, {0x3360, 0x08, 0, 0}, {0x3361, 0x04, 0, 0}, /* ISP Input */
	{0x3362, 0x11, 0, 0}, {0x3363, 0x68, 0, 0}, {0x3364, 0x24, 0, 0}, /* ISP Output */
	{0x3403, 0x42, 0, 0}, 
	{0x3088, 0x01, 0, 0}, {0x3089, 0x60, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x01, 0, 0}, {0x308b, 0x20, 0, 0}, 		/* DVP Vertical Output */
	{0x332b, 0x08, 0, 0}, 								/* Manual WhiteBalance */
	{0x33a7, 0x46, 0, 0}, {0x33a8, 0x40, 0, 0}, {0x33a9, 0x52, 0, 0}, /* Edward WB */
	{0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, {0x3400, 0x00, 0, 0}, {0x3404, 0x02, 0, 0}, 
	{0x3600, 0xc0, 0, 0}, {0x308d, 0x04, 0, 0}, {0x3086, 0x00, 0, 0}, {0x3086, 0x00, 0, 0},
	{0x363f, 0x13, 0, 0},
};

static struct reg_value ov3640_setting_15fps_QVGA_320_240[] = {
	{0x3012, 0x10, 0, 0}, 							/* XGA Mode */
	{0x302a, 0x03, 0, 0}, {0x302b, 0x10, 0, 0}, 	/* change this reg between XGA or QXGA mode */
	{0x304d, 0x45, 0, 0}, {0x30d7, 0x90, 0, 0}, {0x304a, 0x20, 0, 0}, {0x304b, 0x00, 0, 0}, 
	{0x304c, 0x84, 0, 0}, {0x30a5, 0x03, 0, 0}, {0x30ab, 0x03, 0, 0}, {0x30a7, 0x5e, 0, 0}, 
	{0x3087, 0x02, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0}, {0x30aa, 0x42, 0, 0}, 
	{0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0}, {0x30b2, 0x10, 0, 0}, 
	{0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0}, {0x3010, 0x20, 0, 0}, 
	{0x3011, 0x01, 0, 0}, 									/* 00 - 30fps, 01 - 15fps */
	{0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0}, {0x3016, 0x82, 0, 0}, 
	{0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0}, {0x301a, 0x61, 0, 0}, 
	{0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0}, {0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, 
	{0x3014, 0x44, 0, 0}, {0x3013, 0xf7, 0, 0}, {0x300d, 0x01, 0, 0}, {0x303c, 0x08, 0, 0}, 
	{0x303d, 0x18, 0, 0}, {0x303e, 0x06, 0, 0}, {0x303f, 0x0c, 0, 0}, {0x3030, 0x62, 0, 0}, 
	{0x3031, 0x26, 0, 0}, {0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0}, {0x3034, 0xea, 0, 0}, 
	{0x3035, 0xae, 0, 0}, {0x3036, 0xa6, 0, 0}, {0x3037, 0x6a, 0, 0}, {0x3104, 0x02, 0, 0}, 
	{0x3105, 0xfd, 0, 0}, {0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x13, 0, 0}, 
	{0x3301, 0xde, 0, 0}, {0x3302, 0xef, 0, 0}, {0x3312, 0x26, 0, 0}, {0x3314, 0x42, 0, 0}, 
	{0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0}, {0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, 
	{0x330c, 0x18, 0, 0}, {0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0}, 
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0}, {0x336a, 0x52, 0, 0}, 
	{0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0}, {0x3300, 0x13, 0, 0}, {0x30b8, 0x20, 0, 0}, 
	{0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0}, {0x30bb, 0x08, 0, 0}, {0x3507, 0x06, 0, 0}, 
	{0x350a, 0x4f, 0, 0}, {0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, {0x3500, 0x00, 0, 0}, 
	{0x3600, 0xc0, 0, 0}, {0x3610, 0x60, 0, 0}, {0x350a, 0x4f, 0, 0}, {0x3088, 0x01, 0, 0}, 
	{0x3089, 0x40, 0, 0}, {0x308a, 0x00, 0, 0}, {0x308b, 0xf0, 0, 0}, {0x3302, 0xef, 0, 0}, 
	{0x335f, 0x34, 0, 0}, {0x3360, 0x08, 0, 0}, {0x3361, 0x04, 0, 0}, /* ISP Input */
	{0x3362, 0x11, 0, 0}, {0x3363, 0x68, 0, 0}, {0x3364, 0x24, 0, 0}, /* ISP Output */
	{0x3403, 0x42, 0, 0}, 
	{0x3088, 0x01, 0, 0}, {0x3089, 0x60, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x01, 0, 0}, {0x308b, 0x20, 0, 0}, 		/* DVP Vertical Output */
	{0x332b, 0x08, 0, 0}, 								/* Manual WhiteBalance */
	{0x33a7, 0x46, 0, 0}, {0x33a8, 0x40, 0, 0}, {0x33a9, 0x52, 0, 0}, /* Edward WB */
	{0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, {0x3400, 0x00, 0, 0}, {0x3404, 0x02, 0, 0}, 
	{0x3600, 0xc0, 0, 0}, {0x308d, 0x04, 0, 0}, {0x3086, 0x00, 0, 0}, {0x3086, 0x00, 0, 0}, 
	{0x363f, 0x13, 0, 0},
};

static struct reg_value ov3640_setting_30fps_CIF_352_288[] = {
	{0x3012, 0x10, 0, 0}, 							/* XGA Mode */
	{0x302a, 0x03, 0, 0}, {0x302b, 0x10, 0, 0}, 	/* change this reg between XGA or QXGA mode */
	{0x304d, 0x45, 0, 0}, {0x30d7, 0x90, 0, 0}, {0x304a, 0x20, 0, 0}, {0x304b, 0x00, 0, 0}, 
	{0x304c, 0x84, 0, 0}, {0x30a5, 0x03, 0, 0}, {0x30ab, 0x03, 0, 0}, {0x30a7, 0x5e, 0, 0}, 
	{0x3087, 0x02, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0}, {0x30aa, 0x42, 0, 0}, 
	{0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0}, {0x30b2, 0x10, 0, 0}, 
	{0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0}, {0x3010, 0x20, 0, 0}, 

	{0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0}, {0x3016, 0x82, 0, 0}, 
	{0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0}, {0x301a, 0x61, 0, 0}, 
	{0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0}, {0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, 
	{0x3014, 0x44, 0, 0}, {0x3013, 0xf7, 0, 0}, {0x300d, 0x01, 0, 0}, 

	{0x303c, 0x08, 0, 0}, {0x303d, 0x18, 0, 0}, 		/* Average Window Width */
	{0x303e, 0x06, 0, 0}, {0x303f, 0x0c, 0, 0}, 		/* Average Window Height */
	{0x3030, 0x62, 0, 0}, {0x3031, 0x26, 0, 0}, 		/* 16 zone Average Weight */
	{0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0}, 
	{0x3034, 0xea, 0, 0}, {0x3035, 0xae, 0, 0}, 
	{0x3036, 0xa6, 0, 0}, {0x3037, 0x6a, 0, 0}, 

	{0x3104, 0x02, 0, 0}, 
	{0x3105, 0xfd, 0, 0}, {0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x13, 0, 0}, 
	{0x3301, 0xde, 0, 0}, {0x3302, 0xef, 0, 0}, 

	{0x336a, 0x52, 0, 0}, 
	{0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0}, {0x3300, 0x13, 0, 0}, 
														/* UV Adjust */
	{0x30b8, 0x20, 0, 0}, {0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0}, {0x30bb, 0x08, 0, 0}, 

	{0x3507, 0x06, 0, 0}, 
	{0x350a, 0x4f, 0, 0}, {0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, {0x3500, 0x00, 0, 0}, 
	{0x3600, 0xc0, 0, 0}, {0x3610, 0x60, 0, 0}, {0x350a, 0x4f, 0, 0}, 
			
	{0x3088, 0x01, 0, 0}, {0x3089, 0x40, 0, 0}, {0x308a, 0x00, 0, 0}, {0x308b, 0xf0, 0, 0},

	{0x3302, 0xef, 0, 0}, 
	{0x335f, 0x33, 0, 0}, {0x3360, 0xb0, 0, 0}, {0x3361, 0x04, 0, 0}, /* ISP Input */
	{0x3362, 0x11, 0, 0}, {0x3363, 0x68, 0, 0}, {0x3364, 0x24, 0, 0}, /* ISP Output */
	{0x3403, 0x42, 0, 0}, 
	{0x3088, 0x01, 0, 0}, {0x3089, 0x60, 0, 0}, 		/* DVP Horizontal Outpu3t*/
	{0x308a, 0x01, 0, 0}, {0x308b, 0x20, 0, 0}, 		/* DVP Vertical Output */
	{0x332b, 0x08, 0, 0}, 								/* Manual WhiteBalance */
	{0x33a7, 0x46, 0, 0}, {0x33a8, 0x40, 0, 0}, {0x33a9, 0x52, 0, 0}, /* Edward WB */
	{0x3011, 0x00, 0, 0}, 									/* 00 - 30fps, 01 - 15fps */
	{0x3312, 0x26, 0, 0}, {0x3314, 0x42, 0, 0}, 
	{0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0}, {0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, 
	{0x330c, 0x18, 0, 0}, {0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0}, 
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0}, 
	{0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, 
	{0x3400, 0x00, 0, 0}, 							/* ISP YUV */
	{0x3404, 0x02, 0, 0},							/* YUV422 YUYV YUYV  */
	{0x3600, 0xc0, 0, 0}, 							/* VSYNC */
	{0x308d, 0x04, 0, 0}, {0x3086, 0x03, 0, 0}, {0x3086, 0x00, 0, 0}, 	/* Sleep and Wake */
	{0x363f, 0x20, 0, 0},
};

static struct reg_value ov3640_setting_15fps_CIF_352_288[] = {
	{0x3012, 0x10, 0, 0}, 							/* XGA Mode */
	{0x302a, 0x03, 0, 0}, {0x302b, 0x10, 0, 0}, 	/* change this reg between XGA or QXGA mode */
	{0x304d, 0x45, 0, 0}, {0x30d7, 0x90, 0, 0}, {0x304a, 0x20, 0, 0}, {0x304b, 0x00, 0, 0}, 
	{0x304c, 0x84, 0, 0}, {0x30a5, 0x03, 0, 0}, {0x30ab, 0x03, 0, 0}, {0x30a7, 0x5e, 0, 0}, 
	{0x3087, 0x02, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0}, {0x30aa, 0x42, 0, 0}, 
	{0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0}, {0x30b2, 0x10, 0, 0}, 
	{0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0}, {0x3010, 0x20, 0, 0}, 

	{0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0}, {0x3016, 0x82, 0, 0}, 
	{0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0}, {0x301a, 0x61, 0, 0}, 
	{0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0}, {0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, 
	{0x3014, 0x44, 0, 0}, {0x3013, 0xf7, 0, 0}, {0x300d, 0x01, 0, 0}, 

	{0x303c, 0x08, 0, 0}, {0x303d, 0x18, 0, 0}, 		/* Average Window Width */
	{0x303e, 0x06, 0, 0}, {0x303f, 0x0c, 0, 0}, 		/* Average Window Height */
	{0x3030, 0x62, 0, 0}, {0x3031, 0x26, 0, 0}, 		/* 16 zone Average Weight */
	{0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0}, 
	{0x3034, 0xea, 0, 0}, {0x3035, 0xae, 0, 0}, 
	{0x3036, 0xa6, 0, 0}, {0x3037, 0x6a, 0, 0}, 

	{0x3104, 0x02, 0, 0}, 
	{0x3105, 0xfd, 0, 0}, {0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x13, 0, 0}, 
	{0x3301, 0xde, 0, 0}, {0x3302, 0xef, 0, 0}, 

	{0x336a, 0x52, 0, 0}, 
	{0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0}, {0x3300, 0x13, 0, 0}, 
														/* UV Adjust */
	{0x30b8, 0x20, 0, 0}, {0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0}, {0x30bb, 0x08, 0, 0}, 

	{0x3507, 0x06, 0, 0}, 
	{0x350a, 0x4f, 0, 0}, {0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, {0x3500, 0x00, 0, 0}, 
	{0x3600, 0xc0, 0, 0}, {0x3610, 0x60, 0, 0}, {0x350a, 0x4f, 0, 0}, 
			
	{0x3088, 0x01, 0, 0}, {0x3089, 0x40, 0, 0}, {0x308a, 0x00, 0, 0}, {0x308b, 0xf0, 0, 0},

	{0x3302, 0xef, 0, 0}, 
	{0x335f, 0x33, 0, 0}, {0x3360, 0xb0, 0, 0}, {0x3361, 0x04, 0, 0}, /* ISP Input */
	{0x3362, 0x11, 0, 0}, {0x3363, 0x68, 0, 0}, {0x3364, 0x24, 0, 0}, /* ISP Output */
	{0x3403, 0x42, 0, 0}, 
	{0x3088, 0x01, 0, 0}, {0x3089, 0x60, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x01, 0, 0}, {0x308b, 0x20, 0, 0}, 		/* DVP Vertical Output */
	{0x332b, 0x08, 0, 0}, 								/* Manual WhiteBalance */
	{0x33a7, 0x46, 0, 0}, {0x33a8, 0x40, 0, 0}, {0x33a9, 0x52, 0, 0}, /* Edward WB */
	{0x3011, 0x01, 0, 0}, 									/* 00 - 30fps, 01 - 15fps */
	{0x3312, 0x26, 0, 0}, {0x3314, 0x42, 0, 0}, 
	{0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0}, {0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, 
	{0x330c, 0x18, 0, 0}, {0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0}, 
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0}, 
	{0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, 
	{0x3400, 0x00, 0, 0}, 							/* ISP YUV */
	{0x3404, 0x02, 0, 0},							/* YUV422 YUYV YUYV  */
	{0x3600, 0xc0, 0, 0}, 							/* VSYNC */
	{0x308d, 0x04, 0, 0}, {0x3086, 0x03, 0, 0}, {0x3086, 0x00, 0, 0}, 	/* Sleep and Wake */
	{0x363f, 0x0a, 0, 0},
};

static struct reg_value ov3640_setting_30fps_QCIF_176_144[] = {
	{0x3012, 0x10, 0, 0}, 							/* XGA Mode */
	{0x302a, 0x03, 0, 0}, {0x302b, 0x10, 0, 0}, 	/* change this reg between XGA or QXGA mode */
	{0x304d, 0x45, 0, 0}, {0x30d7, 0x90, 0, 0}, {0x304a, 0x20, 0, 0}, {0x304b, 0x00, 0, 0}, 
	{0x304c, 0x84, 0, 0}, {0x30a5, 0x03, 0, 0}, {0x30ab, 0x03, 0, 0}, {0x30a7, 0x5e, 0, 0}, 
	{0x3087, 0x02, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0}, {0x30aa, 0x42, 0, 0}, 
	{0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0}, {0x30b2, 0x10, 0, 0}, 
	{0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0}, {0x3010, 0x20, 0, 0}, 

	{0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0}, {0x3016, 0x82, 0, 0}, 
	{0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0}, {0x301a, 0x61, 0, 0}, 
	{0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0}, {0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, 
	{0x3014, 0x44, 0, 0}, {0x3013, 0xf7, 0, 0}, {0x300d, 0x01, 0, 0}, 

	{0x3088, 0x00, 0, 0}, {0x3089, 0xB0, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x00, 0, 0}, {0x308b, 0x90, 0, 0}, 		/* DVP Vertical Output */
	{0x3030, 0x62, 0, 0}, {0x3031, 0x26, 0, 0}, 		/* 16 zone Average Weight */
	{0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0}, 
	{0x3034, 0xea, 0, 0}, {0x3035, 0xae, 0, 0}, 
	{0x3036, 0xa6, 0, 0}, {0x3037, 0x6a, 0, 0}, 

	{0x3104, 0x02, 0, 0}, 
	{0x3105, 0xfd, 0, 0}, {0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x13, 0, 0}, 
	{0x3301, 0xde, 0, 0}, {0x3302, 0xef, 0, 0}, 

	{0x336a, 0x52, 0, 0}, 
	{0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0}, {0x3300, 0x13, 0, 0}, 
														/* UV Adjust */
	{0x30b8, 0x20, 0, 0}, {0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0}, {0x30bb, 0x08, 0, 0}, 

	{0x3507, 0x06, 0, 0}, 
	{0x350a, 0x4f, 0, 0}, {0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, {0x3500, 0x00, 0, 0}, 
	{0x3600, 0xc0, 0, 0}, {0x3610, 0x60, 0, 0}, {0x350a, 0x4f, 0, 0}, 
			
	{0x3088, 0x01, 0, 0}, {0x3089, 0x40, 0, 0}, {0x308a, 0x00, 0, 0}, {0x308b, 0xf0, 0, 0},

	{0x3302, 0xef, 0, 0}, 
	{0x335f, 0x33, 0, 0}, {0x3360, 0xb0, 0, 0}, {0x3361, 0x04, 0, 0}, /* ISP Input */
	{0x3362, 0x00, 0, 0}, {0x3363, 0xB8, 0, 0}, {0x3364, 0x94, 0, 0}, /* ISP Output */
	{0x3403, 0x42, 0, 0}, 
	{0x3088, 0x00, 0, 0}, {0x3089, 0xB0, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x00, 0, 0}, {0x308b, 0x90, 0, 0}, 		/* DVP Vertical Output */
	{0x332b, 0x08, 0, 0}, 								/* Manual WhiteBalance */
	{0x33a7, 0x46, 0, 0}, {0x33a8, 0x40, 0, 0}, {0x33a9, 0x52, 0, 0}, /* Edward WB */
	{0x3011, 0x00, 0, 0}, 									/* 00 - 30fps, 01 - 15fps */
	{0x3312, 0x26, 0, 0}, {0x3314, 0x42, 0, 0}, 
	{0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0}, {0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, 
	{0x330c, 0x18, 0, 0}, {0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0}, 
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0}, 
	{0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, 
	{0x3400, 0x00, 0, 0}, 							/* ISP YUV */
	{0x3404, 0x02, 0, 0},							/* YUV422 YUYV YUYV  */
	{0x3600, 0xc0, 0, 0}, 							/* VSYNC */
	{0x308d, 0x04, 0, 0}, {0x3086, 0x03, 0, 0}, {0x3086, 0x00, 0, 0}, 	/* Sleep and Wake */
	{0x363f, 0x0f, 0, 0},
};

static struct reg_value ov3640_setting_15fps_QCIF_176_144[] = {
	{0x3012, 0x10, 0, 0}, 							/* XGA Mode */
	{0x302a, 0x03, 0, 0}, {0x302b, 0x10, 0, 0}, 	/* change this reg between XGA or QXGA mode */
	{0x304d, 0x45, 0, 0}, {0x30d7, 0x90, 0, 0}, {0x304a, 0x20, 0, 0}, {0x304b, 0x00, 0, 0}, 
	{0x304c, 0x84, 0, 0}, {0x30a5, 0x03, 0, 0}, {0x30ab, 0x03, 0, 0}, {0x30a7, 0x5e, 0, 0}, 
	{0x3087, 0x02, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0}, {0x30aa, 0x42, 0, 0}, 
	{0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0}, {0x30b2, 0x10, 0, 0}, 
	{0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0}, {0x3010, 0x20, 0, 0}, 

	{0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0}, {0x3016, 0x82, 0, 0}, 
	{0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0}, {0x301a, 0x61, 0, 0}, 
	{0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0}, {0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, 
	{0x3014, 0x44, 0, 0}, {0x3013, 0xf7, 0, 0}, {0x300d, 0x01, 0, 0}, 

	{0x3088, 0x00, 0, 0}, {0x3089, 0xB0, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x00, 0, 0}, {0x308b, 0x90, 0, 0}, 		/* DVP Vertical Output */
	{0x3030, 0x62, 0, 0}, {0x3031, 0x26, 0, 0}, 		/* 16 zone Average Weight */
	{0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0}, 
	{0x3034, 0xea, 0, 0}, {0x3035, 0xae, 0, 0}, 
	{0x3036, 0xa6, 0, 0}, {0x3037, 0x6a, 0, 0}, 

	{0x3104, 0x02, 0, 0}, 
	{0x3105, 0xfd, 0, 0}, {0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x13, 0, 0}, 
	{0x3301, 0xde, 0, 0}, {0x3302, 0xef, 0, 0}, 

	{0x336a, 0x52, 0, 0}, 
	{0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0}, {0x3300, 0x13, 0, 0}, 
														/* UV Adjust */
	{0x30b8, 0x20, 0, 0}, {0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0}, {0x30bb, 0x08, 0, 0}, 

	{0x3507, 0x06, 0, 0}, 
	{0x350a, 0x4f, 0, 0}, {0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, {0x3500, 0x00, 0, 0}, 
	{0x3600, 0xc0, 0, 0}, {0x3610, 0x60, 0, 0}, {0x350a, 0x4f, 0, 0}, 
			
	{0x3088, 0x01, 0, 0}, {0x3089, 0x40, 0, 0}, {0x308a, 0x00, 0, 0}, {0x308b, 0xf0, 0, 0},

	{0x3302, 0xef, 0, 0}, 
	{0x335f, 0x33, 0, 0}, {0x3360, 0xb0, 0, 0}, {0x3361, 0x04, 0, 0}, /* ISP Input */
	{0x3362, 0x00, 0, 0}, {0x3363, 0xB8, 0, 0}, {0x3364, 0x94, 0, 0}, /* ISP Output */
	{0x3403, 0x42, 0, 0}, 
	{0x3088, 0x00, 0, 0}, {0x3089, 0xB0, 0, 0}, 		/* DVP Horizontal Output*/
	{0x308a, 0x00, 0, 0}, {0x308b, 0x90, 0, 0}, 		/* DVP Vertical Output */
	{0x332b, 0x08, 0, 0}, 								/* Manual WhiteBalance */
	{0x33a7, 0x46, 0, 0}, {0x33a8, 0x40, 0, 0}, {0x33a9, 0x52, 0, 0}, /* Edward WB */
	{0x3011, 0x01, 0, 0}, 									/* 00 - 30fps, 01 - 15fps */
	{0x3312, 0x26, 0, 0}, {0x3314, 0x42, 0, 0}, 
	{0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0}, {0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, 
	{0x330c, 0x18, 0, 0}, {0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0}, 
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0}, 
	{0x3100, 0x02, 0, 0}, {0x3304, 0x00, 0, 0}, 
	{0x3400, 0x00, 0, 0}, 							/* ISP YUV */
	{0x3404, 0x02, 0, 0},							/* YUV422 YUYV YUYV  */
	{0x3600, 0xc0, 0, 0}, 							/* VSYNC */
	{0x308d, 0x04, 0, 0}, {0x3086, 0x03, 0, 0}, {0x3086, 0x00, 0, 0}, 	/* Sleep and Wake */
	{0x363f, 0x0a, 0, 0},
};

static struct reg_value ov3640_setting_15fps_QXGA_2048_1536[] = {
	{0x304d, 0x45, 0, 0}, {0x30a7, 0x5e, 0, 0},
	{0x3087, 0x16, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0},
	{0x30aa, 0x42, 0, 0}, {0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0},
	{0x30b2, 0x10, 0, 0}, {0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0},
	{0x3010, 0x20, 0, 0}, {0x3011, 0x00, 0, 0}, {0x304c, 0x81, 0, 0},
	{0x30d7, 0x10, 0, 0}, {0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0},
	{0x3016, 0x82, 0, 0}, {0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0},
	{0x301a, 0x61, 0, 0}, {0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0},
	{0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, {0x3014, 0x04, 0, 0},
	{0x3013, 0xf7, 0, 0}, {0x303c, 0x08, 0, 0}, {0x303d, 0x18, 0, 0},
	{0x303e, 0x06, 0, 0}, {0x303f, 0x0c, 0, 0}, {0x3030, 0x62, 0, 0},
	{0x3031, 0x26, 0, 0}, {0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0},
	{0x3034, 0xea, 0, 0}, {0x3035, 0xae, 0, 0}, {0x3036, 0xa6, 0, 0},
	{0x3037, 0x6a, 0, 0}, {0x3104, 0x02, 0, 0}, {0x3105, 0xfd, 0, 0},
	{0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x12, 0, 0},
	{0x3301, 0xde, 0, 0}, {0x3302, 0xcf, 0, 0}, {0x3312, 0x26, 0, 0},
	{0x3314, 0x42, 0, 0}, {0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0},
	{0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, {0x330c, 0x18, 0, 0},
	{0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0},
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0},
	{0x336a, 0x52, 0, 0}, {0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0},
	{0x30b8, 0x20, 0, 0}, {0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0},
	{0x30bb, 0x08, 0, 0}, {0x3507, 0x06, 0, 0}, {0x350a, 0x4f, 0, 0},
	{0x3100, 0x02, 0, 0}, {0x3301, 0xde, 0, 0}, {0x3304, 0x00, 0, 0},
	{0x3400, 0x00, 0, 0}, {0x3404, 0x02, 0, 0}, {0x3600, 0xc4, 0, 0},
	{0x3302, 0xef, 0, 0}, {0x3020, 0x01, 0, 0}, {0x3021, 0x1d, 0, 0},
	{0x3022, 0x00, 0, 0}, {0x3023, 0x0a, 0, 0}, {0x3024, 0x08, 0, 0},
	{0x3025, 0x00, 0, 0}, {0x3026, 0x06, 0, 0}, {0x3027, 0x00, 0, 0},
	{0x335f, 0x68, 0, 0}, {0x3360, 0x00, 0, 0}, {0x3361, 0x00, 0, 0},
	{0x3362, 0x68, 0, 0}, {0x3363, 0x00, 0, 0}, {0x3364, 0x00, 0, 0},
	{0x3403, 0x00, 0, 0}, {0x3088, 0x08, 0, 0}, {0x3089, 0x00, 0, 0},
	{0x308a, 0x06, 0, 0}, {0x308b, 0x00, 0, 0}, {0x307c, 0x10, 0, 0},
	{0x3090, 0xc0, 0, 0}, {0x304c, 0x84, 0, 0}, {0x308d, 0x04, 0, 0},
	{0x3086, 0x03, 0, 0}, {0x3086, 0x00, 0, 0}, {0x3012, 0x00, 0, 0},
	{0x3020, 0x01, 0, 0}, {0x3021, 0x1d, 0, 0}, {0x3022, 0x00, 0, 0},
	{0x3023, 0x0a, 0, 0}, {0x3024, 0x08, 0, 0}, {0x3025, 0x18, 0, 0},
	{0x3026, 0x06, 0, 0}, {0x3027, 0x0c, 0, 0}, {0x302a, 0x06, 0, 0},
	{0x302b, 0x20, 0, 0}, {0x3075, 0x44, 0, 0}, {0x300d, 0x00, 0, 0},
	{0x30d7, 0x00, 0, 0}, {0x3069, 0x40, 0, 0}, {0x303e, 0x01, 0, 0},
	{0x303f, 0x80, 0, 0}, {0x3302, 0x20, 0, 0}, {0x335f, 0x68, 0, 0},
	{0x3360, 0x18, 0, 0}, {0x3361, 0x0c, 0, 0}, {0x3362, 0x68, 0, 0},
	{0x3363, 0x08, 0, 0}, {0x3364, 0x04, 0, 0}, {0x3403, 0x42, 0, 0},
	{0x3088, 0x08, 0, 0}, {0x3089, 0x00, 0, 0}, {0x308a, 0x06, 0, 0},
	{0x308b, 0x00, 0, 0},
};

static struct reg_value ov3640_setting_15fps_XGA_1024_768[] = {
	{0x304d, 0x45, 0, 0}, {0x30a7, 0x5e, 0, 0},
	{0x3087, 0x16, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0},
	{0x30aa, 0x42, 0, 0}, {0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0},
	{0x30b2, 0x10, 0, 0}, {0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0},
	{0x3010, 0x20, 0, 0}, {0x3011, 0x00, 0, 0}, {0x304c, 0x81, 0, 0},
	{0x3016, 0x82, 0, 0}, {0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0},
	{0x301a, 0x61, 0, 0}, {0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0},
	{0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, {0x3014, 0x04, 0, 0},
	{0x3013, 0xf7, 0, 0}, {0x303c, 0x08, 0, 0}, {0x303d, 0x18, 0, 0},
	{0x303e, 0x06, 0, 0}, {0x303f, 0x0c, 0, 0}, {0x3030, 0x62, 0, 0},
	{0x3031, 0x26, 0, 0}, {0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0},
	{0x3034, 0xea, 0, 0}, {0x3035, 0xae, 0, 0}, {0x3036, 0xa6, 0, 0},
	{0x3037, 0x6a, 0, 0}, {0x3104, 0x02, 0, 0}, {0x3105, 0xfd, 0, 0},
	{0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x12, 0, 0},
	{0x3301, 0xde, 0, 0}, {0x3302, 0xcf, 0, 0}, {0x3312, 0x26, 0, 0},
	{0x3314, 0x42, 0, 0}, {0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0},
	{0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, {0x330c, 0x18, 0, 0},
	{0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0},
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0},
	{0x336a, 0x52, 0, 0}, {0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0},
	{0x30b8, 0x20, 0, 0}, {0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0},
	{0x30bb, 0x08, 0, 0}, {0x3507, 0x06, 0, 0}, {0x350a, 0x4f, 0, 0},
	{0x3100, 0x02, 0, 0}, {0x3301, 0xde, 0, 0}, {0x3304, 0x00, 0, 0},
	{0x3400, 0x01, 0, 0}, {0x3404, 0x1d, 0, 0}, {0x3600, 0xc4, 0, 0},
	{0x3302, 0xef, 0, 0}, {0x3020, 0x01, 0, 0}, {0x3021, 0x1d, 0, 0},
	{0x3022, 0x00, 0, 0}, {0x3023, 0x0a, 0, 0}, {0x3024, 0x08, 0, 0},
	{0x3025, 0x00, 0, 0}, {0x3026, 0x06, 0, 0}, {0x3027, 0x00, 0, 0},
	{0x335f, 0x68, 0, 0}, {0x3360, 0x00, 0, 0}, {0x3361, 0x00, 0, 0},
	{0x3362, 0x34, 0, 0}, {0x3363, 0x00, 0, 0}, {0x3364, 0x00, 0, 0},
	{0x3403, 0x00, 0, 0}, {0x3088, 0x04, 0, 0}, {0x3089, 0x00, 0, 0},
	{0x308a, 0x03, 0, 0}, {0x308b, 0x00, 0, 0}, {0x307c, 0x10, 0, 0},
	{0x3090, 0xc0, 0, 0}, {0x304c, 0x84, 0, 0}, {0x308d, 0x04, 0, 0},
	{0x3086, 0x03, 0, 0}, {0x3086, 0x00, 0, 0}, {0x3011, 0x01, 0, 0},
};

static struct reg_value ov3640_setting_30fps_XGA_1024_768[] = {
	{0x0, 0x0, 0}
};

static struct reg_value ov3640_setting_15fps_VGA_640_480[] = {
	{0x304d, 0x45, 0, 0}, {0x30a7, 0x5e, 0, 0},
	{0x3087, 0x16, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0},
	{0x30aa, 0x42, 0, 0}, {0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0},
	{0x30b2, 0x10, 0, 0}, {0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0},
	{0x3010, 0x20, 0, 0}, {0x3011, 0x00, 0, 0}, {0x304c, 0x81, 0, 0},
	{0x30d7, 0x10, 0, 0}, {0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0},
	{0x3016, 0x82, 0, 0}, {0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0},
	{0x301a, 0x61, 0, 0}, {0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0},
	{0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, {0x3014, 0x04, 0, 0},
	{0x3013, 0xf7, 0, 0}, {0x303c, 0x08, 0, 0}, {0x303d, 0x18, 0, 0},
	{0x303e, 0x06, 0, 0}, {0x303f, 0x0c, 0, 0}, {0x3030, 0x62, 0, 0},
	{0x3031, 0x26, 0, 0}, {0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0},
	{0x3034, 0xea, 0, 0}, {0x3035, 0xae, 0, 0}, {0x3036, 0xa6, 0, 0},
	{0x3037, 0x6a, 0, 0}, {0x3104, 0x02, 0, 0}, {0x3105, 0xfd, 0, 0},
	{0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x12, 0, 0},
	{0x3301, 0xde, 0, 0}, {0x3302, 0xcf, 0, 0}, {0x3312, 0x26, 0, 0},
	{0x3314, 0x42, 0, 0}, {0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0},
	{0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, {0x330c, 0x18, 0, 0},
	{0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0},
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0},
	{0x336a, 0x52, 0, 0}, {0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0},
	{0x30b8, 0x20, 0, 0}, {0x30b9, 0x17, 0, 0}, {0x30ba, 0x04, 0, 0},
	{0x30bb, 0x08, 0, 0}, {0x3507, 0x06, 0, 0}, {0x350a, 0x4f, 0, 0},
	{0x3100, 0x02, 0, 0}, {0x3301, 0xde, 0, 0}, {0x3304, 0xfc, 0, 0},
	{0x3400, 0x00, 0, 0}, {0x3404, 0x02, 0, 0}, {0x3600, 0xc0, 0, 0},
	{0x3302, 0xef, 0, 0}, {0x3020, 0x01, 0, 0}, {0x3021, 0x1d, 0, 0},
	{0x3022, 0x00, 0, 0}, {0x3023, 0x0a, 0, 0}, {0x3024, 0x08, 0, 0},
	{0x3025, 0x00, 0, 0}, {0x3026, 0x06, 0, 0}, {0x3027, 0x00, 0, 0},
	{0x335f, 0x68, 0, 0}, {0x3360, 0x00, 0, 0}, {0x3361, 0x00, 0, 0},
	{0x3362, 0x12, 0, 0}, {0x3363, 0x80, 0, 0}, {0x3364, 0xe0, 0, 0},
	{0x3403, 0x00, 0, 0}, {0x3088, 0x02, 0, 0}, {0x3089, 0x80, 0, 0},
	{0x308a, 0x01, 0, 0}, {0x308b, 0xe0, 0, 0}, {0x307c, 0x10, 0, 0},
	{0x3090, 0xc0, 0, 0}, {0x304c, 0x84, 0, 0}, {0x308d, 0x04, 0, 0},
	{0x3086, 0x03, 0, 0}, {0x3086, 0x00, 0, 0}, {0x3011, 0x00, 0, 0},
	{0x363f, 0x08, 0, 0}, 
};

static struct reg_value ov3640_setting_30fps_VGA_640_480[] = {
	{0x304d, 0x45, 0, 0}, {0x30a7, 0x5e, 0, 0},
	{0x3087, 0x16, 0, 0}, {0x309c, 0x1a, 0, 0}, {0x30a2, 0xe4, 0, 0},
	{0x30aa, 0x42, 0, 0}, {0x30b0, 0xff, 0, 0}, {0x30b1, 0xff, 0, 0},
	{0x30b2, 0x10, 0, 0}, {0x300e, 0x32, 0, 0}, {0x300f, 0x21, 0, 0},
	{0x3010, 0x20, 0, 0}, {0x3011, 0x01, 0, 0}, {0x304c, 0x82, 0, 0},
	{0x30d7, 0x10, 0, 0}, {0x30d9, 0x0d, 0, 0}, {0x30db, 0x08, 0, 0},
	{0x3016, 0x82, 0, 0}, {0x3018, 0x38, 0, 0}, {0x3019, 0x30, 0, 0},
	{0x301a, 0x61, 0, 0}, {0x307d, 0x00, 0, 0}, {0x3087, 0x02, 0, 0},
	{0x3082, 0x20, 0, 0}, {0x3015, 0x12, 0, 0}, {0x3014, 0x0c, 0, 0},
	{0x3013, 0xf7, 0, 0}, {0x303c, 0x08, 0, 0}, {0x303d, 0x18, 0, 0},
	{0x303e, 0x06, 0, 0}, {0x303f, 0x0c, 0, 0}, {0x3030, 0x62, 0, 0},
	{0x3031, 0x26, 0, 0}, {0x3032, 0xe6, 0, 0}, {0x3033, 0x6e, 0, 0},
	{0x3034, 0xea, 0, 0}, {0x3035, 0xae, 0, 0}, {0x3036, 0xa6, 0, 0},
	{0x3037, 0x6a, 0, 0}, {0x3104, 0x02, 0, 0}, {0x3105, 0xfd, 0, 0},
	{0x3106, 0x00, 0, 0}, {0x3107, 0xff, 0, 0}, {0x3300, 0x12, 0, 0},
	{0x3301, 0xde, 0, 0}, {0x3302, 0xcf, 0, 0}, {0x3312, 0x26, 0, 0},
	{0x3314, 0x42, 0, 0}, {0x3313, 0x2b, 0, 0}, {0x3315, 0x42, 0, 0},
	{0x3310, 0xd0, 0, 0}, {0x3311, 0xbd, 0, 0}, {0x330c, 0x18, 0, 0},
	{0x330d, 0x18, 0, 0}, {0x330e, 0x56, 0, 0}, {0x330f, 0x5c, 0, 0},
	{0x330b, 0x1c, 0, 0}, {0x3306, 0x5c, 0, 0}, {0x3307, 0x11, 0, 0},
	{0x336a, 0x52, 0, 0}, {0x3370, 0x46, 0, 0}, {0x3376, 0x38, 0, 0},
	{0x3300, 0x13, 0, 0}, {0x30b8, 0x20, 0, 0}, {0x30b9, 0x17, 0, 0},
	{0x30ba, 0x04, 0, 0}, {0x30bb, 0x08, 0, 0}, {0x3100, 0x02, 0, 0},
	{0x3301, 0x10, 0x30, 0}, {0x3304, 0x00, 0x03, 0}, {0x3400, 0x00, 0, 0},
	{0x3404, 0x02, 0, 0}, {0x3600, 0xc0, 0, 0}, {0x308d, 0x04, 0, 0},
	{0x3086, 0x03, 0, 0}, {0x3086, 0x00, 0, 0}, {0x3012, 0x10, 0, 0},
	{0x3023, 0x06, 0, 0}, {0x3026, 0x03, 0, 0}, {0x3027, 0x04, 0, 0},
	{0x302a, 0x03, 0, 0}, {0x302b, 0x10, 0, 0}, {0x3075, 0x24, 0, 0},
	{0x300d, 0x01, 0, 0}, {0x30d7, 0x80, 0x80, 0}, {0x3069, 0x00, 0x40, 0},
	{0x303e, 0x00, 0, 0}, {0x303f, 0xc0, 0, 0}, {0x3302, 0x20, 0x20, 0},
	{0x335f, 0x34, 0, 0}, {0x3360, 0x0c, 0, 0}, {0x3361, 0x04, 0, 0},
	{0x3362, 0x12, 0, 0}, {0x3363, 0x88, 0, 0}, {0x3364, 0xe4, 0, 0},
	{0x3403, 0x42, 0, 0}, {0x3088, 0x02, 0, 0}, {0x3089, 0x80, 0, 0},
	{0x308a, 0x01, 0, 0}, {0x308b, 0xe0, 0, 0}, {0x3362, 0x12, 0, 0},
	{0x3363, 0x88, 0, 0}, {0x3364, 0xe4, 0, 0}, {0x3403, 0x42, 0, 0},
	{0x3088, 0x02, 0, 0}, {0x3089, 0x80, 0, 0}, {0x308a, 0x01, 0, 0},
	{0x308b, 0xe0, 0, 0}, {0x300e, 0x36, 0, 0}, {0x300f, 0xe1, 0, 0},
	{0x3010, 0x22, 0, 0}, {0x3011, 0x01, 0, 0}, {0x304c, 0x84, 0, 0},
	{0x3014, 0x04, 0, 0}, {0x3015, 0x02, 0, 0}, {0x302e, 0x00, 0, 0},
	{0x302d, 0x00, 0, 0}, {0x363f, 0x08, 0, 0}, {0x360b, 0x40, 0, 0},
};

static struct ov3640_mode_info ov3640_mode_info_data[2][7] = {
	{
		{OV3640_MODE_QQVGA_160_120,   160,  120,
		ov3640_setting_15fps_QQVGA_160_120,
		ARRAY_SIZE(ov3640_setting_15fps_QQVGA_160_120)},
		{OV3640_MODE_QCIF_176_144,   176,  144,
		ov3640_setting_15fps_QCIF_176_144,
		ARRAY_SIZE(ov3640_setting_15fps_QCIF_176_144)},
		{OV3640_MODE_QVGA_320_240,   320,  240,
		ov3640_setting_15fps_QVGA_320_240,
		ARRAY_SIZE(ov3640_setting_15fps_QVGA_320_240)},
		{OV3640_MODE_CIF_352_288,   352,  288,
		ov3640_setting_15fps_CIF_352_288,
		ARRAY_SIZE(ov3640_setting_15fps_CIF_352_288)},
		{OV3640_MODE_VGA_640_480,    640,  480,
		ov3640_setting_15fps_VGA_640_480,
		ARRAY_SIZE(ov3640_setting_15fps_VGA_640_480)},
		{OV3640_MODE_XGA_1024_768,   1024, 768,
		ov3640_setting_15fps_XGA_1024_768,
		ARRAY_SIZE(ov3640_setting_15fps_XGA_1024_768)},
		{OV3640_MODE_QXGA_2048_1536, 2048, 1536,
		ov3640_setting_15fps_QXGA_2048_1536,
		ARRAY_SIZE(ov3640_setting_15fps_QXGA_2048_1536)},
	},
	{
		{OV3640_MODE_QQVGA_160_120,   160,  120,
		ov3640_setting_30fps_QQVGA_160_120,
		ARRAY_SIZE(ov3640_setting_30fps_QQVGA_160_120)},
		{OV3640_MODE_QCIF_176_144,   176,  144,
		ov3640_setting_30fps_QCIF_176_144,
		ARRAY_SIZE(ov3640_setting_30fps_QCIF_176_144)},
		{OV3640_MODE_QVGA_320_240,   320,  240,
		ov3640_setting_30fps_QVGA_320_240,
		ARRAY_SIZE(ov3640_setting_30fps_QVGA_320_240)},
		{OV3640_MODE_CIF_352_288,   352,  288,
		ov3640_setting_30fps_CIF_352_288,
		ARRAY_SIZE(ov3640_setting_30fps_CIF_352_288)},
		{OV3640_MODE_VGA_640_480,    640,  480,
		ov3640_setting_30fps_VGA_640_480,
		ARRAY_SIZE(ov3640_setting_30fps_VGA_640_480)},
		{OV3640_MODE_XGA_1024_768,   1024, 768,
		ov3640_setting_30fps_XGA_1024_768,
		ARRAY_SIZE(ov3640_setting_30fps_XGA_1024_768)},
		{OV3640_MODE_QXGA_2048_1536, 0, 0, NULL, 0},
	},
};
#endif

const static struct ov3640_reg ov3640_common[OV_NUM_IMAGE_SIZES][100] = {
	/* XGA_Default settings */
	{
		{OV3640_IO_CTRL1, 0x2F},	//	bit 0:1 - data[9:8] pins output
		//  bit 2 - HREF output 
		//  bit 3 - PCLK output
		//  bit 4 - STROBE input
		//  bit 5 - VSYNC output 
		//	bit 6 - GPIO1 input
		//	bit 7 - GPIO2 input
		{OV3640_OUT_CTRL00, 0xc0},	//  bit 7 - VSYNC_sel2 - VSYNC mode 3 select 
		//	bit 6 -	VSYNC_gate - Gate DVP_PCLK when VSYNC and PCLK_gate_en
		// (System note: VREF high during pulse, low otherwise)
		{OV3640_IO_CTRL0, 0xFF},	// set data[7:0] pins as output
		{OV3640_EXHTS, 0x00},		//  (Default value) Line Interval Adjustment Value (dummy pixels) 
		// the frame rate will be adjusted by changing the line intervals ????????????? Not clear.
		{OV3640_AUTO_2, 0x04},		//	(Default value) - enable bandiog AEC smooth switch btween 50/60
		{OV3640_EXVTS_L, 0x00},		//	(Default value) - VSYNC Pulse Width LSB 8 bits ??????????????
		{OV3640_EXVTS_H, 0x00},		// 	(Default value) - VSYNC Pulse Width MSB 8 bits ??????????????
		{OV3640_DSP_CTRL_1, 0xde},	// 	DSP control 1
		{OV3640_PLL_1, 0x39},		// PLL1 control *Also used by the diriver*
		{OV3640_PLL_2, 0x21},		// PLL2 control *Also used by the diriver*
		{OV3640_PLL_3, 0x20},		// PLL3 control *Also used by the diriver*
		{0x304c, 0x81}, 			//  NO EXISTED under the SPEC
		{OV3640_DSP_CTRL_2, 0xef},	//	DSP control 2
		{OV3640_SIZE_IN_MISC, 0x68},//				Input configure
		{OV3640_HSIZE_IN_L, 0x18},	//	H_SIZE_IN = 0x818 (x=2072) , V_SIZE_IN = 0x60c (y=1548) (this is the active pixel area)
		{OV3640_VSIZE_IN_L, 0x0C},	//
		{OV3640_SIZE_OUT_MISC, 0x34},//				Output configure
		{OV3640_HSIZE_OUT_L, 0x08},	// H_SIZE_OUT = 0x408 (x=1032) , V_SIZE_OUT = 0x304 (y=772)
		{OV3640_VSIZE_OUT_L, 0x04},	//
		{0x3403, 0x42}, 			// 	(Default value) CIU PAD control 
		// bit 0:3 - Y start
		// bit 4:7 - X start
		{OV3640_ISP_XOUT_H, 0x04},
		{OV3640_ISP_XOUT_L, 0x00},	//	CIU X direction output size (1024)
		{OV3640_ISP_YOUT_H, 0x03},
		{OV3640_ISP_YOUT_L, 0x00},	//	CIU Y direction output size	(768)
		{OV3640_CLK, 0x01},			//OV reccomend redusing pclk by 2 due to Broadtile bus limitation which is 35M
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},

	/* QXGA Default settings */
	{
		{OV3640_IO_CTRL1, 0x2F},	//	bit 0:1 - data[9:8] pins output
		//  bit 2 - HREF output 
		//  bit 3 - PCLK output
		//  bit 4 - STROBE input
		//  bit 5 - VSYNC output 
		//	bit 6 - GPIO1 input
		//	bit 7 - GPIO2 input
		{OV3640_OUT_CTRL00, 0xc0},	//  bit 7 - VSYNC_sel2 - VSYNC mode 3 select 
		//	bit 6 -	VSYNC_gate - Gate DVP_PCLK when VSYNC and PCLK_gate_en
		// (System note: VREF high during pulse, low otherwise)
		{OV3640_IO_CTRL0, 0xFF},	// set data[7:0] pins as output
		{OV3640_EXHTS, 0x00},		//  (Default value) Line Interval Adjustment Value (dummy pixels) 
		// the frame rate will be adjusted by changing the line intervals ????????????? Not clear.
		{OV3640_AUTO_2, 0x04},		//	(Default value) - enable bandiog AEC smooth switch btween 50/60
		{OV3640_EXVTS_L, 0x00},		//	(Default value) - VSYNC Pulse Width LSB 8 bits ??????????????
		{OV3640_EXVTS_H, 0x00},		// 	(Default value) - VSYNC Pulse Width MSB 8 bits ??????????????
		{OV3640_DSP_CTRL_1, 0xde},	// 	DSP control 1
		{OV3640_PLL_1, 0x39},		// PLL1 control *Also used by the diriver*
		{OV3640_PLL_2, 0x21},		// PLL2 control *Also used by the diriver*
		{OV3640_PLL_3, 0x20},		// PLL3 control *Also used by the diriver*
		{0x304c, 0x81}, 			//  NO EXISTED under the SPEC
		{OV3640_DSP_CTRL_2, 0xef},	//	DSP control 2
		{OV3640_SIZE_IN_MISC, 0x68},//				Input configure
		{OV3640_HSIZE_IN_L, 0x18},	//	H_SIZE_IN = 0x818 (x=2072) , V_SIZE_IN = 0x60c (y=1548) (this is the active pixel area)
		{OV3640_VSIZE_IN_L, 0x0C},	//
		{OV3640_SIZE_OUT_MISC, 0x68},//				Output configure
		{OV3640_HSIZE_OUT_L, 0x08},	// H_SIZE_OUT = 0x808 (x=2056), V_SIZE_OUT = 0x604 (y=1540)
		{OV3640_VSIZE_OUT_L, 0x04},	//
		{0x3403, 0x42}, 			// 	(Default value) CIU PAD control 
		// bit 0:3 - Y start
		// bit 4:7 - X start
		{OV3640_ISP_XOUT_H, 0x08},
		{OV3640_ISP_XOUT_L, 0x00},	//	CIU X direction output size (2048)
		{OV3640_ISP_YOUT_H, 0x06},
		{OV3640_ISP_YOUT_L, 0x00},	//	CIU Y direction output size	(1536)
		{OV3640_CLK, 0x01},			//OV recomend redusing pclk by 2 due to Broadtile bus limitation which is 35M
		{OV3640_REG_TERM, OV3640_VAL_TERM}	
	},
};

const static struct ov3640_reg ov3640_standby_on[] = {
	{OV3640_PLL_1 , 0xb2},
	{OV3640_TMC13 , 0x14},
	{OV3640_TMC10 ,	0x0f},
	{OV3640_REG_TERM , OV3640_VAL_TERM},
};

const static struct ov3640_reg ov3640_standby_off[] = {
	{OV3640_TMC10	, 0x08},
	{OV3640_TMC13	, 0x14},
	{OV3640_PLL_1	, 0x32},
	{OV3640_REG_TERM, OV3640_VAL_TERM},
};

#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
const static struct capture_size_ov ov3640_sizes[] = {
	/* XGA */
	{ 1024, 768 },
	/* QXGA */
	{ 2048, 1536 },
};
#else
/* Array of image sizes supported by OV3640.  These must be ordered from
 * smallest image size to largest.
 */
const static struct capture_size_ov ov3640_sizes[] = {
	/* QQVGA */
	{160, 120},
	/* QCIF */
	{176, 144},
	/* QVGA */
	{320, 240},
	/* CIF */
	{352, 288},
	/* VGA */
	{640, 480},
	/* XGA */
	{ 1024, 768 },
	/* QXGA */
	{ 2048, 1536 },
};
#endif
/**
 * struct ov3640_sensor - main structure for storage of sensor information
 * @pdata: access functions and data for platform level information
 * @v4l2_int_device: V4L2 device structure structure
 * @pix: V4L2 pixel format information structure
 * @timeperframe: time per frame expressed as V4L fraction
 * @isize: base image size
 * @ver: ov3640 chip version
 * @width: configured width
 * @height: configuredheight
 * @vsize: vertical size for the image
 * @hsize: horizontal size for the image
 * @crop_rect: crop rectangle specifying the left,top and width and height
 */
struct ov3640_sensor {
	/* camera port */
	dmw_camera_port_t * cam_port;
	struct v4l2_int_device *v4l2_int_device;
	struct v4l2_pix_format pix;
	struct v4l2_fract timeperframe;
	int isize;
	int ver;
	int fps;
	unsigned long width;
	unsigned long height;
	unsigned long vsize;
	unsigned long hsize;
	struct v4l2_rect crop_rect;
	unsigned int vflip;
	unsigned int hflip;
	int state;
};

static struct ov3640_sensor ov3640;
static unsigned long xclk_current = OV3640_XCLK_MIN;

/* List of image formats supported by OV3640 sensor */
const static struct v4l2_fmtdesc ov3640_formats[] = {
#if OV3640_RAW_MODE
	{
		.description    = "RAW10",
		.pixelformat    = V4L2_PIX_FMT_SGRBG10,
	},
#else
	{
		/* Note:  V4L2 defines FMT_NV16 as:
		*	Two planes -- one Y, one Cr + Cb interleaved
		*   y0y1y2y3 u0v0u1v1
		*/
		.description    = "Y/CbCr, 4:2:2",
		.pixelformat    = V4L2_PIX_FMT_NV16,
	},
	{
		/* Note:  V4L2 defines FMT_NV61 as:
		*	Two planes -- one Y, one Cr + Cb interleaved
		*   y0y1y2y3 v0u0v1u1
		*/
		.description    = "Y/CrCb, 4:2:2",
		.pixelformat    = V4L2_PIX_FMT_NV61,
	},
	{
		/* Note:  V4L2 defines FMT_NV12 as:
		*	Two planes -- one Y, one Cr + Cb interleaved
		*   y0y1y2y3 u0v0
		*/
		.description    = "Y/CbCr, 4:2:0",
		.pixelformat    = V4L2_PIX_FMT_NV12,
	},
	{
		/* Note:  V4L2 defines FMT_NV12 as:
		*	Two planes -- one Y, one Cr + Cb interleaved
		*   y0y1y2y3 v0u0
		*/
		.description    = "Y/CrCb, 4:2:0",
		.pixelformat    = V4L2_PIX_FMT_NV21,
	},
	{
		/* Note:  V4L2 defines RGB565 as:
		*
		*      Byte 0                    Byte 1
		*      g2 g1 g0 r4 r3 r2 r1 r0   b4 b3 b2 b1 b0 g5 g4 g3
		*
		* We interpret RGB565 as:
		*
		*      Byte 0                    Byte 1
		*      g2 g1 g0 b4 b3 b2 b1 b0   r4 r3 r2 r1 r0 g5 g4 g3
		*/
		.description    = "RGB565, le",
		.pixelformat    = V4L2_PIX_FMT_RGB565,
	},
	{
		/* Note:  V4L2 defines RGB565X as:
		*
		*      Byte 0                    Byte 1
		*      b4 b3 b2 b1 b0 g5 g4 g3   g2 g1 g0 r4 r3 r2 r1 r0
		*
		* We interpret RGB565X as:
		*
		*      Byte 0                    Byte 1
		*      r4 r3 r2 r1 r0 g5 g4 g3   g2 g1 g0 b4 b3 b2 b1 b0
		*/
		.description    = "RGB565, be",
		.pixelformat    = V4L2_PIX_FMT_RGB565X,
	},
	{
		.description    = "YUYV (YUV 4:2:2), packed",
		.pixelformat    = V4L2_PIX_FMT_YUYV,
	},
	{
		.description    = "UYVY, packed",
		.pixelformat    = V4L2_PIX_FMT_UYVY,
	},
	{
		/* Note:  V4L2 defines RGB555 as:
		*
		*      Byte 0                    Byte 1
		*      g2 g1 g0 r4 r3 r2 r1 r0   x  b4 b3 b2 b1 b0 g4 g3
		*
		* We interpret RGB555 as:
		*
		*      Byte 0                    Byte 1
		*      g2 g1 g0 b4 b3 b2 b1 b0   x  r4 r3 r2 r1 r0 g4 g3
		*/
		.description    = "RGB555, le",
		.pixelformat    = V4L2_PIX_FMT_RGB555,
	},
	{
		/* Note:  V4L2 defines RGB555X as:
		*
		*      Byte 0                    Byte 1
		*      x  b4 b3 b2 b1 b0 g4 g3   g2 g1 g0 r4 r3 r2 r1 r0
		*
		* We interpret RGB555X as:
		*
		*      Byte 0                    Byte 1
		*      x  r4 r3 r2 r1 r0 g4 g3   g2 g1 g0 b4 b3 b2 b1 b0
		*/
		.description    = "RGB555, be",
		.pixelformat    = V4L2_PIX_FMT_RGB555X,
	},
#endif
};

#define NUM_CAPTURE_FORMATS (sizeof(ov3640_formats) / sizeof(ov3640_formats[0]))
#define NUM_DISCRETE_SIZES (sizeof(ov3640_sizes) / sizeof(ov3640_sizes[0]))
#define NUM_TIMEFRAME_VALS (sizeof(ov3640_frameintervals) / sizeof(ov3640_frameintervals[0])) 

const static struct ov3640_reg ov3640_out_xga[] = {
	{OV3640_ISP_XOUT_H, 0x04},  /* ISP_XOUT */
	{OV3640_ISP_XOUT_L, 0x00},  /* ISP_XOUT */
	{OV3640_ISP_YOUT_H, 0x03},  /* ISP_YOUT */
	{OV3640_ISP_YOUT_L, 0x00},  /* ISP_YOUT */
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

const static struct ov3640_reg ov3640_out_qxga[] = {
	{OV3640_ISP_XOUT_H, 0x08},  /* ISP_XOUT */
	{OV3640_ISP_XOUT_L, 0x00},  /* ISP_XOUT */
	{OV3640_ISP_YOUT_H, 0x06},  /* ISP_YOUT */
	{OV3640_ISP_YOUT_L, 0x00},  /* ISP_YOUT */
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

/* Brightness Settings - 7 levels */
const static struct ov3640_reg brightness[7][5] = {
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_SGNSET, 0x09},
		{OV3640_YBRIGHT, 0x30},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_SGNSET, 0x09},
		{OV3640_YBRIGHT, 0x20},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_SGNSET, 0x09},
		{OV3640_YBRIGHT, 0x10},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_SGNSET, 0x01},
		{OV3640_YBRIGHT, 0x00},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_SGNSET, 0x01},
		{OV3640_YBRIGHT, 0x10},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_SGNSET, 0x01},
		{OV3640_YBRIGHT, 0x20},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_SGNSET, 0x01},
		{OV3640_YBRIGHT, 0x30},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
};

/* Contrast Settings - 7 levels */
const static struct ov3640_reg contrast[7][5] = {
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_YOFFSET, 0x14},
		{OV3640_YGAIN, 0x14},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_YOFFSET, 0x18},
		{OV3640_YGAIN, 0x18},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_YOFFSET, 0x1c},
		{OV3640_YGAIN, 0x1c},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_YOFFSET, 0x20},
		{OV3640_YGAIN, 0x20},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_YOFFSET, 0x24},
		{OV3640_YGAIN, 0x24},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_YOFFSET, 0x28},
		{OV3640_YGAIN, 0x28},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x04},
		{OV3640_YOFFSET, 0x2c},
		{OV3640_YGAIN, 0x2c},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
};

/* Color Settings - 3 colors */
const static struct ov3640_reg colors[3][5] = {
	{
		{OV3640_SDE_CTRL, 0x00},
		{OV3640_UREG, 0x80},
		{OV3640_VREG, 0x80},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x18},
		{OV3640_UREG, 0x40},
		{OV3640_VREG, 0xa6},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	{
		{OV3640_SDE_CTRL, 0x18},
		{OV3640_UREG, 0x80},
		{OV3640_VREG, 0x80},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
};

/* Average Based Algorithm - Based on target Luminance */
const static struct ov3640_reg exposure_avg[11][5] = {
	/* -1.7EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x10},
		{OV3640_BPT_HISL, 0x08},
		{OV3640_VPT, 0x21},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* -1.3EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x18},
		{OV3640_BPT_HISL, 0x10},
		{OV3640_VPT, 0x31},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* -1.0EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x20},
		{OV3640_BPT_HISL, 0x18},
		{OV3640_VPT, 0x41},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* -0.7EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x28},
		{OV3640_BPT_HISL, 0x20},
		{OV3640_VPT, 0x51},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* -0.3EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x30},
		{OV3640_BPT_HISL, 0x28},
		{OV3640_VPT, 0x61},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* default */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x38},
		{OV3640_BPT_HISL, 0x30},
		{OV3640_VPT, 0x61},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 0.3EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x40},
		{OV3640_BPT_HISL, 0x38},
		{OV3640_VPT, 0x71},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 0.7EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x48},
		{OV3640_BPT_HISL, 0x40},
		{OV3640_VPT, 0x81},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 1.0EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x50},
		{OV3640_BPT_HISL, 0x48},
		{OV3640_VPT, 0x91},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 1.3EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x58},
		{OV3640_BPT_HISL, 0x50},
		{OV3640_VPT, 0x91},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 1.7EV */
	{
		{OV3640_HISTO7, 0x00},
		{OV3640_WPT_HISH, 0x60},
		{OV3640_BPT_HISL, 0x58},
		{OV3640_VPT, 0xa1},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
};

/* Histogram Based Algorithm - Based on histogram and probability */
const static struct ov3640_reg exposure_hist[11][5] = {
	/* -1.7EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x58},
		{OV3640_BPT_HISL, 0x38},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* -1.3EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x60},
		{OV3640_BPT_HISL, 0x40},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* -1.0EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x68},
		{OV3640_BPT_HISL, 0x48},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* -0.7EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x70},
		{OV3640_BPT_HISL, 0x50},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* -0.3EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x78},
		{OV3640_BPT_HISL, 0x58},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* default */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x80},
		{OV3640_BPT_HISL, 0x60},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 0.3EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x88},
		{OV3640_BPT_HISL, 0x68},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 0.7EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x90},
		{OV3640_BPT_HISL, 0x70},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 1.0EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0x98},
		{OV3640_BPT_HISL, 0x78},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 1.3EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0xa0},
		{OV3640_BPT_HISL, 0x80},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
	/* 1.7EV */
	{
		{OV3640_HISTO7, 0x80},
		{OV3640_WPT_HISH, 0xa8},
		{OV3640_BPT_HISL, 0x88},
		{OV3640_REG_TERM, OV3640_VAL_TERM}
	},
};

/* ov3640 register configuration for combinations of pixel format and
 * image size
 */

const static struct ov3640_reg qxga_yuv[] = {
	{OV3640_SC_CTRL0, 0x02},
	{OV3640_DSP_CTRL_4, 0x00},
	{OV3640_FMT_MUX_CTRL0, 0x00},
	{OV3640_FMT_CTRL00, 0x02},
	/*{OV3640_OUT_CTRL01, OV3640_OUT_CTRL01_MIPIBIT8},*/
	{OV3640_VTS_H, 0x06},
	{OV3640_VTS_L, 0x20},
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

const static struct ov3640_reg qxga_565[] = {
	{OV3640_SC_CTRL0, 0x02},
	{OV3640_DSP_CTRL_4, 0xFC},
	{OV3640_FMT_MUX_CTRL0, 0x01},
	{OV3640_FMT_CTRL00, 0x11},
	{OV3640_OUT_CTRL01, OV3640_OUT_CTRL01_MIPIBIT8},
	{OV3640_VTS_H, 0x06},
	{OV3640_VTS_L, 0x20},
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

const static struct ov3640_reg qxga_555[] = {
	{OV3640_SC_CTRL0, 0x02},
	{OV3640_DSP_CTRL_4, 0xFC},
	{OV3640_FMT_MUX_CTRL0, 0x01},
	{OV3640_FMT_CTRL00, 0x13},
	{OV3640_OUT_CTRL01, OV3640_OUT_CTRL01_MIPIBIT8},
	{OV3640_VTS_H, 0x06},
	{OV3640_VTS_L, 0x20},
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

const static struct ov3640_reg qxga_raw10[] = {
	{OV3640_SC_CTRL0, 0x22},
	{OV3640_DSP_CTRL_4, 0x01},
	{OV3640_FMT_MUX_CTRL0, 0x04},
	{OV3640_FMT_CTRL00, 0x18},
	{OV3640_OUT_CTRL01, 0x00},
	{OV3640_VTS_H, 0x06},
	{OV3640_VTS_L, 0x20},
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

const static struct ov3640_reg xga_yuv[] = {
	{OV3640_SC_CTRL0, 0x02},
	{OV3640_DSP_CTRL_4, 0x00},
	{OV3640_FMT_MUX_CTRL0, 0x00},
	{OV3640_FMT_CTRL00, 0x02},
	/*{OV3640_OUT_CTRL01, OV3640_OUT_CTRL01_MIPIBIT8},*/
	{OV3640_VTS_H, 0x06},
	{OV3640_VTS_L, 0x20},
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

const static struct ov3640_reg xga_565[] = {
	{OV3640_SC_CTRL0, 0x02},
	{OV3640_DSP_CTRL_4, 0xFC},
	{OV3640_FMT_MUX_CTRL0, 0x01},
	{OV3640_FMT_CTRL00, 0x11},
	{OV3640_OUT_CTRL01, OV3640_OUT_CTRL01_MIPIBIT8},
	{OV3640_VTS_H, 0x03},
	{OV3640_VTS_L, 0x10},
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

const static struct ov3640_reg xga_555[] = {
	{OV3640_SC_CTRL0, 0x02},
	{OV3640_DSP_CTRL_4, 0xFC},
	{OV3640_FMT_MUX_CTRL0, 0x01},
	{OV3640_FMT_CTRL00, 0x13},
	{OV3640_OUT_CTRL01, OV3640_OUT_CTRL01_MIPIBIT8},
	{OV3640_VTS_H, 0x03},
	{OV3640_VTS_L, 0x10},
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

const static struct ov3640_reg xga_raw10[] = {
	{OV3640_SC_CTRL0, 0x22},
	{OV3640_DSP_CTRL_4, 0x01},
	{OV3640_FMT_MUX_CTRL0, 0x04},
	{OV3640_FMT_CTRL00, 0x18},
	{OV3640_OUT_CTRL01, 0x00},
	{OV3640_VTS_H, 0x03},
	{OV3640_VTS_L, 0x10},
	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
const static struct ov3640_reg
	*ov3640_reg_init[OV_NUM_PIXEL_FORMATS][OV_NUM_IMAGE_SIZES] = {
		{xga_yuv, qxga_yuv},
		{xga_565, qxga_565},
		{xga_555, qxga_555},
		{xga_raw10, qxga_raw10 },
};
#endif

/*
 * struct vcontrol - Video controls
 * @v4l2_queryctrl: V4L2 VIDIOC_QUERYCTRL ioctl structure
 * @current_value: current value of this control
 */
static struct vcontrol {
	struct v4l2_queryctrl qc;
	int current_value;
} video_control[] = {
	{
		{
			.id = V4L2_CID_BRIGHTNESS,
			.type = V4L2_CTRL_TYPE_INTEGER,
			.name = "Brightness",
			.minimum = OV3640_MIN_BRIGHT,
			.maximum = OV3640_MAX_BRIGHT,
			.step = OV3640_BRIGHT_STEP,
			.default_value = OV3640_DEF_BRIGHT,
		},
		.current_value = OV3640_DEF_BRIGHT,
	},
	{
		{
			.id = V4L2_CID_CONTRAST,
			.type = V4L2_CTRL_TYPE_INTEGER,
			.name = "Contrast",
			.minimum = OV3640_MIN_CONTRAST,
			.maximum = OV3640_MAX_CONTRAST,
			.step = OV3640_CONTRAST_STEP,
			.default_value = OV3640_DEF_CONTRAST,
		},
		.current_value = OV3640_DEF_CONTRAST,
	},
	{
		{
			.id = V4L2_CID_PRIVATE_BASE,
			.type = V4L2_CTRL_TYPE_INTEGER,
			.name = "Color Effects",
			.minimum = OV3640_MIN_COLOR,
			.maximum = OV3640_MAX_COLOR,
			.step = OV3640_COLOR_STEP,
			.default_value = OV3640_DEF_COLOR,
		},
		.current_value = OV3640_DEF_COLOR,
	},
	{
		{
			.id = V4L2_CID_VFLIP,
			.type = V4L2_CTRL_TYPE_BOOLEAN,
			.name = "Vertical Flip",
			.default_value = OV3640_DEF_FLIP,
		},
		.current_value = OV3640_DEF_FLIP,
	},
	{
		{
			.id = V4L2_CID_HFLIP,
			.type = V4L2_CTRL_TYPE_BOOLEAN,
			.name = "Horizontal Flip (Mirror)",
			.default_value = OV3640_DEF_FLIP,
		},
		.current_value = OV3640_DEF_FLIP,
	}
};

/*
 * find_vctrl - Finds the requested ID in the video control structure array
 * @id: ID of control to search the video control array.
 *
 * Returns the index of the requested ID from the control structure array
 */
static int find_vctrl(int id)
{
	int i = 0;

	if (id < V4L2_CID_BASE)
		return -EDOM;

	for (i = (ARRAY_SIZE(video_control) - 1); i >= 0; i--)
		if (video_control[i].qc.id == id)
			break;
	if (i < 0)
		i = -EINVAL;
	return i;
}

/*
 * Read a value from a register in ov3640 sensor device.
 * The value is returned in 'val'.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov3640_read_reg(struct i2c_client *client, u16 data_length, u16 reg,
                                                               u32 *val)
{
	int err = 0;
	struct i2c_msg msg[2];
	unsigned char data[4];

	if (!client || !client->adapter) {
		PDEBUG("Invalid input\n");
		return -ENODEV;
	}
      
	msg[0].addr = client->addr;
	msg[0].flags = I2C_M_WR;
	msg[0].len = 2;
	msg[0].buf = data;

	msg[1].addr = client->addr;
	msg[1].flags = I2C_M_RD;
	msg[1].len = data_length;
	msg[1].buf = data;

	/* High byte goes out first */
	data[0] = (u8) (reg >> 8);
	data[1] = (u8) (reg & 0xff);

	err = i2c_transfer(client->adapter, msg, 2);
	if (err >= 0) {
		*val = 0;
	/* High byte comes first */
	if (data_length == 1)
		*val = data[0];
	else if (data_length == 2)
		*val = data[1] + (data[0] << 8);
	else
		*val = data[3] + (data[2] << 8) +
		(data[1] << 16) + (data[0] << 24);
		return 0;
	}
	PDEBUG("read from offset 0x%x error %d\n", reg, err);
	return err;
}

/* Write a value to a register in ov3640 sensor device.
 * @client: i2c driver client structure.
 * @reg: Address of the register to read value from.
 * @val: Value to be written to a specific register.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov3640_write_reg(struct i2c_client *client, u16 reg, u8 val)
{
	int err = 0;
	struct i2c_msg msg[1];
	unsigned char data[3];
	int retries = 0;

	if (!client || !client->adapter) {
		PDEBUG("Invalid input\n");
		return -ENODEV;
	}
	PDEBUG("__78 %x %x\n",reg,val);
retry:
	msg->addr = client->addr;
	msg->flags = I2C_M_WR;
	msg->len = 3;
	msg->buf = data;

	/* high byte goes out first */
	data[0] = (u8) (reg >> 8);
	data[1] = (u8) (reg & 0xff);
	data[2] = val;

	err = i2c_transfer(client->adapter, msg, 1);
	udelay(50);

	if (err >= 0)
		return 0;

	if (retries <= 5) {
		dev_dbg(&client->dev, "Retrying I2C... %d", retries);
		retries++;
		set_current_state(TASK_UNINTERRUPTIBLE);
		schedule_timeout(msecs_to_jiffies(20));
		goto retry;
	}

	return err;
}

#if 0
static int ov3640_read_regs(struct i2c_client *client,
                                       struct ov3640_reg reglist[])
{
	int err = 0;
	struct ov3640_reg *next;
	unsigned int val = 0;

	if (!client || !reglist) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	next = reglist;

	while (next && !((next->reg == OV3640_REG_TERM) && (next->val == OV3640_VAL_TERM))) {
		err = ov3640_read_reg(client, 1, next->reg, &val);
		udelay(100);
		if (err)
			return err;
		PDEBUG("off=0x%2x val=0x%02x\n",next->reg ,val );
		next->val = (unsigned char)val;
		next++;
	}
	return 0;
}
#endif

/*
 * Initialize a list of ov3640 registers.
 * The list of registers is terminated by the pair of values
 * {OV3640_REG_TERM, OV3640_VAL_TERM}.
 * @reglist[]: List of address of the registers to write data.
 * Returns zero if successful, or non-zero otherwise.
 */
static int ov3640_write_regs(const struct ov3640_reg reglist[])
{
	int err = 0;
	const struct ov3640_reg *next;
	struct i2c_client * client;

	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return -EIO;
	}

	if (!reglist) {
		dmw_camera_put_i2c(ov3640.cam_port);
		PDEBUG("Invalid input\n");
		return -1;
	}

	next = reglist;

	while (next && !((next->reg == OV3640_REG_TERM)
	&& (next->val == OV3640_VAL_TERM))) {
		err = ov3640_write_reg(client, next->reg, next->val);
		udelay(100);
		if (err) {
			dmw_camera_put_i2c(ov3640.cam_port);
			return err;
		}
		next++;
	}

	dmw_camera_put_i2c(ov3640.cam_port);
	return 0;
}
#ifndef CONFIG_SENSOR_FPS_MULTI_SUPPORT
static int ov3640_init_mode(enum ov3640_frameintervals_type frame_rate,
							enum image_size_ov size)
{
	struct reg_value *pModeSetting = NULL;
	s32 i = 0;
	s32 iModeSettingArySize = 0;
	register u32 Delay_ms = 0;
	register u16 RegAddr = 0;
	register u8 Mask = 0;
	register u8 Val = 0;
	u32 RegVal = 0;
	int retval = 0;
	struct i2c_client * client;

	if (size > OV3640_MODE_MAX || size < OV3640_MODE_MIN ) {
		pr_err("Wrong ov3640 size detected! or invalid client\n");
		return -1;
	}

	PDEBUG("frame_rate=%d size=%d\n",frame_rate, size);
	pModeSetting = ov3640_mode_info_data[frame_rate][size].init_data_ptr;
	iModeSettingArySize = ov3640_mode_info_data[frame_rate][size].init_data_size;

	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return -EIO;
	}

	for (i = 0; i < iModeSettingArySize; ++i, ++pModeSetting) {
		Delay_ms = pModeSetting->u32Delay_ms;
		RegAddr = pModeSetting->u16RegAddr;
		Val = pModeSetting->u8Val;
		Mask = pModeSetting->u8Mask;

		if (Mask) {
			retval =  ov3640_read_reg(client, 1, RegAddr, &RegVal);
			if (retval < 0)
				goto ovinit_err;

			RegVal &= ~(u8)Mask;
			Val &= Mask;
			Val |= RegVal;
		}

		retval = ov3640_write_reg(client, RegAddr, Val);
		if (retval < 0)
			goto ovinit_err;

		if (Delay_ms)
			msleep(Delay_ms);
	}

ovinit_err:
	dmw_camera_put_i2c(ov3640.cam_port);
	return retval;
}
#endif

static void ov3640_set_flip(void)
{
	struct i2c_client * client;
	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	PDEBUG("Hflip is %s  Vflip is %s\n", ((ov3640.hflip == 1) ? "On" : "Off") , ((ov3640.vflip == 1) ? "On" : "Off") );
    PDEBUG("%s\n",__func__);
	if (!ov3640.hflip && !ov3640.vflip){
		ov3640_write_reg(client, 0x307c, 0x10);
		ov3640_write_reg(client, 0x3023, 0x0a);
		ov3640_write_reg(client, 0x3090, 0xc0);
	}

	if (!ov3640.hflip && ov3640.vflip){
		ov3640_write_reg(client, 0x307c, 0x11);
		ov3640_write_reg(client, 0x3023, 0x09);
		ov3640_write_reg(client, 0x3090, 0xc0);
	}

	if (ov3640.hflip && !ov3640.vflip){
		ov3640_write_reg(client, 0x307c, 0x12);
		ov3640_write_reg(client, 0x3023, 0x0a);
		ov3640_write_reg(client, 0x3090, 0xc8);
	}

	if (ov3640.hflip && ov3640.vflip){
		ov3640_write_reg(client, 0x307c, 0x13);
		ov3640_write_reg(client, 0x3023, 0x09);	
		ov3640_write_reg(client, 0x3090, 0xc8);
	}

	dmw_camera_put_i2c(ov3640.cam_port);
}

static int ov3640_set_v_flip(unsigned int val)
{
	PDEBUG("%s\n",__func__);
	ov3640.vflip = ((val > 0) ? 1 : 0);

	ov3640_set_flip();

	return 0;
}

static int ov3640_set_h_flip(unsigned int val)
{
	PDEBUG("%s\n",__func__);
	ov3640.hflip = ((val > 0) ? 1 : 0);

	ov3640_set_flip();

	return 0;
}

#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
/* Find the best match for a requested image capture size.  The best match
 * is chosen as the nearest match that has the same number or fewer pixels
 * as the requested size, or the smallest image size if the requested size
 * has fewer pixels than the smallest image.
 */
static int
ov3640_find_size(unsigned int width, unsigned int height , enum image_size_ov* size)
{
	if ((width > ov3640_sizes[XGA].width) || (height > ov3640_sizes[XGA].height))
		*size = QXGA;
	else
		*size =  XGA;

	return 0;
}
#else
static int
ov3640_find_size(unsigned int width, unsigned int height , enum image_size_ov* size)
{
	if ((width == ov3640_sizes[QQVGA].width) && (height == ov3640_sizes[QQVGA].height))
		*size = QQVGA;	
	else if ((width == ov3640_sizes[QCIF].width) && (height == ov3640_sizes[QCIF].height))
		*size = QCIF;
	else if ((width == ov3640_sizes[QVGA].width) && (height == ov3640_sizes[QVGA].height))
		*size = QVGA;
	else if ((width == ov3640_sizes[CIF].width) && (height == ov3640_sizes[CIF].height))
		*size = CIF;
	else if ((width == ov3640_sizes[VGA].width) && (height == ov3640_sizes[VGA].height))
		*size = VGA;
	else if ((width == ov3640_sizes[XGA].width) && (height == ov3640_sizes[XGA].height))
		*size = XGA;
	else if ((width == ov3640_sizes[QXGA].width) && (height == ov3640_sizes[QXGA].height))
		*size = QXGA;
	else
		return -1;

	return 0;
}
#endif

#if 0
static void ciu_init_yuv422_ccir601_30fps(void)
{
	struct i2c_client * client;

	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	ov3640_write_reg(client,0x300e, 0x24);
	ov3640_write_reg(client,0x300f, 0x21);
	ov3640_write_reg(client,0x3010, 0x00);
	ov3640_write_reg(client,0x3011, 0x00);
	ov3640_write_reg(client,0x3028, 0x09);
	ov3640_write_reg(client,0x3029, 0x4d);
	ov3640_write_reg(client,0x304c, 0x82);

	ov3640_write_reg(client,0x3070, 0x00);
	ov3640_write_reg(client,0x3071, 0xec);
	ov3640_write_reg(client,0x301c, 0x2);

	dmw_camera_put_i2c(ov3640.cam_port);
}

static void ciu_init_yuv422_ccir601_20fps(void)
{
	struct i2c_client * client;
	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	ov3640_write_reg(client,0x300e, 0x2d);
	ov3640_write_reg(client,0x300f, 0x21);
	ov3640_write_reg(client,0x3010, 0x0);
	ov3640_write_reg(client,0x3011, 0x0);

	ov3640_write_reg(client,0x3028, 0x09);
	ov3640_write_reg(client,0x3029, 0x77);
	ov3640_write_reg(client,0x304c, 0x82);

	ov3640_write_reg(client,0x3070, 0x00);
	ov3640_write_reg(client,0x3071, 0x9e);
	ov3640_write_reg(client,0x301c, 0x04);

	dmw_camera_put_i2c(ov3640.cam_port);
}

static void ciu_init_yuv422_ccir601_15fps(void)
{
	struct i2c_client * client;
	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	ov3640_write_reg(client,0x300e, 0x36);
	ov3640_write_reg(client,0x300f, 0x21);
	ov3640_write_reg(client,0x3010, 0x0);
	ov3640_write_reg(client,0x3011, 0x0);

	ov3640_write_reg(client,0x3028, 0x09);
	ov3640_write_reg(client,0x3029, 0x4d);
	ov3640_write_reg(client,0x304c, 0x82);

	ov3640_write_reg(client,0x3070, 0x00);
	ov3640_write_reg(client,0x3071, 0x77);
	ov3640_write_reg(client,0x301c, 0x06);

	dmw_camera_put_i2c(ov3640.cam_port);
}

static void ciu_init_yuv422_ccir601_10fps(void)
{
	struct i2c_client * client;
	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	ov3640_write_reg(client,0x300e, 0x36);
	ov3640_write_reg(client,0x300f, 0x21);
	ov3640_write_reg(client,0x3010, 0x0);
	ov3640_write_reg(client,0x3011, 0x0);

	ov3640_write_reg(client,0x3028, 0x09);
	ov3640_write_reg(client,0x3029, 0xf7);
	ov3640_write_reg(client,0x304c, 0x82);

	ov3640_write_reg(client,0x3070, 0x00);
	ov3640_write_reg(client,0x3071, 0x4f);
	ov3640_write_reg(client,0x301c, 0x09);

	dmw_camera_put_i2c(ov3640.cam_port);
}

static void ciu_init_yuv422_ccir601_7fps(void)
{
	struct i2c_client * client;
	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	ov3640_write_reg(client,0x300e, 0x39);
	ov3640_write_reg(client,0x300f, 0x21);
	ov3640_write_reg(client,0x3010, 0x20);
	ov3640_write_reg(client,0x3011, 0x01);
	ov3640_write_reg(client,0x304c, 0x82);

	ov3640_write_reg(client,0x3028, 0x09);
	ov3640_write_reg(client,0x3029, 0x47);
	ov3640_write_reg(client,0x302a, 0x03);
	ov3640_write_reg(client,0x302b, 0x4a);

	dmw_camera_put_i2c(ov3640.cam_port);
}

static void ciu_init_yuv422_ccir601_6fps(void)
{
	struct i2c_client * client;
	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	ov3640_write_reg(client,0x300e, 0x34);
	ov3640_write_reg(client,0x300f, 0x21);
	ov3640_write_reg(client,0x3010, 0x00);
	ov3640_write_reg(client,0x3011, 0x01);

	ov3640_write_reg(client,0x3028, 0x09);
	ov3640_write_reg(client,0x3029, 0xf7);

	ov3640_write_reg(client,0x304c, 0x82);

	ov3640_write_reg(client,0x3070, 0x00);
	ov3640_write_reg(client,0x3071, 0x30);
	ov3640_write_reg(client,0x301c, 0x10);

	dmw_camera_put_i2c(ov3640.cam_port);
}

static void ciu_init_yuv422_ccir601_3fps(void)
{
	struct i2c_client * client;
	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	ov3640_write_reg(client,0x300e, 0x39);
	ov3640_write_reg(client,0x300f, 0x21);
	ov3640_write_reg(client,0x3010, 0x20);
	ov3640_write_reg(client,0x3011, 0x01);
	ov3640_write_reg(client,0x304c, 0x82);

	ov3640_write_reg(client,0x3028, 0x09);
	ov3640_write_reg(client,0x3029, 0x47);
	ov3640_write_reg(client,0x302a, 0x07);
	ov3640_write_reg(client,0x302b, 0xAD);

	dmw_camera_put_i2c(ov3640.cam_port);
}
#endif

#if 0
/**
 * ov3640_set_framerate
 **/
static int ov3640_set_framerate(struct i2c_client *client,
                                               struct v4l2_fract *fper,
                                               enum image_size_ov isize)
{
	u32 tempfps1, tempfps2;
	u8 clkval;
/*
	u32 origvts, newvts, templineperiod;
	u32 origvts_h, origvts_l, newvts_h, newvts_l;
*/
	int err = 0;

	if (!client || !fper ) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	if (isize == XGA) {
		PDEBUG("isize == XGA \n");
		return 0;
		err = ov3640_write_reg(client, OV3640_PLL_1, 0x34);
		err = ov3640_write_reg(client, OV3640_PLL_2, 0x21);
		err = ov3640_write_reg(client, OV3640_PLL_3, 0x20);
		err = ov3640_write_reg(client, OV3640_CLK, 0x00);
		err = ov3640_write_reg(client, 0x304c, 0x84);
		return err;
	}

	/* FIXME: QXGA framerate setting forced to 15 FPS */
	if (isize == QXGA) {
		PDEBUG("isize == QXGA \n");
		return 0;
		err = ov3640_write_reg(client, OV3640_PLL_1, 0x38);/*SAME AS SYSTEM*/
		err = ov3640_write_reg(client, OV3640_PLL_2, 0x21);/*SAME AS SYSTEM*/
		err = ov3640_write_reg(client, OV3640_PLL_3, 0x20);/*SAME AS SYSTEM*/
		err = ov3640_write_reg(client, OV3640_CLK, 0x01);/*SAME AS SYSTEM*/
		err = ov3640_write_reg(client, 0x304c, 0x84);
		return err;
	}
	PDEBUG("isize == different \n");
	return 0;
	   
	tempfps1 = fper->denominator * 10000;
	tempfps1 /= fper->numerator;
	tempfps2 = fper->denominator / fper->numerator;
	if ((tempfps1 % 10000) != 0)
		tempfps2++;
	clkval = (u8)((30 / tempfps2) - 1);

	err = ov3640_write_reg(client, OV3640_CLK, clkval);
	/* RxPLL = 50d = 32h */
	err = ov3640_write_reg(client, OV3640_PLL_1, 0x38);
	/* RxPLL = 50d = 32h */

	/*
	err = ov3640_write_reg(client, OV3640_PLL_2,
							OV3640_PLL_2_BIT8DIV_4 |
							OV3640_PLL_2_INDIV_1_5);
	*/
	   

	/*
	* NOTE: Sergio's Fix for MIPI CLK timings, not suggested by OV
	*/
	/*err = ov3640_write_reg(client, OV3640_PLL_3, 0x21 +(clkval & 0xF));*/

	/* Setting DVP divisor value */
	err = ov3640_write_reg(client, 0x304c, 0x82);
	/* FIXME: Time adjustment to add granularity to the available fps */
	/*
	ov3640_read_reg(client, 1, OV3640_VTS_H, &origvts_h);
	ov3640_read_reg(client, 1, OV3640_VTS_L, &origvts_l);
	origvts = (u32)((origvts_h << 8) + origvts_l);
	templineperiod = 1000000 / (tempfps2 * origvts);
	newvts = 1000000 / (tempfps2 * templineperiod);
	newvts_h = (u8)((newvts & 0xFF00) >> 8);
	newvts_l = (u8)(newvts & 0xFF);
	err = ov3640_write_reg(client, OV3640_VTS_H, newvts_h);
	err = ov3640_write_reg(client, OV3640_VTS_L, newvts_l);
	*/
	return err;
}
#endif

static const struct ov3640_reg debug_dump[] =
{
	{OV3640_IO_CTRL1, 0},
	{OV3640_OUT_CTRL00, 0},
	{OV3640_IO_CTRL0, 0},

	{OV3640_VTS_H, 0},
	{OV3640_VTS_L, 0},

	{OV3640_EXHTS, 0},
	{OV3640_AUTO_2, 0},	
	{OV3640_EXVTS_L, 0},	
	{OV3640_EXVTS_H, 0},	

	{OV3640_SC_CTRL0, 0},	
	{OV3640_DSP_CTRL_1, 0},	
	{OV3640_DSP_CTRL_4, 0},	
	{OV3640_FMT_MUX_CTRL0, 0},
	{OV3640_FMT_CTRL00, 0},

	{OV3640_PLL_1, 0},	
	{OV3640_PLL_2, 0},	
	{OV3640_PLL_3, 0},	
	{0x304c, 0x81}, 
	{OV3640_DSP_CTRL_2, 0},	

	{OV3640_SIZE_IN_MISC,0},
	{OV3640_HSIZE_IN_L,0},
	{OV3640_VSIZE_IN_L,0},
	{OV3640_SIZE_OUT_MISC,0},
	{OV3640_HSIZE_OUT_L,0},
	{OV3640_VSIZE_OUT_L,0},
	{OV3640_ISP_PAD_CTR2,0},
	{OV3640_ISP_XOUT_H,0},
	{OV3640_ISP_XOUT_L,0},
	{OV3640_ISP_YOUT_H,0},
	{OV3640_ISP_YOUT_L,0},
	{OV3640_HS_H,0},
	{OV3640_HS_L,0},
	{OV3640_VS_H,0},
	{OV3640_VS_L,0},
			   
	{OV3640_HW_H,0},
	{OV3640_HW_L,0},
	{OV3640_VH_H,0},
	{OV3640_VH_L,0},

	{OV3640_HTS_H,0},
	{OV3640_HTS_L,0},
	{OV3640_VTS_H,0},
	{OV3640_VTS_L,0},

	{OV3640_REG_TERM, OV3640_VAL_TERM}
};

#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
const struct v4l2_fract ov3640_frameintervals[] = {
	{ .numerator = 1, .denominator = 3 },
	{ .numerator = 1, .denominator = 5 },
	{ .numerator = 2, .denominator = 15 },
	{ .numerator = 1, .denominator = 10 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 20 },
	{ .numerator = 1, .denominator = 30 },
};
#else
const struct v4l2_fract ov3640_frameintervals[] = {
// TODO DEBUG
    { .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },
	{ .numerator = 1, .denominator = 15 },

//	{ .numerator = 1, .denominator = 15 },
//	{ .numerator = 1, .denominator = 30 },
};
#endif

#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
static int switch_fps(struct v4l2_fract *a, enum ov3640_frameintervals_type* fps)
{
	unsigned int i = 0;
	if(!a) {
		PDEBUG("Invalid input\n");
		return -1;
	}
	PDEBUG("%s\n",__func__);
	PDEBUG("Try to set FPS to denominator=%d numerator=%d \n",a->denominator ,a->numerator );

	for (i = 0 ; i < NUM_TIMEFRAME_VALS ; i++) {
		PDEBUG("Check FPS to denominator=%d numerator=%d \n",
				ov3640_frameintervals[i].denominator , ov3640_frameintervals[i].numerator);
		if ( (a->denominator == ov3640_frameintervals[i].denominator)
				&& (a->numerator == ov3640_frameintervals[i].numerator) ) {
			switch (i) {
				case OV34_3_FPS:
					//ciu_init_yuv422_ccir601_3fps(c);
					*fps = OV34_3_FPS;
					PDEBUG("setting 3 FPS\n");
					break;
				case OV34_5_FPS:
					//ciu_init_yuv422_ccir601_6fps(c);
					*fps = OV34_5_FPS;
					PDEBUG("setting 6 FPS\n");
					break;
				case OV34_7_5_FPS:
					//ciu_init_yuv422_ccir601_7fps(c);
					*fps = OV34_7_5_FPS;
					PDEBUG("setting 7 FPS\n");
					break;
				case OV34_10_FPS:
					//ciu_init_yuv422_ccir601_10fps(c);
					*fps = OV34_10_FPS;
					PDEBUG("setting 10 FPS\n");
					break;
				case OV34_15_FPS:
					//ciu_init_yuv422_ccir601_15fps(c);
					*fps = OV34_15_FPS;
					PDEBUG("setting 15 FPS\n");
					break;
				case OV34_20_FPS:
					//ciu_init_yuv422_ccir601_20fps(c);
					*fps = OV34_20_FPS;
					PDEBUG("setting 20 FPS\n");
					break;
				case OV34_30_FPS:
					//ciu_init_yuv422_ccir601_30fps(c);
					*fps = OV34_30_FPS;
					PDEBUG("setting 30 FPS\n");
					break;
				default:
					//ciu_init_yuv422_ccir601_3fps(c);
					*fps = OV34_30_FPS;
					PDEBUG("Non existed set to 3 FPS as default\n");
			}
			break;
		}
	}

	if (i == NUM_TIMEFRAME_VALS) {
		PDEBUG("Invalid frame interval\n");
		return -1;
	}

	return 0;
}
#else
static int switch_fps(struct v4l2_fract *a, enum ov3640_frameintervals_type* fps)
{
	unsigned int i = 0;
	if(!a) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	PDEBUG("Try to set FPS to denominator=%d numerator=%d \n",a->denominator ,a->numerator );

	for (i = 0 ; i < NUM_TIMEFRAME_VALS ; i++) {
		PDEBUG("Check FPS to denominator=%d numerator=%d \n",
				ov3640_frameintervals[i].denominator , ov3640_frameintervals[i].numerator);
        if ( (a->denominator == ov3640_frameintervals[i].denominator)
				&& (a->numerator == ov3640_frameintervals[i].numerator) ) {
			switch (i) {
				case OV34_15_FPS:
					*fps = OV34_15_FPS;
					PDEBUG("setting 15 FPS\n");
					break;
				case OV34_30_FPS:
					*fps = OV34_30_FPS;
					PDEBUG("setting 30 FPS\n");
					break;
				default:
					PDEBUG("Non existed set to 15 FPS as default\n");
					*fps = OV34_15_FPS;
			}
			break;
		}
	}

	if (i == NUM_TIMEFRAME_VALS) {
        PDEBUG("Invalid frame interval\n");
        return -1;
    }

	return 0;
}

static void ov3640_set_fmt(unsigned int pixelformat)
{
	struct i2c_client * client;
	u32 regval = 0;

	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	ov3640_read_reg(client,1, OV3640_FMT_CTRL00, &regval);
	/*Bits 5-6 configure the YCbCr composition*/
	regval &= ~(0x3f);

	switch (pixelformat) {
		case V4L2_PIX_FMT_NV12:
		case V4L2_PIX_FMT_NV16:	
			regval |= (0x2);
			break;
		case V4L2_PIX_FMT_NV21:
		case V4L2_PIX_FMT_NV61:
			regval |= (0x3);
	}
	
	ov3640_write_reg(client, OV3640_FMT_CTRL00, regval);

	dmw_camera_put_i2c(ov3640.cam_port);
}
#endif


#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
/*
 * Configure the ov3640 for a specified image size, pixel format, and frame
 * period.  xclk is the frequency (in Hz) of the xclk input to the OV3640.
 * fper is the frame period (in seconds) expressed as a fraction.
 * Returns zero if successful, or non-zero otherwise.
 * The actual frame period is returned in fper.
 */
static int ov3640_configure(struct v4l2_int_device *s)
{
	struct ov3640_sensor *sensor;
	struct v4l2_pix_format *pix;
	enum image_size_ov isize = XGA;
	//enum ov3640_frameintervals_type fps= 0;
	unsigned char hsize_l = 0, hsize_h = 0;
	unsigned char vsize_l = 0, vsize_h = 0;

	int vsize = 0, hsize = 0, height_l = 0, height_h = 0, width_l = 0;

	int width_h = 0, ratio = 0, err = 0;
	unsigned int tmp_size = 0;
	unsigned int  vstart = 0;
	unsigned int  hstart = 0;
	unsigned int vsize_before_crop = 0;
	unsigned int hsize_before_crop = 0;
	struct i2c_client * client;

	enum pixel_format_ov pfmt = YUV;
	PDEBUG("%s\n",__func__);
	if (s && s->priv) {
		sensor = s->priv;
		pix = &sensor->pix;
	}
	else {
		PDEBUG("Invalid input\n");
		return -1;
	}
       
	switch (pix->pixelformat) {
		case V4L2_PIX_FMT_RGB565:
		case V4L2_PIX_FMT_RGB565X:
			pfmt = RGB565;
			break;
		case V4L2_PIX_FMT_RGB555:
		case V4L2_PIX_FMT_RGB555X:
			pfmt = RGB555;
			break;
		case V4L2_PIX_FMT_SGRBG10:
			pfmt = RAW10;
			break;
		case V4L2_PIX_FMT_NV12:
		case V4L2_PIX_FMT_NV16:
		case V4L2_PIX_FMT_NV21:
		case V4L2_PIX_FMT_NV61:
		case V4L2_PIX_FMT_YUYV:
		case V4L2_PIX_FMT_UYVY:
			default:
			pfmt = YUV;
	}

	/* Set receivers virtual channel before sensor setup starts.
	* Only set the sensors virtual channel after all other setup
	* for the sensor is complete.
	*/
	ov3640_find_size(pix->width, pix->height, &isize);

	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return -EIO;
	}

	/* Reset */
	ov3640_write_reg(client, OV3640_SYS, 0x80);
	mdelay(5);

	/* Common registers */
	err = ov3640_write_regs(ov3640_common[isize]);
	PDEBUG("isize=%d\n", isize);

	/* Configure image size and pixel format */
	err = ov3640_write_regs(ov3640_reg_init[pfmt][isize]);

	PDEBUG("pfmt=%d \n", pfmt );
	PDEBUG("pix->height=%d pix->width=%d \n",pix->height,pix->width);

	/* Setting of frame rate (OV suggested way) */
	//err = ov3640_set_framerate(client, &sensor->timeperframe, isize);
	//err = switch_fps(&sensor->timeperframe , client, &fps);

	ov3640_set_flip();

	sensor->isize = isize;

	/* Scale image if needed*/
	if ( ((pix->width == ov3640_sizes[QXGA].width) && (pix->height == ov3640_sizes[QXGA].height) && (isize == QXGA))	||
		((pix->width == ov3640_sizes[XGA].width) && (pix->height == ov3640_sizes[XGA].height) && (isize == XGA))	
		|| (pfmt == RAW10) ) {
			/* if the image size correspond to one of the base image sizes
			then we don't need to scale the image */
			sensor->hsize = pix->width;
			sensor->vsize = pix->height;

			if (isize == XGA)
				ov3640_write_regs(ov3640_out_xga);
			else /*(isize == QXGA)*/
				ov3640_write_regs(ov3640_out_qxga);

			PDEBUG("\n");
	}
	else {
		/* Default Ver and Hor sizes for QXGA and XGA*/
		if (isize == QXGA) {
			vsize = 0x60c;  /*0x60c = 1536*/
			hsize = 0x818; /* 0x818 = 2072*/
			PDEBUG("\n");
		}
		else { /*(isize == XGA) */
			vsize = 0x304;	/*0x304 = 772*/
			hsize = 0x40c;	/*0x40c = 1036*/
			PDEBUG("\n");
		}

		hsize_before_crop = hsize;
		vsize_before_crop = vsize;

		/*Scaling Adjust V and H sizes for image sizes not derived form VGA (adjust the ratio between x and y)*/
		ratio = (pix->width * 1000) / pix->height;

		if  (((vsize * ratio + 500) / 1000) > hsize)
			vsize = (hsize * 1000) / ratio ;
		else
			hsize = (vsize * ratio + 500) / 1000;

		/* We need even numbers */
		if (vsize & 1)
			vsize--;
		if (hsize & 1)
			hsize--;

		/* This is for cropping */
		vstart = ((vsize_before_crop - vsize) > 0) ? ((vsize_before_crop - vsize) / 2) : 0;
		hstart = ((hsize_before_crop - hsize) > 0) ? ((hsize_before_crop - hsize) / 2) : 0; 

		PDEBUG("hsize_before_crop=%d vsize_before_crop=%d\n", vsize_before_crop , hsize_before_crop);
		PDEBUG("hsize=%d vsize=%d\n", hsize , vsize);
		PDEBUG("hstart=%d vstart=%d\n", hstart , vstart);

		/* Adjusting numbers to set registers correctly*/
		hsize_l = (0xFF & hsize);
		hsize_h = (0xF00 & hsize) >> 8;
		vsize_l = (0xFF & vsize);
		vsize_h = (0x700 & vsize) >> 4;

		/*According to Software app notes we have to add 0x08 and 0x04 in order to scale correctly*/
		tmp_size = pix->width + 0x8;
		width_l = (0xFF & tmp_size);
		width_h = (0xF00 & tmp_size) >> 8;

		tmp_size = pix->height  + 0x04;
		height_l = (0xFF & tmp_size);
		height_h = (0x700 & tmp_size) >> 4;

		/*//////////////////////////////////////////////////////
		//TODO plesae fix: Cropping the other remaining 
		err = ov3640_write_reg(client, OV3640_HS_H, (hstart & 0xF00) >> 8);
		err = ov3640_write_reg(client, OV3640_HS_L, hstart & 0xFF);
		err = ov3640_write_reg(client, OV3640_VS_H, (vstart & 0x700) >> 8);
		err = ov3640_write_reg(client, OV3640_VS_L, vstart & 0xFF);

		err = ov3640_write_reg(client, OV3640_HW_H, hsize_h && 0xFF);
		err = ov3640_write_reg(client, OV3640_HW_L, hsize_l && 0xFF);
		err = ov3640_write_reg(client, OV3640_VH_H, vsize_h && 0xFF);
		err = ov3640_write_reg(client, OV3640_VH_L, vsize_l && 0xFF);

		ov3640_write_reg(client, 0x304c, 0x84);
		///////////////////////////////////////////////////////*/

		err = ov3640_write_reg(client, OV3640_SIZE_IN_MISC,(vsize_h | hsize_h));
		PDEBUG("OV3640_SIZE_IN_MISC = %x\n", (vsize_h | hsize_h) );
		err = ov3640_write_reg(client, OV3640_HSIZE_IN_L, hsize_l);
		PDEBUG("OV3640_HSIZE_IN_L = %x\n", hsize_l );
		err = ov3640_write_reg(client, OV3640_VSIZE_IN_L, vsize_l);
		PDEBUG("OV3640_VSIZE_IN_L = %x\n", vsize_l );

		err = ov3640_write_reg(client, OV3640_SIZE_OUT_MISC,(height_h | width_h));
		PDEBUG("OV3640_SIZE_OUT_MISC = %x\n", (height_h | width_h) );
		err = ov3640_write_reg(client, OV3640_HSIZE_OUT_L, width_l);
		PDEBUG("OV3640_HSIZE_OUT_L = %x\n", width_l );
		err = ov3640_write_reg(client, OV3640_VSIZE_OUT_L, height_l);
		PDEBUG("OV3640_VSIZE_OUT_L = %x\n", height_l );

		err = ov3640_write_reg(client, OV3640_ISP_PAD_CTR2, 0x42);

		err = ov3640_write_reg(client, OV3640_ISP_XOUT_H, (pix->width & 0xF00) >> 8);
		PDEBUG("OV3640_ISP_XOUT_H = %x\n", (pix->width & 0xF00) >> 8 );
		err = ov3640_write_reg(client, OV3640_ISP_XOUT_L, pix->width & 0xFF);
		PDEBUG("OV3640_ISP_XOUT_L = %x\n", pix->width & 0xFF );
		err = ov3640_write_reg(client, OV3640_ISP_YOUT_H, (pix->height & 0x700) >> 8);
		PDEBUG("OV3640_ISP_YOUT_H = %x\n", (pix->height & 0x700) >> 8);
		err = ov3640_write_reg(client, OV3640_ISP_YOUT_L, pix->height & 0xFF);
		PDEBUG("OV3640_ISP_YOUT_L = %x\n", pix->height & 0xFF);

		/*ov3640_read_regs(client,debug_dump);*/

		sensor->hsize = hsize;
		sensor->vsize = vsize;

		dev_dbg(&client->dev, "HSIZE_IN =%i  VSIZE_IN =%i\n",
				hsize, vsize);

		dev_dbg(&client->dev, "HSIZE_OUT=%u  VSIZE_OUT=%u\n",
				(pix->width + 8),
				(pix->height + 4));
		dev_dbg(&client->dev, "ISP_XOUT =%u  ISP_YOUT =%u\n",
				pix->width,
				pix->height);

		PDEBUG("HSIZE_IN =%d  VSIZE_IN =%d\n", hsize,vsize);
		PDEBUG("HSIZE_OUT=%d  VSIZE_OUT=%d\n",(pix->width + 8 ),(pix->height + 4));
		PDEBUG("ISP_XOUT =%d  ISP_YOUT =%d\n",pix->width,pix->height);

		PDEBUG("\n");
	}

	dmw_camera_put_i2c(ov3640.cam_port);

	/* Store image size */
	sensor->isize = isize;
	sensor->width = pix->width;
	sensor->height = pix->height;

	sensor->crop_rect.left = 0;
	sensor->crop_rect.width = pix->width;
	sensor->crop_rect.top = 0;
	sensor->crop_rect.height = pix->height;

	return err;
}
#else
static int ov3640_configure(struct v4l2_int_device *s)
{
	struct ov3640_sensor *sensor = NULL;
	struct v4l2_pix_format *pix = NULL;
	enum image_size_ov isize = QVGA;
	enum ov3640_frameintervals_type frame_rate = OV34_15_FPS;
	int err = 0;

	if (s && s->priv) {
		sensor = s->priv;
		pix = &sensor->pix;
	}

	if (!sensor || !pix ) {
		PDEBUG("Invalid input\n");
		return -1;
	}
       
	/* Set receivers virtual channel before sensor setup starts.
	* Only set the sensors virtual channel after all other setup
	* for the sensor is complete.
	*/
	err = ov3640_find_size(pix->width, pix->height, &isize);
	if (err)
		return err;

	switch_fps(&sensor->timeperframe, &frame_rate);

	ov3640_init_mode(frame_rate , isize);

	ov3640_set_fmt(sensor->pix.pixelformat);

	//ov3640_set_flip(client);

	sensor->isize = isize;

	/* Store image size */
	sensor->isize = isize;
	sensor->width = pix->width;
	sensor->height = pix->height;

	sensor->crop_rect.left = 0;
	sensor->crop_rect.width = pix->width;
	sensor->crop_rect.top = 0;
	sensor->crop_rect.height = pix->height;

	return err;
}
#endif

/* Detect if an ov3640 is present, returns a negative error number if no
 * device is detected, or pidl as version number if a device is detected.
 */
static int ov3640_detect(void)
{
	u32 pidh = 0, pidl = 0;
	struct i2c_client * client;

	PDEBUG("%s\n",__func__);

	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return -EIO;
	}

	if (ov3640_read_reg(client, 1, OV3640_PIDH, &pidh)) {
		dmw_camera_put_i2c(ov3640.cam_port);
		return -ENODEV;
	}

	if (ov3640_read_reg(client, 1, OV3640_PIDL, &pidl)) {
		dmw_camera_put_i2c(ov3640.cam_port);
		return -ENODEV;
	}

	dmw_camera_put_i2c(ov3640.cam_port);

	//printk(KERN_ERR "pidh=0x%x pidl=0x%x\n",pidh , pidl );
	if ((pidh == OV3640_PIDH_MAGIC) && ((pidl == OV3640_PIDL_MAGIC1) ||
	(pidl == OV3640_PIDL_MAGIC2))) {
		dev_dbg(&client->dev, "Detect success (%02X,%02X)\n", pidh, pidl);
		return pidl;
	}

	return -ENODEV;
}

/* To get the cropping capabilities of ov3640 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_cropcap(struct v4l2_int_device *s, struct v4l2_cropcap *cropcap)
{
	struct ov3640_sensor *sensor;

	if(!s || !cropcap) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;

	/*****************remove when sensor crop is set*************************/
	return -EINVAL;
	/*****************remove when sensor crop is set*************************/

	cropcap->bounds.top = 0;
	cropcap->bounds.left = 0;
	cropcap->bounds.width = sensor->width;
	cropcap->bounds.height = sensor->height;
	cropcap->defrect = cropcap->bounds;
	cropcap->pixelaspect.numerator = 1;
	cropcap->pixelaspect.denominator = 1;

	PDEBUG("cropcap->bounds.top = %d\n cropcap->bounds.left = %d\n cropcap->bounds.width = %d\n cropcap->bounds.height = %d\n"
		"cropcap->defrect.top = %d\n cropcap->defrect.left = %d\n cropcap->defrect.width = %d\n cropcap->defrect.height = %d \n "
		"cropcap->pixelaspect.numerator = %d\n cropcap->pixelaspect.denominator = %d\n",
		cropcap->bounds.top, cropcap->bounds.left, cropcap->bounds.width, cropcap->bounds.height, 
		cropcap->defrect.top, cropcap->defrect.left, cropcap->defrect.width, cropcap->defrect.height, 
		cropcap->pixelaspect.numerator,cropcap->pixelaspect.denominator);

	return 0;
}

/* To get the current crop window for of ov3640 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_g_crop(struct v4l2_int_device *s, struct  v4l2_crop *crop)
{
	struct ov3640_sensor *sensor;

	if(!s || !crop) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;

	crop->c = sensor->crop_rect;
	return 0;
}

/* To set the crop window for of ov3640 sensor
 * Returns zero if successful, or non-zero otherwise.
 */
static int ioctl_s_crop(struct v4l2_int_device *s, struct  v4l2_crop *crop)
{
	struct ov3640_sensor *sensor;
	/* FIXME: Temporary workaround for avoiding Zoom setting */
	struct v4l2_rect *cur_rect;
	unsigned long *cur_width, *cur_height;
	int hstart, vstart, hsize, vsize, hsize_l, vsize_l, hsize_h, vsize_h;
	int hratio, vratio, zoomfactor, err = 0;
	PDEBUG("%s\n",__func__);
	if(!s || !crop) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;
	/*****************remove when sensor crop is set*************************/
	return -EINVAL;
	/*****************remove when sensor crop is set*************************/

	cur_rect = &sensor->crop_rect;
	cur_width = &sensor->width;
	cur_height = &sensor->height;

	if ((crop->c.left == cur_rect->left) &&
	(crop->c.width == cur_rect->width) &&
	(crop->c.top == cur_rect->top) &&
	(crop->c.height == cur_rect->height))
		return 0;

	/* out of range? then return the current crop rectangle */
	if ((crop->c.left + crop->c.width) > sensor->width ||
	(crop->c.top + crop->c.height) > sensor->height) {
		crop->c = *cur_rect;
		return 0;
	}

	if (sensor->isize == QXGA)
		zoomfactor = 1;
	else
		zoomfactor = 2;

	hratio = (sensor->hsize * 1000) / sensor->width;
	vratio = (sensor->vsize * 1000) / sensor->height;
	hstart = (((crop->c.left * hratio + 500) / 1000) * zoomfactor) + 0x11d;
	vstart = (((crop->c.top * vratio + 500) / 1000) + 0x0a);
	hsize  = (crop->c.width * hratio + 500) / 1000;
	vsize  = (crop->c.height * vratio + 500) / 1000;

	if (vsize & 1)
		vsize--;
	if (hsize & 1)
		hsize--;

	/* Adjusting numbers to set register correctly */
	hsize_l = (0xFF & hsize);
	hsize_h = (0xF00 & hsize) >> 8;
	vsize_l = (0xFF & vsize);
	vsize_h = (0x700 & vsize) >> 8;

	if ((sensor->height > vsize) || (sensor->width > hsize))
		return -EINVAL;

	hsize = hsize * zoomfactor;
	/*
	err = ov3640_write_reg(client, OV3640_DSP_CTRL_2, 0xEF);
	err = ov3640_write_reg(client, OV3640_SIZE_IN_MISC, (vsize_h |
				                                       hsize_h));
	err = ov3640_write_reg(client, OV3640_HSIZE_IN_L, hsize_l);
	err = ov3640_write_reg(client, OV3640_VSIZE_IN_L, vsize_l);
	err = ov3640_write_reg(client, OV3640_HS_H, (hstart >> 8) & 0xFF);
	err = ov3640_write_reg(client, OV3640_HS_L, hstart & 0xFF);
	err = ov3640_write_reg(client, OV3640_VS_H, (vstart >> 8) & 0xFF);
	err = ov3640_write_reg(client, OV3640_VS_L, vstart & 0xFF);
	err = ov3640_write_reg(client, OV3640_HW_H, ((hsize) >> 8) & 0xFF);
	err = ov3640_write_reg(client, OV3640_HW_L, hsize & 0xFF);
	err = ov3640_write_reg(client, OV3640_VH_H, ((vsize) >> 8) & 0xFF);
	err = ov3640_write_reg(client, OV3640_VH_L, vsize & 0xFF);
	*/
	if (err)
		return err;

	/* save back */
	*cur_rect = crop->c;

	/* Setting crop too fast can cause frame out-of-sync. */

	set_current_state(TASK_UNINTERRUPTIBLE);
	schedule_timeout(msecs_to_jiffies(20));
	return 0;
}

/*
 * ioctl_queryctrl - V4L2 sensor interface handler for VIDIOC_QUERYCTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @qc: standard V4L2 VIDIOC_QUERYCTRL ioctl structure
 *
 * If the requested control is supported, returns the control information
 * from the video_control[] array.  Otherwise, returns -EINVAL if the
 * control is not supported.
 */
static int ioctl_queryctrl(struct v4l2_int_device *s,
							struct v4l2_queryctrl *qc)
{
	int i;

	if(!s || !qc) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	i = find_vctrl(qc->id);
	if (i == -EINVAL)
		qc->flags = V4L2_CTRL_FLAG_DISABLED;

	if (i < 0)
		return -EINVAL;

	*qc = video_control[i].qc;
	return 0;
}

/*
 * ioctl_g_ctrl - V4L2 sensor interface handler for VIDIOC_G_CTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @vc: standard V4L2 VIDIOC_G_CTRL ioctl structure
 *
 * If the requested control is supported, returns the control's current
 * value from the video_control[] array.  Otherwise, returns -EINVAL
 * if the control is not supported.
 */
static int ioctl_g_ctrl(struct v4l2_int_device *s,
						struct v4l2_control *vc)
{
	struct vcontrol *lvc;
	int i = 0;

	if(!s || !vc) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	i = find_vctrl(vc->id);
	if (i < 0)
		return -EINVAL;
	lvc = &video_control[i];

	switch (vc->id) {
		case V4L2_CID_BRIGHTNESS:
			vc->value = lvc->current_value;
			break;
		case V4L2_CID_CONTRAST:
			vc->value = lvc->current_value;
			break;
		case V4L2_CID_PRIVATE_BASE:
			vc->value = lvc->current_value;
			break;
		case V4L2_CID_VFLIP:
			vc->value = lvc->current_value;
			break;
		case V4L2_CID_HFLIP:
			vc->value = lvc->current_value;
			break;
	}
	return 0;
}

/*
 * ioctl_s_ctrl - V4L2 sensor interface handler for VIDIOC_S_CTRL ioctl
 * @s: pointer to standard V4L2 device structure
 * @vc: standard V4L2 VIDIOC_S_CTRL ioctl structure
 *
 * If the requested control is supported, sets the control's current
 * value in HW (and updates the video_control[] array).  Otherwise,
 * returns -EINVAL if the control is not supported.
 */
static int ioctl_s_ctrl(struct v4l2_int_device *s,
                            struct v4l2_control *vc)
{
	int retval = -EINVAL;
	int i = 0;
	struct ov3640_sensor *sensor;
	struct vcontrol *lvc;
	PDEBUG("%s\n",__func__);
	if(!s || !vc) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;

	i = find_vctrl(vc->id);
	if (i < 0)
		return -EINVAL;

	lvc = &video_control[i];

	switch (vc->id) {
		case V4L2_CID_BRIGHTNESS:
			if (vc->value >= 0 && vc->value <= 6) {
				retval = ov3640_write_regs(brightness[vc->value]);
			}
			else {
				PDEBUG("BRIGHTNESS LEVEL NOT SUPPORTED\n");
				return -EINVAL;
			}
			break;
		case V4L2_CID_CONTRAST:
			if (vc->value >= 0 && vc->value <= 6)
				retval = ov3640_write_regs(contrast[vc->value]);
			else {
				PDEBUG("CONTRAST LEVEL NOT SUPPORTED\n");
				return -EINVAL;
			}
			break;
		case V4L2_CID_PRIVATE_BASE:
			if (vc->value >= 0 && vc->value <= 2)
				retval = ov3640_write_regs(colors[vc->value]);
			else {
				PDEBUG("COLOR LEVEL NOT SUPPORTED\n");
				return -EINVAL;
			}
			break;
		case V4L2_CID_VFLIP:
			if (vc->value >= 0) {
				unsigned int val = 0;
				val = (vc->value > 0) ? 1 : 0;
				retval = ov3640_set_v_flip(val);
			}
			else {
				PDEBUG("VERTIVCAL FLIP INVALID VALUE\n");
				return -EINVAL;
			}
			break;
		case V4L2_CID_HFLIP:
			if (vc->value >= 0){
				unsigned int val = 0;
				val = (vc->value > 0) ? 1 : 0;
				retval = ov3640_set_h_flip(val);
			}
			else {
				PDEBUG("HORIZONTAL FLIP INVALID VALUE\n");
				return -EINVAL;
			}
			break;
	}

	if (!retval)
		lvc->current_value = vc->value;

	return retval;
}

/*
 * ioctl_enum_fmt_cap - Implement the CAPTURE buffer VIDIOC_ENUM_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @fmt: standard V4L2 VIDIOC_ENUM_FMT ioctl structure
 *
 * Implement the VIDIOC_ENUM_FMT ioctl for the CAPTURE buffer type.
 */
static int ioctl_enum_fmt_cap(struct v4l2_int_device *s,
								struct v4l2_fmtdesc *fmt)
{
	int index = 0;
	enum v4l2_buf_type type;

	if(!s || !fmt) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	index = fmt->index;
	type = fmt->type;

	memset(fmt, 0, sizeof(*fmt));
	fmt->index = index;
	fmt->type = type;

	switch (fmt->type) {
		case V4L2_BUF_TYPE_VIDEO_CAPTURE:
			if (index >= NUM_CAPTURE_FORMATS)
				return -EINVAL;
			break;
		default:
			return -EINVAL;
	}

	fmt->flags = ov3640_formats[index].flags;
	strlcpy(fmt->description, ov3640_formats[index].description,
			sizeof(fmt->description));
	fmt->pixelformat = ov3640_formats[index].pixelformat;

	return 0;
}

/*
 * ioctl_try_fmt_cap - Implement the CAPTURE buffer VIDIOC_TRY_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 VIDIOC_TRY_FMT ioctl structure
 *
 * Implement the VIDIOC_TRY_FMT ioctl for the CAPTURE buffer type.  This
 * ioctl is used to negotiate the image capture size and pixel format
 * without actually making it take effect.
 */
static int ioctl_try_fmt_cap(struct v4l2_int_device *s,
								struct v4l2_format *f)
{
	int ifmt = 0;
	struct v4l2_pix_format *pix;

	if(!s || !f) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	pix = &f->fmt.pix;

	if (pix->width > ov3640_sizes[QXGA].width)
		pix->width = ov3640_sizes[QXGA].width;
	if (pix->height > ov3640_sizes[QXGA].height)
		pix->height = ov3640_sizes[QXGA].height;
       
	for (ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++) {
		if (pix->pixelformat == ov3640_formats[ifmt].pixelformat)
			break;
	}

	if (ifmt == NUM_CAPTURE_FORMATS)
		ifmt = 0;

	pix->pixelformat = ov3640_formats[ifmt].pixelformat;
	pix->field = V4L2_FIELD_NONE;
	pix->bytesperline = bytes_per_line(pix->width, pix->pixelformat ); 
	pix->sizeimage = image_size(pix->width, pix->height, pix->pixelformat);
	pix->priv = 0;

	switch (pix->pixelformat) {
		case V4L2_PIX_FMT_NV16:
		case V4L2_PIX_FMT_NV61:
		case V4L2_PIX_FMT_NV12:
		case V4L2_PIX_FMT_NV21:
		case V4L2_PIX_FMT_YUYV:
		case V4L2_PIX_FMT_UYVY:
		default:
			pix->colorspace = V4L2_COLORSPACE_JPEG;
			break;
		case V4L2_PIX_FMT_SGRBG10:
		case V4L2_PIX_FMT_RGB565:
		case V4L2_PIX_FMT_RGB565X:
		case V4L2_PIX_FMT_RGB555:
		case V4L2_PIX_FMT_RGB555X:
			pix->colorspace = V4L2_COLORSPACE_SRGB;
			break;
	}

	return 0;
}


/*
 * ioctl_s_fmt_cap - V4L2 sensor interface handler for VIDIOC_S_FMT ioctl
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 VIDIOC_S_FMT ioctl structure
 *
 * If the requested format is supported, configures the HW to use that
 * format, returns error code if format not supported or HW can't be
 * correctly configured.
 */
static int ioctl_s_fmt_cap(struct v4l2_int_device *s,
							struct v4l2_format *f)
{
	struct ov3640_sensor *sensor;
	struct v4l2_pix_format *pix;
	int rval = 0;

	if(!s || !f) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;
	pix = &f->fmt.pix;

	rval = ioctl_try_fmt_cap(s, f);
	if (rval)
		return rval;

	sensor->pix = *pix;

	return 0;
}

/*
 * ioctl_g_fmt_cap - V4L2 sensor interface handler for ioctl_g_fmt_cap
 * @s: pointer to standard V4L2 device structure
 * @f: pointer to standard V4L2 v4l2_format structure
 *
 * Returns the sensor's current pixel format in the v4l2_format
 * parameter.
 */
static int ioctl_g_fmt_cap(struct v4l2_int_device *s,
							struct v4l2_format *f)
{
	struct ov3640_sensor *sensor;

	if(!s || !f) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;
	f->fmt.pix = sensor->pix;

	return 0;
}

/*
 * ioctl_g_parm - V4L2 sensor interface handler for VIDIOC_G_PARM ioctl
 * @s: pointer to standard V4L2 device structure
 * @a: pointer to standard V4L2 VIDIOC_G_PARM ioctl structure
 *
 * Returns the sensor's video CAPTURE parameters.
 */
static int ioctl_g_parm(struct v4l2_int_device *s,
						struct v4l2_streamparm *a)
{
	struct ov3640_sensor *sensor;
	struct v4l2_captureparm *cparm;

	if(!s || !a) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;
	cparm = &a->parm.capture;

	if (a->type != V4L2_BUF_TYPE_VIDEO_CAPTURE)
		return -EINVAL;

	memset(a, 0, sizeof(*a));
	a->type = V4L2_BUF_TYPE_VIDEO_CAPTURE;

	cparm->capability = V4L2_CAP_TIMEPERFRAME;
	cparm->timeperframe = sensor->timeperframe;

	return 0;
}

/*
 * ioctl_s_parm - V4L2 sensor interface handler for VIDIOC_S_PARM ioctl
 * @s: pointer to standard V4L2 device structure
 * @a: pointer to standard V4L2 VIDIOC_S_PARM ioctl structure
 *
 * Configures the sensor to use the input parameters, if possible.  If
 * not possible, reverts to the old parameters and returns the
 * appropriate error code.
 */
static int ioctl_s_parm(struct v4l2_int_device *s,
						struct v4l2_streamparm *a)
{
	int rval = 0;
	struct ov3640_sensor *sensor;
	struct v4l2_fract *timeperframe;
	struct v4l2_fract timeperframe_old;
	int desired_fps = 0;
	enum ov3640_frameintervals_type fps= 0;

	PDEBUG("%s\n",__func__);

	if(!s || !a) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	sensor = s->priv;

	timeperframe = &a->parm.capture.timeperframe;
	timeperframe_old = sensor->timeperframe;
	sensor->timeperframe = *timeperframe;

	desired_fps = timeperframe->denominator / timeperframe->numerator;
	PDEBUG("desired_fps = %d denominator=%d numerator=%d \n",desired_fps , timeperframe->denominator , timeperframe->numerator );
#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
	if ((desired_fps < OV3640_MIN_FPS) || (desired_fps > OV3640_MAX_FPS))
#else
	if ((desired_fps < OV3640_DEF_FPS) || (desired_fps > OV3640_MAX_FPS))     
#endif
		return (-EINVAL);

	rval = switch_fps(timeperframe, &fps);

	if (rval)
		sensor->timeperframe = timeperframe_old;
	else
		*timeperframe = sensor->timeperframe;

	return rval;
}

/*
 * ioctl_g_priv - V4L2 sensor interface handler for vidioc_int_g_priv_num
 * @s: pointer to standard V4L2 device structure
 * @p: void pointer to hold sensor's private data address
 *
 * Returns device's (sensor's) private data area address in p parameter
 * We need the configure since we close the clk when going to Standby mode.
 */
static int ioctl_g_priv(struct v4l2_int_device *s, void *p)
{
	struct ov3640_sensor *sensor;

	if(!s || !p) {
		PDEBUG("Invalid input\n");
		return -1;
	}
	sensor = s->priv;

	/* copy data */
	memcpy( p,
			&(sensor->cam_port->hw_config),
			sizeof( struct dmw96cam_hw_config));

	return 0;
}

/*
 * reset_ov3640_to_default  
 * @s: pointer to standard V4L2 device structure
 * Sets reset the device to default
 */
static void reset_ov3640_to_default(struct v4l2_int_device *s)
{
	struct i2c_client * client;

	client = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!client) {
		return;
	}

	/* Reset */
	ov3640_write_reg(client, OV3640_SYS, 0x80);
	mdelay(10);
	ov3640_write_regs (ov3640_common[0]);
	PDEBUG("SENSOR RESET\n");

	dmw_camera_put_i2c(ov3640.cam_port);
}

/*
 * ioctl_s_power - V4L2 sensor interface handler for vidioc_int_s_power_num
 * @s: pointer to standard V4L2 device structure
 * @on: power state to which device is to be set
 *
 * Sets devices power state to requrested state, if possible.
 */
static int ioctl_s_power(struct v4l2_int_device *s, enum v4l2_power on)
{
	struct ov3640_sensor *sensor = s->priv;
	static enum v4l2_power prev_on = V4L2_POWER_OFF;

	int rval = 0;

	if (on == V4L2_POWER_ON)
		PDEBUG("ov3640 = ON prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );
	else if (on == V4L2_POWER_OFF)
		PDEBUG("ov3640 = OFF prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );
	else if (on == V4L2_POWER_STANDBY)
		PDEBUG("ov3640 = STANDBY prev = %s \n", (prev_on == 0) ? "OFF" : (prev_on == 1) ? "ON" : "STANDBY" );

	if ((prev_on == V4L2_POWER_ON) && (on == V4L2_POWER_STANDBY))
		ov3640_write_regs(ov3640_standby_on);
	   
	rval = dmw_camera_port_power_ctl(sensor->cam_port, on);

	if (rval < 0) {
		PDEBUG( "Unable to set the power state: "
		OV3640_DRIVER_NAME " sensor\n");
		return rval;
	}

	if ((prev_on == V4L2_POWER_STANDBY) && (on == V4L2_POWER_ON))
		ov3640_write_regs(ov3640_standby_off);

	if (on == V4L2_POWER_ON)
		dmw_camera_port_clock_ctl(sensor->cam_port, xclk_current);
	   
	if ( (prev_on == V4L2_POWER_OFF && on == V4L2_POWER_ON)  && (sensor->state == SENSOR_DETECTED) )
		reset_ov3640_to_default(s);

	if ( (prev_on == V4L2_POWER_STANDBY || prev_on == V4L2_POWER_ON) && (on == V4L2_POWER_ON) && (sensor->state == SENSOR_DETECTED))
		ov3640_configure(s);
            
	if ((on == V4L2_POWER_ON) && (sensor->state == SENSOR_NOT_DETECTED)) {
		rval = ov3640_detect();
		if (rval < 0) {
			PDEBUG( "Unable to detect " OV3640_DRIVER_NAME " sensor (or sensor is not connected)\n");
			sensor->state = SENSOR_NOT_DETECTED;

			/* turn port off */
			dmw_camera_port_power_ctl(sensor->cam_port, V4L2_POWER_OFF);

			return rval;
		}

		/* associate with port */
		dmw_camera_associate_sensor_with_port(	ov3640.cam_port,
												&ov3640_sensor_desc);

		sensor->state = SENSOR_DETECTED;
		sensor->ver = rval;
		pr_info(OV3640_DRIVER_NAME " Chip version 0x%02x detected\n", sensor->ver);
		reset_ov3640_to_default(s);
	}

	prev_on = on;

	return 0;
}

/*
 * ioctl_init - V4L2 sensor interface handler for VIDIOC_INT_INIT
 * @s: pointer to standard V4L2 device structure
 *
 * Initialize the sensor device (call ov3640_configure())
 */
static int ioctl_init(struct v4l2_int_device *s)
{
	return 0;
}

/**
 * ioctl_dev_exit - V4L2 sensor interface handler for vidioc_int_dev_exit_num
 * @s: pointer to standard V4L2 device structure
 *
 * Delinitialise the dev. at slave detach.  The complement of ioctl_dev_init.
 */
static int ioctl_dev_exit(struct v4l2_int_device *s)
{
	return 0;
}

/**
 * ioctl_dev_init - V4L2 sensor interface handler for vidioc_int_dev_init_num
 * @s: pointer to standard V4L2 device structure
 *
 * Initialise the device when slave attaches to the master.  Returns 0 if
 * ov3640 device could be found, otherwise returns appropriate error.
 */
static int ioctl_dev_init(struct v4l2_int_device *s)
{
	return 0;
}

/**
 * ioctl_enum_framesizes - V4L2 sensor if handler for vidioc_int_enum_framesizes
 * @s: pointer to standard V4L2 device structure
 * @frms: pointer to standard V4L2 framesizes enumeration structure
 *
 * Returns possible framesizes depending on choosen pixel format
 **/
static int ioctl_enum_framesizes(struct v4l2_int_device *s,
                                       struct v4l2_frmsizeenum *frms)
{
	int ifmt = 0;
	if(!s || !frms) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	for (ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++) {
		if (frms->pixel_format == ov3640_formats[ifmt].pixelformat)
			break;
	}

	/* Is requested pixelformat not found on sensor? */
	if (ifmt == NUM_CAPTURE_FORMATS) {
		PDEBUG("sensor is not supporting the format\n");
		return -EINVAL;
	}

#ifdef CONFIG_SENSOR_FPS_MULTI_SUPPORT
	/*According to V4L2 API, when supporting STEPWISE then there is need to return EINVAL when index != 0*/
	if (frms->index != 0) {
		PDEBUG("invalid index for setpewise sensor support\n");
		return -EINVAL;
	}

	frms->type = V4L2_FRMSIZE_TYPE_STEPWISE;
	/*ToDO please define the belong settings*/
	frms->stepwise.min_width = 32;	/* Minimum frame width [pixel] */
	frms->stepwise.max_width = 2048;	/* Maximum frame width [pixel] */
	frms->stepwise.step_width = 8;	/* Frame width step size [pixel] */
	frms->stepwise.min_height = 32;	/* Minimum frame height [pixel] */
	frms->stepwise.max_height = 1536;	/* Maximum frame height [pixel] */
	frms->stepwise.step_height = 8;	/* Frame height step size [pixel] */
#else
	// this is a code example how to do enum the frame size in discrete.
	// Do we already reached all discrete framesizes? 
	if (frms->index >= NUM_DISCRETE_SIZES)
		return -EINVAL;

	frms->type = V4L2_FRMSIZE_TYPE_DISCRETE;
	frms->discrete.width = ov3640_sizes[frms->index].width;
	frms->discrete.height = ov3640_sizes[frms->index].height;
#endif

	return 0;
}

static int ioctl_enum_frameintervals(struct v4l2_int_device *s,
										struct v4l2_frmivalenum *frmi)
{
	int ifmt = 0;

	if(!s || !frmi) {
		PDEBUG("Invalid input\n");
		return -1;
	}

	for (ifmt = 0; ifmt < NUM_CAPTURE_FORMATS; ifmt++) {
		if (frmi->pixel_format == ov3640_formats[ifmt].pixelformat)
			break;
	}

	/* Is requested pixelformat not found on sensor? */
	if (ifmt == NUM_CAPTURE_FORMATS)
		return -EINVAL;

	if (frmi->width > ov3640_sizes[QXGA].width || frmi->height > ov3640_sizes[QXGA].height)
		return -EINVAL;

	if (frmi->width > ov3640_sizes[XGA].width || frmi->height > ov3640_sizes[XGA].height) {
		if (frmi->index > OV34_15_FPS)
			return -EINVAL;
	} 
	else {
		if (frmi->index >= NUM_TIMEFRAME_VALS)
			return -EINVAL;
	}

	frmi->type = V4L2_FRMIVAL_TYPE_DISCRETE;
	frmi->discrete.numerator = ov3640_frameintervals[frmi->index].numerator;
	frmi->discrete.denominator = ov3640_frameintervals[frmi->index].denominator;

	return 0;
}


static int ioctl_s_reg(struct v4l2_int_device *s, const struct v4l2_dbg_register* reg)
{
	struct ov3640_sensor *sensor;
	struct i2c_client *c;
	int ret;

	if(!s || !reg || !s->priv)
		return -1;

	sensor = s->priv;
	c = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!c) {
		return -EIO;
	}

	PDEBUG("reg=%llx val=%llx\n", reg->reg , reg->val);

	ret = ov3640_write_reg(c,reg->reg,reg->val);

	dmw_camera_put_i2c(ov3640.cam_port);

	return ret;
}

static int ioctl_g_reg(struct v4l2_int_device *s, struct v4l2_dbg_register* reg)
{
	struct ov3640_sensor *sensor;
	struct i2c_client *c;
	int ret;

	if(!s || !reg || !s->priv)
		return -1;

	sensor = s->priv;

	c = dmw_camera_get_i2c(ov3640.cam_port, &ov3640_sensor_desc);

	if (!c)	{
		return -EIO;
	}

	PDEBUG("reg=%llx val=%llx\n", reg->reg , reg->val);

	ret = ov3640_read_reg(c,1,reg->reg,(unsigned int*) &(reg->val));

	dmw_camera_put_i2c(ov3640.cam_port);

	return ret;
}

static struct v4l2_int_ioctl_desc ov3640_ioctl_desc[] = {
	{vidioc_int_enum_framesizes_num,
		(v4l2_int_ioctl_func *)ioctl_enum_framesizes},
	{vidioc_int_enum_frameintervals_num,
		(v4l2_int_ioctl_func *)ioctl_enum_frameintervals},
	{vidioc_int_dev_init_num,
		(v4l2_int_ioctl_func *)ioctl_dev_init},
	{vidioc_int_dev_exit_num,
		(v4l2_int_ioctl_func *)ioctl_dev_exit},
	{vidioc_int_s_power_num,
		(v4l2_int_ioctl_func *)ioctl_s_power},
	{vidioc_int_g_priv_num,
		(v4l2_int_ioctl_func *)ioctl_g_priv},
	{vidioc_int_init_num,
		(v4l2_int_ioctl_func *)ioctl_init},
	{vidioc_int_enum_fmt_cap_num,
		(v4l2_int_ioctl_func *)ioctl_enum_fmt_cap},
	{vidioc_int_try_fmt_cap_num,
		(v4l2_int_ioctl_func *)ioctl_try_fmt_cap},
	{vidioc_int_g_fmt_cap_num,
		(v4l2_int_ioctl_func *)ioctl_g_fmt_cap},
	{vidioc_int_s_fmt_cap_num,
		(v4l2_int_ioctl_func *)ioctl_s_fmt_cap},
	{vidioc_int_g_parm_num,
		(v4l2_int_ioctl_func *)ioctl_g_parm},
	{vidioc_int_s_parm_num,
		(v4l2_int_ioctl_func *)ioctl_s_parm},
	{vidioc_int_queryctrl_num,
		(v4l2_int_ioctl_func *)ioctl_queryctrl},
	{vidioc_int_g_ctrl_num,
		(v4l2_int_ioctl_func *)ioctl_g_ctrl},
	{vidioc_int_s_ctrl_num,
		(v4l2_int_ioctl_func *)ioctl_s_ctrl},
	{ vidioc_int_g_crop_num,
		(v4l2_int_ioctl_func *)ioctl_g_crop},
	{vidioc_int_s_crop_num,
		(v4l2_int_ioctl_func *)ioctl_s_crop},
	{vidioc_int_cropcap_num,
		(v4l2_int_ioctl_func *)ioctl_cropcap},
	{vidioc_int_s_reg_num,
		(v4l2_int_ioctl_func *)ioctl_s_reg},
	{vidioc_int_g_reg_num,
		(v4l2_int_ioctl_func *)ioctl_g_reg},
};

static struct v4l2_int_slave ov3640_slave = {
	.ioctls         = ov3640_ioctl_desc,
	.num_ioctls     = ARRAY_SIZE(ov3640_ioctl_desc),
};

static struct v4l2_int_device ov3640_int_device = {
	.module = THIS_MODULE,
	.name   = OV3640_DRIVER_NAME,
	.priv   = &ov3640,
	.type   = v4l2_int_type_slave,
	.u      = {
		.slave = &ov3640_slave,
	},
};


static int ov3640_probe(	dmw_camera_sensor_desc_t * sensor_desc,
							dmw_camera_port_t * 		cam_port )
{
	struct ov3640_sensor *sensor = &ov3640;
	int err = 0;

	sensor->cam_port = cam_port;
	sensor->v4l2_int_device = &ov3640_int_device;

	/* Make the default capture format QXGA 4:2:0 Semi Planar */
	sensor->pix.width = ov3640_sizes[QVGA].width;
	sensor->pix.height = ov3640_sizes[QVGA].height;
	sensor->pix.pixelformat = V4L2_PIX_FMT_NV12;

	sensor->crop_rect.height = ov3640_sizes[QVGA].height;
	sensor->crop_rect.width = ov3640_sizes[QVGA].width;
	sensor->crop_rect.left = 0;
	sensor->crop_rect.top = 0;

	sensor->timeperframe.denominator = 15;
	sensor->timeperframe.numerator = 1;
	sensor->vflip = 0;
	sensor->hflip = 0;

	err = v4l2_int_device_register(sensor->v4l2_int_device);
	if (err){
		return -1;
	}

	PDEBUG("\n\n\n P r o b i n g	OV3640	s e n s o r	 s u c c e s s   ! ! !\n\n\n");
	return 0;
}

/* sensor descriptor */
static dmw_camera_sensor_desc_t ov3640_sensor_desc =
{
 	 .name 	   = OV3640_DRIVER_NAME,
 	 .probe    = ov3640_probe,
 	 .i2c_addr = OV3640_I2C_ADDR,
 	 .mode	   = DMW_CAMERA_SENSOR_MODE_PARALLEL,
};

/* default platform data, when no pdata is given by the board */
static dmw_camera_sensor_platform_data_t ov3640_default_platform_data =
{
 	 .__sensor_desc = &ov3640_sensor_desc,
};

static int __devinit ov3640_pdev_probe(struct platform_device *pdev)
{
	platform_set_drvdata(pdev, &ov3640_default_platform_data);

	return 0;
}

static int __devexit ov3640_pdev_remove(struct platform_device *pdev)
{
	return 0;
}

static struct platform_driver ov3640_driver = {
	.driver = {
		.name  = OV3640_DRIVER_NAME,
		.owner = THIS_MODULE,
	},
	.probe = ov3640_pdev_probe,
	.remove = __devexit_p(ov3640_pdev_remove),
};

static int __init ov3640_init(void)
{
	return platform_driver_register(&ov3640_driver);
}

static void __exit ov3640_exit(void)
{
	platform_driver_unregister(&ov3640_driver);
}

subsys_initcall(ov3640_init);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("OV3640 camera sensor driver");

