/*
 *  Copyright (C) 2011 DSPG Technologies GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LINUX_USB_DWC_OTG_H
#define __LINUX_USB_DWC_OTG_H

/**
 * struct dwc_otg_platform_data - DWC OTG HS controller configuration data
 *
 * @drvvbus_gpio: GPIO which enables external charge-pump to drive VBus
 * @overcurrent_gpio: Input which is asserted when an overcurrent was detected
 * @vbusdetect_gpio: Input sensing VBUS (EXTINT capable)
 */
struct dwc_otg_platform_data {
	void (*set_vbus_power)(int enable);
	int drvvbus_gpio;
	int overcurrent_gpio;
	int vbusdetect_gpio;
	void (*busy)(void);
	void (*idle)(void);

	char *psy_name;
	char **psy_supplied_to;
	int psy_num_supplicants;
};

#endif
