/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.connection.AbstractPost12ConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ActionRunner;
import org.gradle.tooling.internal.consumer.connection.BuildInvocationsAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.InternalBuildActionAdapter;
import org.gradle.tooling.internal.consumer.connection.ModelBuilderBackedModelProducer;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalBuildActionExecutor;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.ModelBuilder;
import org.gradle.tooling.model.gradle.BuildInvocations;

public class ActionAwareConsumerConnection
extends AbstractPost12ConsumerConnection {
    private final ActionRunner actionRunner;
    private final ModelProducer modelProducer;

    public ActionAwareConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, VersionDetails.from(delegate.getMetaData().getVersion()));
        ModelProducer modelProducer = new ModelBuilderBackedModelProducer(adapter, this.getVersionDetails(), modelMapping, (ModelBuilder)((Object)delegate));
        if (!this.getVersionDetails().maySupportModel(BuildInvocations.class)) {
            modelProducer = new BuildInvocationsAdapterProducer(adapter, this.getVersionDetails(), modelProducer);
        }
        this.modelProducer = modelProducer;
        this.actionRunner = new InternalBuildActionExecutorBackedActionRunner((InternalBuildActionExecutor)((Object)delegate), this.getVersionDetails());
    }

    @Override
    protected ModelProducer getModelProducer() {
        return this.modelProducer;
    }

    @Override
    protected ActionRunner getActionRunner() {
        return this.actionRunner;
    }

    private static class InternalBuildActionExecutorBackedActionRunner
    implements ActionRunner {
        private final InternalBuildActionExecutor executor;
        private final VersionDetails versionDetails;

        private InternalBuildActionExecutorBackedActionRunner(InternalBuildActionExecutor executor, VersionDetails versionDetails) {
            this.executor = executor;
            this.versionDetails = versionDetails;
        }

        @Override
        public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
            BuildResult<T> result;
            File rootDir = operationParameters.getProjectDir();
            try {
                result = this.executor.run(new InternalBuildActionAdapter<T>(action, rootDir, this.versionDetails), operationParameters);
            }
            catch (InternalBuildActionFailureException e) {
                throw new BuildActionFailureException("The supplied build action failed with an exception.", e.getCause());
            }
            return result.getModel();
        }
    }
}

