/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.MetaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.KeyedExtensionCollector;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.gnu.trove.THashSet;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create("EXTENSIONS_IN_LANGUAGE_" + epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(0);
        }
        String string = key.getID();
        if (string == null) {
            LanguageExtension.$$$reportNull$$$0(1);
        }
        return string;
    }

    public T forLanguage(@NotNull Language l) {
        T cached;
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(2);
        }
        if ((cached = l.getUserData(this.IN_LANGUAGE_CACHE)) != null) {
            return cached;
        }
        T result2 = this.findForLanguage(l);
        if (result2 == null) {
            return null;
        }
        result2 = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result2);
        return result2;
    }

    protected T findForLanguage(@NotNull Language l) {
        List extensions;
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(3);
        }
        if (!(extensions = this.forKey(l)).isEmpty()) {
            return extensions.get(0);
        }
        Language base = l.getBaseLanguage();
        if (base != null) {
            return this.forLanguage(base);
        }
        Optional<Object> forAnyMetaLanguage = MetaLanguage.getAllMatchingMetaLanguages(l).map(metaLanguage -> this.forLanguage((Language)metaLanguage)).filter(Objects::nonNull).findAny();
        return (T)forAnyMetaLanguage.orElse(this.myDefaultImplementation);
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(4);
        }
        boolean copyList = true;
        List result2 = null;
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List list2 = this.forKey(l);
            if (result2 == null) {
                result2 = list2;
                continue;
            }
            if (list2.isEmpty()) continue;
            if (copyList) {
                result2 = ContainerUtil.newArrayList(ContainerUtil.concat(result2, list2));
                copyList = false;
                continue;
            }
            result2.addAll(list2);
        }
        List list3 = result2;
        if (list3 == null) {
            LanguageExtension.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(6);
        }
        ArrayList<T> providers = new ArrayList<T>(this.allForLanguage(l));
        if (l != Language.ANY) {
            providers.addAll(this.allForLanguage(Language.ANY));
        }
        MetaLanguage.getAllMatchingMetaLanguages(l).forEach(metaLanguage -> providers.addAll(this.allForLanguage((Language)metaLanguage)));
        ArrayList<T> arrayList = providers;
        if (arrayList == null) {
            LanguageExtension.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    @NotNull
    protected Key<T> getLanguageCache() {
        Key<T> key = this.IN_LANGUAGE_CACHE;
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(8);
        }
        return key;
    }

    @NotNull
    protected Set<String> getAllBaseLanguageIdsWithAny(@NotNull Language key) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(9);
        }
        THashSet<String> allowed = new THashSet<String>();
        while (key != null) {
            allowed.add(this.keyToString(key));
            key = key.getBaseLanguage();
        }
        allowed.add("any");
        for (MetaLanguage metaLanguage : MetaLanguage.all()) {
            allowed.add(metaLanguage.getID());
        }
        THashSet<String> tHashSet = allowed;
        if (tHashSet == null) {
            LanguageExtension.$$$reportNull$$$0(10);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/LanguageExtension";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/LanguageExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguageOrAny";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageCache";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBaseLanguageIdsWithAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findForLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguageOrAny";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllBaseLanguageIdsWithAny";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

