/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.JDOMUtil;
import org.jetbrains.kotlin.org.jdom.Document;
import org.jetbrains.kotlin.org.jdom.Element;

public class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        return prefix != null ? prefix + "ApplicationInfo" : "ApplicationInfo";
    }

    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfoHolder.ourInstance;
        if (applicationNamesInfo == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(0);
        }
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo() {
        String resource = "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
        try {
            Document doc = JDOMUtil.loadDocument(ApplicationNamesInfo.class, resource);
            Element rootElement = doc.getRootElement();
            Element names2 = rootElement.getChild("names", rootElement.getNamespace());
            this.myProductName = names2.getAttributeValue("product");
            this.myFullProductName = names2.getAttributeValue("fullname", this.myProductName);
            this.myEditionName = names2.getAttributeValue("edition");
            this.myScriptName = names2.getAttributeValue("script");
            this.myDefaultLauncherName = names2.getAttributeValue("default-launcher-name", this.myScriptName);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    public String getProductName() {
        return this.myProductName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/application/ApplicationNamesInfo", "getInstance"));
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();
    }
}

