/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.PotentialConflict;

class PotentialConflictFactory {
    private static final PotentialConflict NO_CONFLICT = new NoConflict();

    PotentialConflictFactory() {
    }

    static PotentialConflict potentialConflict(ConflictContainer.Conflict conflict) {
        if (conflict == null) {
            return NO_CONFLICT;
        }
        return new HasConflict(conflict.participants);
    }

    static PotentialConflict noConflict() {
        return NO_CONFLICT;
    }

    private static class NoConflict
    implements PotentialConflict {
        private NoConflict() {
        }

        @Override
        public void withParticipatingModules(Action<ModuleIdentifier> action) {
        }

        @Override
        public boolean conflictExists() {
            return false;
        }
    }

    private static class HasConflict
    implements PotentialConflict {
        private final Set<ModuleIdentifier> participants;

        private HasConflict(Set<ModuleIdentifier> participants) {
            this.participants = participants;
        }

        @Override
        public void withParticipatingModules(Action<ModuleIdentifier> action) {
            for (ModuleIdentifier participant : this.participants) {
                action.execute((Object)participant);
            }
        }

        @Override
        public boolean conflictExists() {
            return true;
        }
    }
}

