/*
 * This source file is part of Daimonin (http://daimonin.sourceforge.net)
 * Copyright (c) 2007 The Daimonin Team
 * Also see acknowledgements in Readme.html
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * In addition, as a special exception, the copyright holders of client3d give
 * you permission to combine the client3d program with lgpl libraries of your
 * choice and/or with the fmod libraries.
 * You may copy and distribute such a system following the terms of the GNU GPL
 * for client3d and the licenses of the other code concerned.
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA, or go to
 * http://www.gnu.org/licenses/licenses.html
 */
package net.daimonin.client3d.editor.util;

import java.io.File;
import java.io.FilenameFilter;

/**
 * Implementation of FilenameFilter for PNG files.
 * 
 * @author Rumbuff
 */
public class FilenameFilterPNG implements FilenameFilter {

	/**
	 * Filters by filename.
	 * @param dir		dir of the file.
	 * @param name	filename.
	 * @return @see java.io.FilenameFilter#accept(java.io.File, java.lang.String)
	 */
	public final boolean accept(final File dir, final String name) {
		return name.toLowerCase().endsWith(".png") ? true : false;
	}	
}
