/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FilePathToURI;
import org.dita.dost.util.FileUtils;

public final class URLUtils {
    static final Pattern EXTENSION_PATTERN;
    private static final boolean[] gNeedEscaping;
    private static final char[] gAfterEscaping1;
    private static final char[] gAfterEscaping2;
    private static final char[] gHexChs;

    private URLUtils() {
    }

    public static URL correct(File file) throws MalformedURLException {
        if (file == null) {
            throw new MalformedURLException("The url is null");
        }
        return new URL(URLUtils.correct(file.toURI().toString(), true));
    }

    public static URL correct(URL url) throws MalformedURLException {
        if (url == null) {
            throw new MalformedURLException("The url is null");
        }
        return new URL(URLUtils.correct(url.toString(), false));
    }

    public static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String uncorrect(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder sbuf = new StringBuilder();
        int l = s.length();
        int b = 0;
        int sumb = 0;
        boolean applyUTF8dec = false;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            int current;
            int ch = current = s.charAt(i);
            switch (ch) {
                case 37: {
                    if (i + 2 >= s.length()) break;
                    int hb = (Character.isDigit((char)(ch = s.charAt(++i))) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    applyUTF8dec = true;
                    break;
                }
                default: {
                    b = ch;
                    applyUTF8dec = false;
                }
            }
            if (applyUTF8dec) {
                if ((b & 0xC0) == 128) {
                    sumb = sumb << 6 | b & 0x3F;
                    if (--more != 0) continue;
                    sbuf.append((char)sumb);
                    continue;
                }
                if ((b & 0x80) == 0) {
                    sbuf.append((char)b);
                    continue;
                }
                if ((b & 0xE0) == 192) {
                    sumb = b & 0x1F;
                    more = 1;
                    continue;
                }
                if ((b & 0xF0) == 224) {
                    sumb = b & 0xF;
                    more = 2;
                    continue;
                }
                if ((b & 0xF8) == 240) {
                    sumb = b & 7;
                    more = 3;
                    continue;
                }
                if ((b & 0xFC) == 248) {
                    sumb = b & 3;
                    more = 4;
                    continue;
                }
                sumb = b & '\u0001';
                more = 5;
                continue;
            }
            sbuf.append((char)current);
            more = -1;
        }
        return sbuf.toString();
    }

    public static File getCanonicalFileFromFileUrl(URL url) {
        File file = null;
        if (url == null) {
            throw new NullPointerException("The URL cannot be null.");
        }
        if ("file".equals(url.getProtocol())) {
            String fileName = url.getFile();
            String path = URLUtils.uncorrect(fileName);
            file = new File(path);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = file.getAbsoluteFile();
            }
        }
        return file;
    }

    private static String correct(String url, boolean forceCorrection) {
        int queryIndex;
        int refIndex;
        if (url == null) {
            return null;
        }
        String initialUrl = url;
        if (!forceCorrection && url.contains("%")) {
            return initialUrl;
        }
        String reference = null;
        if (!forceCorrection && (refIndex = url.lastIndexOf(35)) != -1) {
            reference = FilePathToURI.filepath2URI(url.substring(refIndex + 1));
            url = url.substring(0, refIndex);
        }
        StringBuilder queryBuffer = null;
        if (!forceCorrection && (queryIndex = url.indexOf(63)) != -1) {
            String query = url.substring(queryIndex + 1);
            url = url.substring(0, queryIndex);
            queryBuffer = new StringBuilder(query.length());
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                token = FilePathToURI.filepath2URI(token);
                queryBuffer.append(token);
                if (!st.hasMoreElements()) continue;
                queryBuffer.append("&");
            }
        }
        Object toReturn = FilePathToURI.filepath2URI(url);
        if (queryBuffer != null) {
            toReturn = (String)toReturn + "?" + queryBuffer.toString();
        }
        if (reference != null) {
            toReturn = (String)toReturn + "#" + reference;
        }
        return toReturn;
    }

    public static String getURL(String fileName) {
        if (fileName.startsWith("file:/")) {
            return fileName;
        }
        File file = new File(fileName);
        return file.toURI().toString();
    }

    public static String clean(String path) {
        return URLUtils.clean(path.replace("\\", "/"), true);
    }

    public static String clean(String path, boolean ascii) {
        int i;
        int ch;
        int len = path.length();
        StringBuilder buffer = new StringBuilder(len * 3);
        if (len >= 2 && path.charAt(1) == ':' && (ch = Character.toUpperCase(path.charAt(0))) >= 65 && ch <= 90) {
            buffer.append('/');
        }
        for (i = 0; i < len; ++i) {
            ch = path.charAt(i);
            if (ch == 37 && !URLUtils.isPercentEncoded(path.subSequence(i, i + 2 < len ? i + 3 : len))) {
                buffer.append('%').append('2').append('5');
                continue;
            }
            if (ch >= 128 && ascii) break;
            if (ch < gNeedEscaping.length && gNeedEscaping[ch]) {
                buffer.append('%');
                buffer.append(gAfterEscaping1[ch]);
                buffer.append(gAfterEscaping2[ch]);
                continue;
            }
            buffer.append((char)ch);
        }
        if (i < len && ascii) {
            for (byte b : path.substring(i).getBytes(StandardCharsets.UTF_8)) {
                if (b < 0) {
                    ch = b + 256;
                    buffer.append('%');
                    buffer.append(gHexChs[ch >> 4]);
                    buffer.append(gHexChs[ch & 0xF]);
                    continue;
                }
                if (gNeedEscaping[b]) {
                    buffer.append('%');
                    buffer.append(gAfterEscaping1[b]);
                    buffer.append(gAfterEscaping2[b]);
                    continue;
                }
                buffer.append((char)b);
            }
        }
        return buffer.toString();
    }

    private static boolean isPercentEncoded(CharSequence seq) {
        if (seq.length() < 3) {
            return false;
        }
        char c1 = seq.charAt(1);
        if (c1 < '0' || c1 > '7') {
            return false;
        }
        char c2 = seq.charAt(1);
        return c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
    }

    public static boolean isAbsolute(URI uri) {
        String p = uri.getPath();
        return p != null && p.startsWith("/");
    }

    public static File toFile(URI filename) {
        if (filename == null) {
            return null;
        }
        URI f = URLUtils.stripFragment(filename);
        if ("file".equals(f.getScheme()) && f.getPath() != null && f.isAbsolute()) {
            return new File(f);
        }
        return URLUtils.toFile(f.toString());
    }

    public static File toFile(String filename) {
        String f;
        if (filename == null) {
            return null;
        }
        try {
            f = URLDecoder.decode(filename, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        f = f.replace("\\", File.separator).replace("/", File.separator);
        return new File(f);
    }

    public static URI toURI(File file) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file.toURI();
        }
        try {
            return new URI(URLUtils.clean(file.getPath().replace("\\", "/").trim(), false));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static URI toURI(String file) {
        if (file == null) {
            return null;
        }
        if (File.separatorChar == '\\' && file.indexOf(92) != -1) {
            return URLUtils.toURI(new File(file));
        }
        try {
            return new URI(file);
        }
        catch (URISyntaxException e) {
            try {
                return new URI(URLUtils.clean(file.replace("\\", "/").trim(), false));
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
    }

    public static boolean directoryContains(URI directory, URI child) {
        String c;
        String d = directory.normalize().toString();
        if (d.equals(c = child.normalize().toString())) {
            return false;
        }
        return c.startsWith(d);
    }

    public static URI stripFragment(URI path) {
        return URLUtils.setFragment(path, null);
    }

    public static URI setFragment(URI path, String fragment) {
        try {
            if (path.getPath() != null) {
                return new URI(path.getScheme(), path.getUserInfo(), path.getHost(), path.getPort(), path.getPath(), path.getQuery(), fragment);
            }
            return new URI(path.getScheme(), path.getSchemeSpecificPart(), fragment);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI setQuery(URI path, String query) {
        try {
            if (path.getPath() != null) {
                return new URI(path.getScheme(), path.getUserInfo(), path.getHost(), path.getPort(), path.getPath(), query, path.getFragment());
            }
            return new URI(path.getScheme(), path.getSchemeSpecificPart(), path.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI removeFragment(URI path) {
        return URLUtils.setFragment(path, null);
    }

    public static URI setPath(URI orig, String path) {
        try {
            return new URI(orig.getScheme(), orig.getUserInfo(), orig.getHost(), orig.getPort(), path, orig.getQuery(), orig.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI setScheme(URI orig, String scheme) {
        try {
            return new URI(scheme, orig.getUserInfo(), orig.getHost(), orig.getPort(), orig.getPath(), orig.getQuery(), orig.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static URI getRelativePath(URI base, URI ref) {
        URI rel;
        String baseScheme = base.getScheme();
        String refScheme = ref.getScheme();
        String baseAuth = base.getAuthority();
        String refAuth = ref.getAuthority();
        if (!((baseScheme == null && refScheme == null || baseScheme != null && refScheme != null && baseScheme.equals(refScheme)) && (baseAuth == null && refAuth == null || baseAuth != null && refAuth != null && baseAuth.equals(refAuth)))) {
            return ref;
        }
        if (base.getPath().equals(ref.getPath()) && ref.getFragment() != null) {
            rel = URLUtils.toURI("");
        } else {
            StringBuilder upPathBuffer = new StringBuilder(128);
            StringBuilder downPathBuffer = new StringBuilder(128);
            Object basePath = base.normalize().getPath();
            if (((String)basePath).endsWith("/")) {
                basePath = (String)basePath + "dummy";
            }
            String refPath = ref.normalize().getPath();
            StringTokenizer baseTokenizer = new StringTokenizer((String)basePath, "/");
            StringTokenizer refTokenizer = new StringTokenizer(refPath, "/");
            while (baseTokenizer.countTokens() > 1 && refTokenizer.countTokens() > 1) {
                String baseToken = baseTokenizer.nextToken();
                String refToken = refTokenizer.nextToken();
                boolean equals = Constants.OS_NAME.toLowerCase().contains("windows") ? baseToken.equalsIgnoreCase(refToken) : baseToken.equals(refToken);
                if (equals) continue;
                if (baseToken.endsWith(":") || refToken.endsWith(":")) {
                    return ref;
                }
                upPathBuffer.append("..");
                upPathBuffer.append("/");
                downPathBuffer.append(refToken);
                downPathBuffer.append("/");
                break;
            }
            while (baseTokenizer.countTokens() > 1) {
                baseTokenizer.nextToken();
                upPathBuffer.append("..");
                upPathBuffer.append("/");
            }
            while (refTokenizer.hasMoreTokens()) {
                downPathBuffer.append(refTokenizer.nextToken());
                if (!refTokenizer.hasMoreTokens()) continue;
                downPathBuffer.append("/");
            }
            upPathBuffer.append((CharSequence)downPathBuffer);
            try {
                rel = new URI(null, null, upPathBuffer.toString(), null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return URLUtils.setFragment(rel, ref.getFragment());
    }

    public static URI getRelativePath(URI relativePath) {
        StringTokenizer tokenizer = new StringTokenizer(relativePath.toString(), "/");
        StringBuilder buffer = new StringBuilder();
        if (tokenizer.countTokens() == 1) {
            return null;
        }
        while (tokenizer.countTokens() > 1) {
            tokenizer.nextToken();
            buffer.append("..");
            buffer.append("/");
        }
        return URLUtils.toURI(buffer.toString());
    }

    public static boolean exists(URI file) {
        if (file.getScheme() == null) {
            return new File(file.getPath()).exists();
        }
        if ("file".equals(file.getScheme())) {
            URI resource = URLUtils.removeFragment(URLUtils.setQuery(file, null));
            return new File(resource).exists();
        }
        return true;
    }

    public static URI addSuffix(URI orig, String suffix) {
        String fragment = orig.getFragment();
        String u = URLUtils.stripFragment(orig).toString();
        int idx = u.lastIndexOf(".");
        URI res = idx != -1 ? URLUtils.toURI(u.substring(0, idx) + suffix + u.substring(idx)) : URLUtils.toURI(u + suffix);
        return URLUtils.setFragment(res, fragment);
    }

    public static URI setElementID(URI relativePath, String id) {
        String topic = URLUtils.getTopicID(relativePath);
        if (topic != null) {
            return URLUtils.setFragment(relativePath, topic + (String)(id != null ? "/" + id : ""));
        }
        if (id == null) {
            return URLUtils.stripFragment(relativePath);
        }
        throw new IllegalArgumentException(relativePath.toString());
    }

    public static String getElementID(String relativePath) {
        String fragment = FileUtils.getFragment(relativePath);
        if (fragment != null && fragment.lastIndexOf("/") != -1) {
            String id = fragment.substring(fragment.lastIndexOf("/") + 1);
            return id.isEmpty() ? null : id;
        }
        return null;
    }

    public static String getTopicID(URI relativePath) {
        String fragment = relativePath.getFragment();
        if (fragment != null) {
            String id = fragment.lastIndexOf("/") != -1 ? fragment.substring(0, fragment.lastIndexOf("/")) : fragment;
            return id.isEmpty() ? null : id;
        }
        return null;
    }

    public static URI toDirURI(File dir) {
        URI res = dir.toURI();
        if (res.getPath().endsWith("/")) {
            return res;
        }
        return URLUtils.setPath(res, res.getPath() + "/");
    }

    public static URI addSuffixToPath(URI src, String suffix) {
        Matcher matcher = EXTENSION_PATTERN.matcher(src.getPath());
        if (matcher.find()) {
            return URLUtils.setPath(src, matcher.replaceAll(suffix + "$0"));
        }
        return URLUtils.setPath(src, src.getPath() + suffix);
    }

    static {
        char[] escChs;
        EXTENSION_PATTERN = Pattern.compile("\\.\\w+?$");
        gNeedEscaping = new boolean[128];
        gAfterEscaping1 = new char[128];
        gAfterEscaping2 = new char[128];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        for (int i = 0; i <= 31; ++i) {
            URLUtils.gNeedEscaping[i] = true;
            URLUtils.gAfterEscaping1[i] = gHexChs[i >> 4];
            URLUtils.gAfterEscaping2[i] = gHexChs[i & 0xF];
        }
        URLUtils.gNeedEscaping[127] = true;
        URLUtils.gAfterEscaping1[127] = 55;
        URLUtils.gAfterEscaping2[127] = 70;
        char[] cArray = escChs = new char[]{' ', '<', '>', '\"', '{', '}', '|', '\\', '^', '[', ']', '`'};
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char escCh;
            char ch = escCh = cArray[i];
            URLUtils.gNeedEscaping[ch] = true;
            URLUtils.gAfterEscaping1[ch] = gHexChs[ch >> 4];
            URLUtils.gAfterEscaping2[ch] = gHexChs[ch & 0xF];
        }
    }
}

