/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import JTrrntzip.TrrntZipStatus;
import java.io.File;
import java.io.Serializable;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jrm.profile.data.AnywareBase;
import jrm.profile.data.Entry;
import org.apache.commons.io.FilenameUtils;

public class Container
implements Serializable {
    public final File file;
    public long modified = 0L;
    public long size = 0L;
    public final HashMap<String, Entry> entries_byname = new HashMap();
    public transient boolean up2date = false;
    public int loaded = 0;
    public long lastTZipCheck = 0L;
    public EnumSet<TrrntZipStatus> lastTZipStatus = EnumSet.noneOf(TrrntZipStatus.class);
    public transient AnywareBase m;
    private Type type = Type.UNK;

    protected Container(Type type, File file, AnywareBase m) {
        this.type = type;
        this.file = file;
        this.m = m;
    }

    protected Container(Type type, File file, BasicFileAttributes attr) {
        this(type, file, (AnywareBase)null);
        this.modified = attr.lastModifiedTime().toMillis();
        if (type != Type.DIR) {
            this.size = attr.size();
        }
    }

    public Entry add(Entry e) {
        Entry old_e = this.entries_byname.get(e.file);
        if (null != old_e && old_e.modified == e.modified && old_e.size == e.size) {
            return old_e;
        }
        this.entries_byname.put(e.file, e);
        e.parent = this;
        return e;
    }

    public Entry find(Entry e) {
        return this.entries_byname.get(e.file);
    }

    public Collection<Entry> getEntries() {
        return this.entries_byname.values();
    }

    public Map<String, Entry> getEntriesByName() {
        return this.entries_byname.values().stream().collect(Collectors.toMap(Entry::getName, Function.identity(), (n, e) -> n));
    }

    public Type getType() {
        return this.type;
    }

    public static Type getType(File file) {
        String ext = FilenameUtils.getExtension(file.getName());
        switch (ext.toLowerCase()) {
            case "zip": {
                return Type.ZIP;
            }
            case "7z": {
                return Type.SEVENZIP;
            }
            case "rar": {
                return Type.RAR;
            }
        }
        return Type.UNK;
    }

    public String toString() {
        return "Container " + this.file;
    }

    public static enum Type {
        UNK,
        DIR,
        ZIP,
        SEVENZIP,
        RAR;

    }
}

