/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.table.TableCellRenderer;
import javax.xml.stream.XMLStreamException;
import jrm.locale.Messages;
import jrm.profile.Profile;
import jrm.profile.data.AnywareList;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Driver;
import jrm.profile.data.Machine;
import jrm.profile.data.NameBase;
import jrm.profile.data.SamplesList;
import jrm.ui.profile.data.MachineListRenderer;
import jrm.ui.progress.ProgressHandler;
import jrm.xml.EnhancedXMLStreamWriter;

public final class MachineList
extends AnywareList<Machine>
implements Serializable {
    private final ArrayList<Machine> m_list = new ArrayList();
    private final HashMap<String, Machine> m_byname = new HashMap();
    public final SamplesList samplesets = new SamplesList();
    private transient Map<String, Machine> m_filtered_byname = null;

    public MachineList() {
        this.initTransient();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransient();
    }

    @Override
    protected void initTransient() {
        super.initTransient();
    }

    @Override
    public int getColumnCount() {
        return MachineListRenderer.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return MachineListRenderer.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return MachineListRenderer.columnsTypes[columnIndex];
    }

    @Override
    public TableCellRenderer getColumnRenderer(int columnIndex) {
        return MachineListRenderer.columnsRenderers[columnIndex];
    }

    @Override
    public int getColumnWidth(int columnIndex) {
        return MachineListRenderer.columnsWidths[columnIndex];
    }

    @Override
    public int getRowCount() {
        return this.getFilteredList().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Machine machine = this.getFilteredList().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return machine;
            }
            case 1: {
                return machine;
            }
            case 2: {
                return machine.description.toString();
            }
            case 3: {
                return String.format("%d/%d", machine.countHave(), machine.countAll());
            }
            case 4: {
                return machine.cloneof != null ? (this.m_byname.containsKey(machine.cloneof) ? this.m_byname.get(machine.cloneof) : machine.cloneof) : null;
            }
            case 5: {
                return machine.romof != null && !machine.romof.equals(machine.cloneof) ? (this.m_byname.containsKey(machine.romof) ? this.m_byname.get(machine.romof) : machine.romof) : null;
            }
            case 6: {
                return machine.sampleof != null ? (this.samplesets.containsName(machine.sampleof) ? this.samplesets.getByName(machine.sampleof) : machine.sampleof) : null;
            }
            case 7: {
                return machine.selected;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 7;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 7 && aValue instanceof Boolean) {
            Machine machine = this.getFilteredList().get(rowIndex);
            machine.selected = (Boolean)aValue;
        }
    }

    @Override
    public List<Machine> getList() {
        return this.m_list;
    }

    @Override
    public Stream<Machine> getFilteredStream() {
        boolean filterIncludeClones = Profile.curr_profile.getProperty("filter.InclClones", true);
        boolean filterIncludeDisks = Profile.curr_profile.getProperty("filter.InclDisks", true);
        boolean filterIncludeSamples = Profile.curr_profile.getProperty("filter.InclSamples", true);
        Driver.StatusType filterMinDriverStatus = Driver.StatusType.valueOf(Profile.curr_profile.getProperty("filter.DriverStatus", Driver.StatusType.preliminary.toString()));
        Machine.DisplayOrientation filterDisplayOrientation = Machine.DisplayOrientation.valueOf(Profile.curr_profile.getProperty("filter.DisplayOrientation", Machine.DisplayOrientation.any.toString()));
        Machine.CabinetType filterCabinetType = Machine.CabinetType.valueOf(Profile.curr_profile.getProperty("filter.CabinetType", Machine.CabinetType.any.toString()));
        String filterYearMin = Profile.curr_profile.getProperty("filter.YearMin", "");
        String filterYearMax = Profile.curr_profile.getProperty("filter.YearMax", "????");
        boolean excludeGames = Profile.curr_profile.getProperty("exclude_games", false);
        boolean excludeMachines = Profile.curr_profile.getProperty("exclude_machines", false);
        if (excludeGames && !excludeMachines) {
            HashSet machines = new HashSet();
            this.getList().stream().filter(t -> t.isSoftMachine()).forEach(m -> m.getDevices(machines, false, false, true));
            HashSet all_devices = new HashSet();
            this.getList().stream().filter(t -> !t.isdevice).forEach(m -> m.getDevices(all_devices, false, false, true));
            all_devices.removeAll(all_devices.stream().filter(t -> !t.isdevice).collect(Collectors.toSet()));
            return Stream.concat(machines.stream().filter(t -> !t.isSoftMachine()), this.getList().stream().filter(t -> t.isdevice && !all_devices.contains(t)));
        }
        return this.getList().stream().filter(t -> {
            if (excludeGames && !t.isdevice && !t.isbios && !t.isSoftMachine()) {
                return false;
            }
            if (excludeMachines && !t.isdevice && !t.isbios && t.isSoftMachine()) {
                return false;
            }
            if (!t.isdevice) {
                if (filterMinDriverStatus == Driver.StatusType.imperfect && t.driver.getStatus() == Driver.StatusType.preliminary) {
                    return false;
                }
                if (filterMinDriverStatus == Driver.StatusType.good && t.driver.getStatus() != Driver.StatusType.good) {
                    return false;
                }
                if (!t.ismechanical) {
                    if (filterDisplayOrientation == Machine.DisplayOrientation.horizontal && t.orientation == Machine.DisplayOrientation.vertical) {
                        return false;
                    }
                    if (filterDisplayOrientation == Machine.DisplayOrientation.vertical && t.orientation == Machine.DisplayOrientation.horizontal) {
                        return false;
                    }
                    if (!t.isbios) {
                        if (filterCabinetType == Machine.CabinetType.upright && t.cabinetType == Machine.CabinetType.cocktail) {
                            return false;
                        }
                        if (filterCabinetType == Machine.CabinetType.cocktail && t.cabinetType == Machine.CabinetType.upright) {
                            return false;
                        }
                    }
                }
            }
            if (t.year.length() > 0) {
                if (filterYearMin.compareTo(t.year.toString()) > 0) {
                    return false;
                }
                if (filterYearMax.compareTo(t.year.toString()) < 0) {
                    return false;
                }
            }
            if (!filterIncludeClones && t.isClone()) {
                return false;
            }
            if (!filterIncludeDisks && t.disks.size() > 0) {
                return false;
            }
            if (!filterIncludeSamples && t.samples.size() > 0) {
                return false;
            }
            if (!t.getSystem().isSelected()) {
                return false;
            }
            if (t.subcat != null && !t.subcat.isSelected()) {
                return false;
            }
            return t.nplayer == null || t.nplayer.isSelected();
        });
    }

    @Override
    protected List<Machine> getFilteredList() {
        if (this.filtered_list == null) {
            this.filtered_list = this.getFilteredStream().filter(machine -> AnywareList.filter.contains(machine.getStatus())).sorted().collect(Collectors.toList());
        }
        return this.filtered_list;
    }

    @Override
    public long countAll() {
        return this.getFilteredStream().count();
    }

    @Override
    public long countHave() {
        return this.getFilteredStream().filter(t -> t.getStatus() == AnywareStatus.COMPLETE).count();
    }

    public void export(EnhancedXMLStreamWriter writer, ProgressHandler progress, boolean is_mame, boolean filtered) throws XMLStreamException, IOException {
        if (is_mame) {
            writer.writeStartElement("mame");
        } else {
            writer.writeStartElement("datafile");
        }
        List<Machine> list = filtered ? this.getFilteredStream().collect(Collectors.toList()) : this.getList();
        int i = 0;
        progress.setProgress(Messages.getString("MachineList.Exporting"), i, list.size());
        for (Machine m : list) {
            progress.setProgress(String.format(Messages.getString("MachineList.Exporting_%s"), m.name), ++i);
            if (filtered && !m.selected) continue;
            m.export(writer, is_mame);
        }
        writer.writeEndElement();
    }

    @Override
    public boolean containsName(String name) {
        return this.m_byname.containsKey(name);
    }

    @Override
    public Machine getByName(String name) {
        return this.m_byname.get(name);
    }

    @Override
    public Machine putByName(Machine t) {
        return this.m_byname.put(t.getName(), t);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void resetFilteredName() {
        this.m_filtered_byname = this.getFilteredStream().collect(Collectors.toMap(NameBase::getBaseName, Function.identity()));
    }

    @Override
    public boolean containsFilteredName(String name) {
        if (this.m_filtered_byname == null) {
            this.resetFilteredName();
        }
        return this.m_filtered_byname.containsKey(name);
    }

    @Override
    public Machine getFilteredByName(String name) {
        if (this.m_filtered_byname == null) {
            this.resetFilteredName();
        }
        return this.m_filtered_byname.get(name);
    }

    @Override
    public TableCellRenderer[] getCellRenderers() {
        return MachineListRenderer.columnsRenderers;
    }
}

