; Warp Rogue install script
;

;--------------------------------

; The name of the installer
Name "Warp Rogue 0.8.0b"

; The file to write
OutFile "wrogue-0.8.0b-i686.exe"

; Adds an XP manifest to the installer
XPStyle on

; Turns off Window Icon
WindowIcon off

; The default installation directory
InstallDir "$PROGRAMFILES\Warp Rogue 0.8.0b"



;--------------------------------

; Pages

Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------

; The stuff to install
Section "Warp Rogue 0.8.0b"

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File /r C:\wrogue\*.*

  WriteUninstaller "uninstall.exe"
  
SectionEnd

Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\Warp Rogue 0.8.0b"
  CreateShortCut "$SMPROGRAMS\Warp Rogue 0.8.0b\Warp Rogue.lnk" "$INSTDIR\wrogue.exe" "" "$INSTDIR\wrogue.exe" 0
  CreateShortCut "$SMPROGRAMS\Warp Rogue 0.8.0b\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0

SectionEnd


;--------------------------------

; Uninstaller

Section "Uninstall"

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\Warp Rogue 0.8.0b\*.*"

  ; Remove directories used
  RMDir "$SMPROGRAMS\Warp Rogue 0.8.0b"
  RMDir /r "$INSTDIR"

SectionEnd
