/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.renderer;

import com.jgoodies.app.gui.basics.format.AppFormats;
import com.jgoodies.layout.builder.FormBuilder;
import java.awt.Component;
import java.time.LocalDateTime;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

final class DateTimeShortcutTableCellRenderer
implements TableCellRenderer,
UIResource {
    private final TableCellRenderer dateRenderer = new DefaultTableCellRenderer();
    private final TableCellRenderer timeRenderer = new DefaultTableCellRenderer();
    private Component dateComponent;
    private Component timeComponent;
    private JComponent panel;

    DateTimeShortcutTableCellRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        LocalDateTime dateTime = (LocalDateTime)value;
        String date = AppFormats.formatDate(dateTime.toLocalDate(), true);
        String time = AppFormats.formatTime(dateTime);
        this.dateComponent = this.dateRenderer.getTableCellRendererComponent(table, date, isSelected, false, row, column);
        this.timeComponent = this.timeRenderer.getTableCellRendererComponent(table, time, isSelected, false, row, column);
        this.getPanel().setBackground(this.dateComponent.getBackground());
        return this.getPanel();
    }

    private JComponent getPanel() {
        if (this.panel == null) {
            this.panel = this.buildPanel();
        }
        return this.panel;
    }

    private JComponent buildPanel() {
        ((JComponent)this.dateComponent).setOpaque(false);
        ((JComponent)this.timeComponent).setOpaque(false);
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("'31.12.12 ', ' ', pref", new Object[0])).rows("p", new Object[0])).opaque(false)).add(this.dateComponent).xy(1, 1)).add(this.timeComponent).xy(3, 1)).build();
    }
}

