/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.util;

import com.jgoodies.app.gui.basics.AppResources;
import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.dialogs.basics.BasicVerification;
import com.jgoodies.dialogs.basics.MessagePaneBuilder;
import com.jgoodies.dialogs.basics.StandardPaneBuilder;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.pane.task.TaskPaneBuilder;
import com.jgoodies.dialogs.core.pane.task.TaskPaneVisualConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.util.EventObject;
import java.util.function.Consumer;
import javax.swing.JFrame;

public final class PrototypeUtils {
    private static final ResourceMap RESOURCES = Application.getResourceMap(AppResources.class);

    private PrototypeUtils() {
    }

    public static Consumer<ActionEvent> fake() {
        return PrototypeUtils::fake;
    }

    public static void fake(EventObject evt) {
        ((MessagePaneBuilder)new MessagePaneBuilder().owner(evt)).mainInstructionText("This is a fake command", new Object[0]).showInformation();
    }

    public static Consumer<ActionEvent> notYetAvailable(String command) {
        return evt -> PrototypeUtils.showNotYetAvailable(evt, command);
    }

    public static ActionListener notYetAvailableListener(String command) {
        return evt -> PrototypeUtils.showNotYetAvailable(evt, command);
    }

    public static void showNotYetAvailable(EventObject evt, String command) {
        ((StandardPaneBuilder)new StandardPaneBuilder().owner(evt)).showNotYetAvailable(command);
    }

    public static void checkExpired(JFrame owner, LocalDate expirationDate) {
        if ("off".equals(System.getProperty("checkExpiration"))) {
            return;
        }
        if (LocalDate.now().isBefore(expirationDate)) {
            return;
        }
        ((MessagePaneBuilder)new MessagePaneBuilder().owner(owner)).mainInstructionText(RESOURCES.getString("jgoodies.app.expired.mainInstruction", new Object[0]), new Object[0]).supplementalInstructionText(RESOURCES.getString("jgoodies.app.expired.supplementalInstruction", new Object[0]), new Object[0]).showInformation();
        System.exit(0);
    }

    public static void confirmConfidentiality(JFrame owner) {
        if ("off".equals(System.getProperty("confirmConfidentiality"))) {
            return;
        }
        boolean cancelled = ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(owner)).title(RESOURCES.getString("application.title", new Object[0]), new Object[0])).mainInstructionIcon(RESOURCES.getIcon("jgoodies.app.confidential.icon")).mainInstructionIconVerticalAlignment(TaskPaneVisualConfiguration.MainInstructionIconVerticalAlignment.MAIN_INSTRUCTION_AND_CONTENT).mainInstructionText(RESOURCES.getString("jgoodies.app.confidential.mainInstruction", new Object[0]), new Object[0]).contentText(RESOURCES.getString("jgoodies.app.confidential.content", new Object[0]), new Object[0]).commitCommands(CommandValue.ACCEPT, CommandValue.DECLINE).cancelCommand(CommandValue.DECLINE).preferredWidth(310)).showDialogReturnCancelled();
        if (cancelled) {
            System.exit(0);
        }
    }

    public static void confirmConfidentialityOnce(JFrame owner) {
        BasicVerification verification = BasicVerification.create("dialogs.dontShowAgain.text", "confirm_confidential", false);
        if (!verification.isSelected()) {
            PrototypeUtils.confirmConfidentiality(owner);
        }
        verification.setSelected(true);
    }

    public static void confirmPrototype(JFrame parent) {
        BasicVerification verification = BasicVerification.create("dialogs.dontShowAgain.text", "confirm_prototyp", false);
        if (verification.isSelected()) {
            return;
        }
        boolean cancelled = ((TaskPaneBuilder)((TaskPaneBuilder)((TaskPaneBuilder)new TaskPaneBuilder().owner(parent)).title(RESOURCES.getString("application.title", new Object[0]), new Object[0])).mainInstructionText(RESOURCES.getString("jgoodies.app.raw.mainInstruction", new Object[0]), new Object[0]).contentText(RESOURCES.getString("jgoodies.app.raw.content", new Object[0]), new Object[0]).commitCommands(RESOURCES.getString("jgoodies.app.raw.command", new Object[0])).cancelAllowed(true).verification(verification).preferredWidth(285)).showDialogReturnCancelled();
        if (cancelled) {
            System.exit(0);
        }
    }
}

