/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class ComboBoxAdapter<E>
extends AbstractListModel<E>
implements ComboBoxModel<E> {
    private final ListModel<E> listModel;
    private ValueModel selectionHolder;
    private final PropertyChangeListener selectionChangeHandler;

    public ComboBoxAdapter(List<E> items, ValueModel selectionHolder) {
        this(new ListModelAdapter<E>(items), selectionHolder);
        Preconditions.checkNotNull(items, "The %s must not be null.", "list");
    }

    public ComboBoxAdapter(ListModel<E> listModel, ValueModel selectionHolder) {
        this.listModel = Preconditions.checkNotNull(listModel, "The %s must not be null.", "ListModel");
        this.selectionHolder = Preconditions.checkNotNull(selectionHolder, "The %s must not be null.", "selection holder");
        listModel.addListDataListener(new ListDataChangeHandler());
        this.selectionChangeHandler = this::onSelectionChanged;
        this.setSelectionHolder(selectionHolder);
    }

    public ComboBoxAdapter(E[] items, ValueModel selectionHolder) {
        this(new ListModelAdapter<E>(items), selectionHolder);
    }

    public ComboBoxAdapter(SelectionInList<E> selectionInList) {
        this(selectionInList, selectionInList);
        selectionInList.addPropertyChangeListener("selectionHolder", this::onSelectionHolderChanged);
    }

    @Override
    public E getSelectedItem() {
        return (E)this.selectionHolder.getValue();
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectionHolder.setValue(object);
    }

    @Override
    public int getSize() {
        return this.listModel.getSize();
    }

    @Override
    public E getElementAt(int index) {
        return this.listModel.getElementAt(index);
    }

    private void setSelectionHolder(ValueModel newSelectionHolder) {
        ValueModel oldSelectionHolder = this.selectionHolder;
        if (oldSelectionHolder != null) {
            oldSelectionHolder.removeValueChangeListener(this.selectionChangeHandler);
        }
        this.selectionHolder = Preconditions.checkNotNull(newSelectionHolder, "The %s must not be null.", "selection holder");
        newSelectionHolder.addValueChangeListener(this.selectionChangeHandler);
    }

    private void fireContentsChanged() {
        this.fireContentsChanged(this, -1, -1);
    }

    private void onSelectionChanged(PropertyChangeEvent evt) {
        this.fireContentsChanged();
    }

    private void onSelectionHolderChanged(PropertyChangeEvent evt) {
        this.setSelectionHolder((ValueModel)evt.getNewValue());
        this.fireContentsChanged();
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            ComboBoxAdapter.this.fireIntervalAdded(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            ComboBoxAdapter.this.fireIntervalRemoved(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }
    }

    private static final class ListModelAdapter<E>
    extends AbstractListModel<E> {
        private final List<E> aList;

        ListModelAdapter(List<E> list) {
            this.aList = list;
        }

        ListModelAdapter(E[] elements) {
            this(Arrays.asList(elements));
        }

        @Override
        public int getSize() {
            return this.aList.size();
        }

        @Override
        public E getElementAt(int index) {
            return this.aList.get(index);
        }
    }
}

