/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.binder;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.binder.ListBindingBuilder;
import com.jgoodies.common.base.Preconditions;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public class ListBindingBuilderImpl<E>
implements ListBindingBuilder<E> {
    private final ListModel<E> dataModel;
    private final ListSelectionModel selectionModel;

    public ListBindingBuilderImpl(E[] data, ListSelectionModel selectionModel) {
        this(new ArrayToListModel<E>(data), selectionModel);
    }

    public ListBindingBuilderImpl(List<E> data, ListSelectionModel selectionModel) {
        this(new ListToListModel<E>(data), selectionModel);
    }

    public ListBindingBuilderImpl(ListModel<E> dataModel, ListSelectionModel selectionModel) {
        this.dataModel = Preconditions.checkNotNull(dataModel, "The %s must not be null.", "ListModel");
        this.selectionModel = Preconditions.checkNotNull(selectionModel, "The %s must not be null.", "ListSelectionModel");
    }

    @Override
    public void to(JTable table) {
        Bindings.bind(table, this.dataModel, this.selectionModel);
    }

    @Override
    public void to(JList<E> list) {
        list.setModel(this.dataModel);
        list.setSelectionModel(this.selectionModel);
    }

    private static final class ArrayToListModel<T>
    extends AbstractListModel<T> {
        private final T[] array;

        ArrayToListModel(T[] array) {
            this.array = array;
        }

        @Override
        public T getElementAt(int index) {
            return this.array[index];
        }

        @Override
        public int getSize() {
            return this.array.length;
        }
    }

    private static final class ListToListModel<T>
    extends AbstractListModel<T> {
        private final List<T> list;

        ListToListModel(List<T> list) {
            this.list = list;
        }

        @Override
        public T getElementAt(int index) {
            return this.list.get(index);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }
    }
}

