/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.AbstractChartModel;
import com.jgoodies.chart.ChartModel;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ColoredChartModel<T>
extends AbstractChartModel<T> {
    private final ChartModel<T> delegate;
    private Color[] colors;
    private int colorCount;
    private float saturation;
    private float brightness;

    public ColoredChartModel(ChartModel<T> chartModel, int colorCount, float saturation, float brightness) {
        this.delegate = chartModel;
        this.colorCount = colorCount;
        this.saturation = saturation;
        this.brightness = brightness;
        this.colorize();
        this.initEventHandling();
    }

    private void initEventHandling() {
        this.delegate.addChangeListener(new DelegateChangeHandler());
    }

    public int getColorCount() {
        return this.colorCount;
    }

    public void setColorCount(int newColorCount) {
        this.colorCount = newColorCount;
        this.onDelegateChanged();
    }

    public float getSaturation() {
        return this.saturation;
    }

    public void setSaturation(float newSaturation) {
        this.saturation = newSaturation;
        this.onDelegateChanged();
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float newBrightness) {
        this.brightness = newBrightness;
        this.onDelegateChanged();
    }

    @Override
    public int getItemCount() {
        return this.delegate.getItemCount();
    }

    @Override
    public T getData(int index) {
        return this.delegate.getData(index);
    }

    @Override
    public Icon getIcon(int index) {
        return this.delegate.getIcon(index);
    }

    @Override
    public String getText(int index) {
        return this.delegate.getText(index);
    }

    @Override
    public long getSize(int index) {
        return this.delegate.getSize(index);
    }

    @Override
    public Color getColor(int index) {
        Color color = this.delegate.getColor(index);
        return color != null ? color : this.colors[index];
    }

    private void onDelegateChanged() {
        this.colorize();
        this.fireStateChanged();
    }

    private void colorize() {
        int itemCount = this.getItemCount();
        int colored = 0;
        this.colors = new Color[itemCount];
        for (int index = 0; index < itemCount; ++index) {
            Color delegateColor = this.delegate.getColor(index);
            if (delegateColor != null) continue;
            this.colors[index] = ColoredChartModel.color(colored++, this.colorCount, this.saturation, this.brightness);
        }
    }

    private static Color color(int index, int count, float sat, float bright) {
        return Color.getHSBColor((float)index / (float)(count + 1), sat, bright);
    }

    private final class DelegateChangeHandler
    implements ChangeListener {
        private DelegateChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ColoredChartModel.this.onDelegateChanged();
        }
    }
}

