/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.chart;

import com.jgoodies.chart.AbstractTreeChart;
import com.jgoodies.chart.TreeChartModel;
import java.awt.Color;
import java.awt.Graphics2D;

public final class SunburstChart<T>
extends AbstractTreeChart<T> {
    private static final int MAX_LEVEL = 5;
    private static final Color LEAF_COLOR = new Color(225, 225, 225);
    private int xCenter;
    private int yCenter;
    private int radius;

    public SunburstChart(TreeChartModel<T> model) {
        super(model);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.xCenter = width / 2;
        this.yCenter = height / 2;
        int xRadius = Math.round((width - 10) / 2);
        int yRadius = Math.round((height - 10) / 2);
        this.radius = Math.max(0, Math.min(xRadius, yRadius));
    }

    @Override
    protected void render(Graphics2D g2, T root) {
        int level = 0;
        int startAngle = 0;
        int stopAngle = 360;
        boolean allParentsSingletons = false;
        float startHue = 0.0f;
        float stopHue = 1.0f;
        float saturation = 0.5f;
        float brightness = 0.9f;
        int leafStartLevel = 0;
        int trailStartLevel = 0;
        this.render(g2, root, level, startAngle, stopAngle, allParentsSingletons, leafStartLevel, trailStartLevel, startHue, stopHue, saturation, brightness);
    }

    private void render(Graphics2D g2, T node, int level, int startAngle, int angle, boolean allParentsSingletons, int leadStartLevel, int trailStartLevel, float startHue, float stopHue, float saturation, float brightness) {
        int childCount = this.model.getChildCount(node);
        if (level < 5) {
            int[] angles = this.computePartitions(node, angle);
            int childStartAngle = startAngle;
            double totalHue = stopHue - startHue;
            for (int i = 0; i < childCount; ++i) {
                boolean firstChild = i == 0;
                boolean lastChild = i == childCount - 1;
                int childAngle = angles[i];
                double nextChildStartHue = (double)startHue + totalHue * (double)((float)i / 14.0f);
                double nextChildStopHue = (double)startHue + totalHue * (double)((float)(i + 1) / 14.0f);
                if (angle > 0) {
                    this.render(g2, this.model.getChild(node, i), level + 1, childStartAngle, childAngle, allParentsSingletons, firstChild ? leadStartLevel : level, lastChild ? trailStartLevel : level, (float)nextChildStartHue, (float)nextChildStopHue, saturation * 0.8f, brightness * 1.02f);
                }
                childStartAngle += childAngle;
            }
        }
        if (level > 0) {
            Color fillColor = this.model.isLeaf(node) ? LEAF_COLOR : Color.getHSBColor(startHue, saturation, brightness);
            g2.setColor(fillColor);
            this.fillArc(g2, startAngle, angle, level);
        }
        if (level < 5 && childCount > 0 && (double)angle > 0.0) {
            g2.setColor(Color.GRAY);
            this.drawArc(g2, startAngle, angle, level + 1);
        }
        if (angle != 0 && angle != 360 || level == 5) {
            g2.setColor(Color.GRAY);
            int stopAngle = startAngle + angle;
            this.renderRadialLine(g2, startAngle, leadStartLevel, level);
            this.renderRadialLine(g2, stopAngle, trailStartLevel, level);
        }
    }

    private void drawArc(Graphics2D g2, int startAngle, int arcAngle, int level) {
        int arcRadius = (int)((double)this.radius * (double)level / 5.0 - 1.0);
        g2.drawArc(this.xCenter - arcRadius, this.yCenter - arcRadius, 2 * arcRadius, 2 * arcRadius, -startAngle + 90, -arcAngle);
    }

    private void fillArc(Graphics2D g2, int startAngle, int arcAngle, int level) {
        int arcRadius = (int)((double)this.radius * (double)level / 5.0 - 1.0);
        g2.fillArc(this.xCenter - arcRadius, this.yCenter - arcRadius, 2 * arcRadius, 2 * arcRadius, -startAngle + 90, -arcAngle);
    }

    private void renderRadialLine(Graphics2D g2, int anAngle, int innerLevel, int outerLevel) {
        double radian = Math.toRadians(anAngle);
        double innerRadius = (double)this.radius * (double)innerLevel / 5.0 - 1.0;
        double outerRadius = (double)this.radius * (double)outerLevel / 5.0 - 0.5;
        int xInner = this.xCenter + (int)(Math.sin(radian) * (innerRadius - 0.5));
        int yInner = this.yCenter - (int)(Math.cos(radian) * (innerRadius - 0.5));
        int xOuter = this.xCenter + (int)(Math.sin(radian) * (outerRadius - 0.5));
        int yOuter = this.yCenter - (int)(Math.cos(radian) * (outerRadius - 0.5));
        g2.drawLine(xInner, yInner, xOuter, yOuter);
    }
}

