/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.util;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.jsdl.icon.IconValue;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public final class IconUtils {
    private IconUtils() {
    }

    public static Icon crop(Icon icon, Insets insets) {
        return icon == null ? null : new PaddedIcon(icon, new Insets(-insets.top, -insets.left, -insets.bottom, -insets.right));
    }

    public static Icon crop(IconValue icon, Insets insets) {
        return icon == null ? null : IconUtils.crop(icon.toIcon(), insets);
    }

    public static Icon pad(Icon icon, Insets insets) {
        return icon == null ? null : new PaddedIcon(icon, insets);
    }

    public static Icon pad(IconValue icon, Insets insets) {
        return icon == null ? null : IconUtils.pad(icon.toIcon(), insets);
    }

    static final class PaddedIcon
    implements Icon {
        private final Icon wrappedIcon;
        private final Insets insets;

        PaddedIcon(Icon wrappedIcon, Insets insets) {
            this.wrappedIcon = Preconditions.checkNotNull(wrappedIcon, "The %s must not be null.", "wrapped icon");
            this.insets = Preconditions.checkNotNull(insets, "The %s must not be null.", "icon insets");
        }

        @Override
        public int getIconHeight() {
            return this.wrappedIcon.getIconHeight() + this.insets.top + this.insets.bottom;
        }

        @Override
        public int getIconWidth() {
            return this.wrappedIcon.getIconWidth() + this.insets.left + this.insets.right;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.wrappedIcon.paintIcon(c, g, x + this.insets.left, y + this.insets.top);
        }
    }
}

