/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.components.util;

import com.jgoodies.common.base.SystemUtils;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;

public final class OSXComponentProperties {
    private OSXComponentProperties() {
    }

    public static void setSizeVariant(JComponent component, SizeVariant variant) {
        component.putClientProperty("JComponent.sizeVariant", variant.getValue());
    }

    public static void setButtonType(JButton button, ButtonType type) {
        button.putClientProperty("JButton.buttonType", type.getValue());
    }

    public static void setHelpButton(JButton button) {
        if (!SystemUtils.IS_OS_MAC) {
            return;
        }
        OSXComponentProperties.setButtonType(button, ButtonType.HELP);
        button.setText(null);
        button.setIcon(null);
    }

    public static void setSegmentedTypeAndPosition(AbstractButton button, SegmentedButtonType type, SegmentPosition position) {
        button.putClientProperty("JButton.buttonType", type.getValue());
        button.putClientProperty("JButton.segmentPosition", position.getValue());
    }

    public static void setSegmentedTypeAndPosition(AbstractButton button, SegmentedButtonType type, int index, int segmentLength) {
        SegmentPosition position = segmentLength == 1 ? SegmentPosition.ONLY : (index == 0 ? SegmentPosition.FIRST : (index == segmentLength - 1 ? SegmentPosition.LAST : SegmentPosition.MIDDLE));
        OSXComponentProperties.setSegmentedTypeAndPosition(button, type, position);
    }

    public static enum ButtonType {
        HELP("help"),
        ROUND_RECT("roundRect"),
        TEXTURED("textured");

        public static final String KEY = "JButton.buttonType";
        private final String value;

        public String getValue() {
            return this.value;
        }

        private ButtonType(String value) {
            this.value = value;
        }
    }

    public static enum SegmentPosition {
        FIRST("first"),
        MIDDLE("middle"),
        LAST("last"),
        ONLY("only");

        public static final String KEY = "JButton.segmentPosition";
        private final String value;

        public String getValue() {
            return this.value;
        }

        private SegmentPosition(String value) {
            this.value = value;
        }
    }

    public static enum SegmentedButtonType {
        ROUND_RECT("segmentedRoundRect"),
        TEXTURED("segmentedTextured");

        public static final String KEY = "JButton.buttonType";
        private final String value;

        public String getValue() {
            return this.value;
        }

        private SegmentedButtonType(String value) {
            this.value = value;
        }
    }

    public static enum SizeVariant {
        REGULAR("regular"),
        SMALL("small"),
        MINI("mini");

        public static final String KEY = "JComponent.sizeVariant";
        private final String value;

        public String getValue() {
            return this.value;
        }

        private SizeVariant(String value) {
            this.value = value;
        }
    }
}

