/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.validation;

import com.jgoodies.binding.beans.BeanAdapter;
import com.jgoodies.binding.beans.DelayedPropertyChangeHandler;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;

public final class ValidationSupport<T> {
    private static final Logger LOGGER = Logger.getLogger(ValidationSupport.class.getName());
    private final BeanAdapter<T> beanAdapter;
    private final Validator<T> validator;
    private final DelayedPropertyChangeHandler delayedValidationHandler;
    private final ValidationResultModel validationResultModel;
    private SwingWorker<ValidationResult, Object> validationWorker;

    public ValidationSupport(ValueModel beanChannel, Validator<T> validator) {
        this(beanChannel, validator, 200);
    }

    public ValidationSupport(ValueModel beanChannel, Validator<T> validator, int delay) {
        Preconditions.checkNotNull(validator, "The %s must not be null.", "validator");
        Preconditions.checkNotNull(beanChannel, "The %s must not be null.", "bean channel");
        this.validator = validator;
        this.beanAdapter = new BeanAdapter(beanChannel, true);
        this.validationResultModel = new DefaultValidationResultModel();
        this.delayedValidationHandler = new DelayedPropertyChangeHandler(this::onDelayedPropertyChange, delay, true);
        this.beanAdapter.addBeanPropertyChangeListener(this.delayedValidationHandler);
    }

    public Validator<T> getValidator() {
        return this.validator;
    }

    public ValidationResultModel getValidationResultModel() {
        return this.validationResultModel;
    }

    public synchronized ValidationResult validateImmediately() {
        this.delayedValidationHandler.stop();
        if (this.validationWorker != null) {
            this.validationWorker.cancel(true);
        }
        LOGGER.log(Level.FINER, "Validating in foreground");
        ValidationResult result = this.getValidator().validate(this.getBean());
        if (EventQueue.isDispatchThread()) {
            this.validationResultModel.setResult(result);
        } else {
            EventQueue.invokeLater(() -> this.validationResultModel.setResult(result));
        }
        return this.validationResultModel.getResult();
    }

    public synchronized void validateInBackground() {
        if (this.validationWorker != null) {
            this.validationWorker.cancel(true);
        }
        this.validationWorker = new ValidationWorker();
        this.validationWorker.execute();
    }

    private T getBean() {
        return this.beanAdapter.getBean();
    }

    private void onDelayedPropertyChange(PropertyChangeEvent evt) {
        this.validateInBackground();
    }

    private final class ValidationWorker
    extends SwingWorker<ValidationResult, Object> {
        private ValidationWorker() {
        }

        @Override
        protected ValidationResult doInBackground() throws Exception {
            LOGGER.log(Level.FINER, "Validating in background");
            return ValidationSupport.this.getValidator().validate(ValidationSupport.this.getBean());
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                ValidationSupport.this.validationWorker = null;
                return;
            }
            try {
                ValidationSupport.this.getValidationResultModel().setResult((ValidationResult)this.get());
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINEST, "ValidationWorker interrupted", e);
            }
            catch (ExecutionException e) {
                LOGGER.log(Level.INFO, "ValidationWorker execution failed", e);
            }
            ValidationSupport.this.validationWorker = null;
        }
    }
}

