/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.framework.util;

import com.jgoodies.application.Application;
import com.jgoodies.application.ExitListener;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.JSDLCommonSetup;
import com.jgoodies.common.jsdl.icon.DynamicIconValue;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.framework.util.ScreenUtils;
import com.jgoodies.framework.util.WindowUtils;
import com.jgoodies.layout.builder.FormBuilder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowListener;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;

public final class FrameBuilder {
    private static int frameCounter = 1;
    private final JFrame frame;
    private int defaultCloseOperation = 0;
    private String title;
    private String name;
    private Icon splashIcon;
    private String splashTitleText;
    private Font splashTitleFont;
    private String splashSubtitleText;
    private Font splashSubtitleFont;
    private Color foreground;
    private JComponent contentPane;
    private Dimension[] effectiveInitialSizes;
    private ScreenUtils.ScreenLocation initialLocation = ScreenUtils.ScreenLocation.OPTICAL_CENTER;
    private boolean restoreBounds = true;
    private WindowListener windowListener;
    private Runnable applicationExitedRunnable;

    public FrameBuilder() {
        this(new JFrame());
    }

    public FrameBuilder(JFrame frame) {
        this.frame = frame;
    }

    public FrameBuilder defaultCloseOperation(int defaultCloseOperation) {
        this.defaultCloseOperation = defaultCloseOperation;
        return this;
    }

    public FrameBuilder title(String title, Object ... args) {
        Preconditions.checkNotBlank(title, "The %s must not be null, empty, or whitespace.", "title");
        this.title = Strings.get(title, args);
        return this;
    }

    public FrameBuilder name(String name, Object ... args) {
        Preconditions.checkNotBlank(name, "The %s must not be null, empty, or whitespace.", "name");
        this.name = Strings.get(name, args);
        return this;
    }

    public FrameBuilder iconImages(Image ... icons) {
        Preconditions.checkNotNullOrEmpty(icons, "The %s must not be null or empty.", "icon images");
        this.frame.setIconImages(Arrays.asList(icons));
        return this;
    }

    public FrameBuilder minimumSize(int effectiveWidth, int effectiveHeight) {
        this.frame.setMinimumSize(ScreenScaling.physicalDimension(effectiveWidth, effectiveHeight));
        return this;
    }

    public FrameBuilder minimumSize(Dimension effectiveMinimumSize) {
        return this.minimumSize(effectiveMinimumSize.width, effectiveMinimumSize.height);
    }

    public FrameBuilder initialSize(int effectiveWidth, int effectiveHeight) {
        return this.initialSizes(new Dimension(effectiveWidth, effectiveHeight));
    }

    public FrameBuilder initialSizes(Dimension ... effectiveInitialSizes) {
        Preconditions.checkNotNullOrEmpty(effectiveInitialSizes, "The %s must not be null or empty.", "initial sizes");
        this.effectiveInitialSizes = effectiveInitialSizes;
        return this;
    }

    public FrameBuilder initialLocation(ScreenUtils.ScreenLocation location) {
        this.initialLocation = Preconditions.checkNotNull(location, "The %s must not be null.", "initial logical screen location");
        return this;
    }

    public FrameBuilder restoreBounds(boolean value) {
        this.restoreBounds = value;
        return this;
    }

    public FrameBuilder background(Color background) {
        this.frame.setBackground(background);
        return this;
    }

    public FrameBuilder foreground(Color foreground) {
        this.foreground = foreground;
        return this;
    }

    public FrameBuilder menuBar(JMenuBar menuBar) {
        this.frame.setJMenuBar(menuBar);
        return this;
    }

    public FrameBuilder contentPane(JComponent contentPane) {
        this.contentPane = contentPane;
        return this;
    }

    public FrameBuilder splashTitleIcon(Icon icon) {
        Preconditions.checkNotNull(icon, "The %s must not be null.", "splash icon");
        this.splashIcon = icon;
        return this;
    }

    public FrameBuilder splashTitleIcon(DynamicIconValue iconValue) {
        return this.splashTitleIcon(iconValue.toIcon(72, Color.GRAY));
    }

    public FrameBuilder splashTitleText(String text, Object ... args) {
        Preconditions.checkNotBlank(text, "The %s must not be null, empty, or whitespace.", "splash title");
        this.splashTitleText = Strings.get(text, args);
        return this;
    }

    public FrameBuilder splashTitleFont(Font font) {
        this.splashTitleFont = font;
        return this;
    }

    public FrameBuilder splashTitleFont(int effectiveSize) {
        return this.splashTitleFont(FrameBuilder.getDefaultFont(1, effectiveSize));
    }

    public FrameBuilder splashSubtitleText(String subtitle, Object ... args) {
        Preconditions.checkNotBlank(subtitle, "The %s must not be null, empty, or whitespace.", "splash sub title");
        this.splashSubtitleText = Strings.get(subtitle, args);
        return this;
    }

    public FrameBuilder splashSubitleFont(Font font) {
        this.splashSubtitleFont = font;
        return this;
    }

    public FrameBuilder windowListener(WindowListener listener) {
        this.windowListener = listener;
        return this;
    }

    public FrameBuilder onApplicationExited(Runnable applicationExitedHandler) {
        this.applicationExitedRunnable = applicationExitedHandler;
        return this;
    }

    public FrameBuilder asRootFrame() {
        JSDLCommonSetup.setRootFrame(this.frame);
        return this;
    }

    public JFrame build() {
        this.frame.setTitle(this.getTitle());
        this.frame.setName(this.getName());
        this.frame.setDefaultCloseOperation(this.defaultCloseOperation);
        if (this.defaultCloseOperation == 0) {
            this.frame.addWindowListener(this.getWindowListener());
        }
        this.frame.setContentPane(this.buildContent());
        Preferences appUserPrefs = null;
        boolean restored = false;
        if (Application.hasInstance()) {
            appUserPrefs = Application.getInstance().getContext().getUserPreferences();
            boolean bl = restored = this.restoreBounds && WindowUtils.restoreBounds(this.frame, appUserPrefs);
            if (this.applicationExitedRunnable != null) {
                Application.getInstance().addExitListener(new ApplicationExitedHandler(this.applicationExitedRunnable));
            }
        }
        if (!restored) {
            if (this.effectiveInitialSizes != null) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                for (Dimension effectiveInitialSize : this.effectiveInitialSizes) {
                    Dimension initialSize = ScreenScaling.toPhysical(effectiveInitialSize);
                    if (initialSize.width > screenSize.width || initialSize.height > screenSize.height) continue;
                    this.frame.setSize(initialSize.width, initialSize.height);
                    break;
                }
            } else {
                this.frame.pack();
            }
            ScreenUtils.locateAt(this.frame, this.initialLocation);
        }
        if (appUserPrefs != null) {
            WindowUtils.restoreState(this.frame, appUserPrefs, false);
            this.frame.addComponentListener(new WindowUtils.PersistencyHandler(this.frame, appUserPrefs));
        }
        return this.frame;
    }

    public JFrame show() {
        JFrame frame = this.build();
        frame.setVisible(true);
        return frame;
    }

    private String getTitle() {
        return this.title != null ? this.title : Application.getResourceMap(null).getString("application.title", new Object[0]);
    }

    private String getName() {
        return this.name != null ? this.name : "frame" + frameCounter++;
    }

    private WindowListener getWindowListener() {
        return this.windowListener != null ? this.windowListener : Application.getInstance().getApplicationExitOnWindowClosingHandler();
    }

    private JComponent buildContent() {
        JLabel splashTitleLabel;
        if (this.contentPane != null) {
            return this.contentPane;
        }
        if (this.splashTitleText != null) {
            splashTitleLabel = new JLabel(this.splashTitleText);
            splashTitleLabel.setFont(this.getSplashTitleFont());
            splashTitleLabel.setForeground(this.getSplashTitleForeground());
        } else {
            splashTitleLabel = this.splashIcon != null ? new JLabel(this.splashIcon) : null;
        }
        JLabel splashSubtitleLabel = null;
        if (this.splashSubtitleText != null) {
            splashSubtitleLabel = new JLabel(this.splashSubtitleText);
            splashSubtitleLabel.setFont(this.getSplashSubitleFont());
            splashSubtitleLabel.setForeground(this.isDarkBackground() ? Color.WHITE : Color.DARK_GRAY);
        }
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("0:grow, center:pref, 0:grow", new Object[0])).rows("0:g, p, 0, p, 0:g", new Object[0])).add(splashTitleLabel).xy(2, 2)).add(splashSubtitleLabel).xy(2, 4)).build();
    }

    private Font getSplashTitleFont() {
        return this.splashTitleFont != null ? this.splashTitleFont : FrameBuilder.getDefaultFont(1, 72);
    }

    private Font getSplashSubitleFont() {
        return this.splashSubtitleFont != null ? this.splashSubtitleFont : FrameBuilder.getDefaultFont(0, 24);
    }

    private static Font getDefaultFont(int style, int effectiveSize) {
        return ScreenScaling.physicalFont(new JLabel(), effectiveSize).deriveFont(style);
    }

    private Color getSplashTitleForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.isDarkBackground() ? new Color(241, 241, 241) : new Color(100, 100, 100);
    }

    private boolean isDarkBackground() {
        Color bg = this.frame.getBackground();
        float[] hsbVals = new float[3];
        Color.RGBtoHSB(bg.getRed(), bg.getGreen(), bg.getBlue(), hsbVals);
        return hsbVals[2] < 0.8f;
    }

    private static final class ApplicationExitedHandler
    implements ExitListener {
        private final Runnable exitedRunnable;

        ApplicationExitedHandler(Runnable exitedRunnable) {
            this.exitedRunnable = exitedRunnable;
        }

        @Override
        public void applicationExited() {
            this.exitedRunnable.run();
        }
    }
}

