/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.statistic;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.jdiskreport.gui.node.FileNode;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public abstract class AbstractDistribution {
    private static final ResourceMap RESOURCES = Application.getResourceMap(AbstractDistribution.class);
    private final long[] sizes = new long[this.getRowCount()];
    private final long[] counts = new long[this.getRowCount()];
    private long sizeTotal;
    private long countTotal;
    private TableModel tableModel;

    protected AbstractDistribution() {
    }

    public final TableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new ArrayDistributionTableModel(this);
        }
        return this.tableModel;
    }

    final long getSizeTotal() {
        return this.sizeTotal;
    }

    final long getSizeAt(int rowIndex) {
        return this.sizes[rowIndex];
    }

    final long getCountTotal() {
        return this.countTotal;
    }

    final long getCountAt(int rowIndex) {
        return this.counts[rowIndex];
    }

    protected abstract int getRowCount();

    String getKeyPrefix() {
        return this.getClass().getSimpleName();
    }

    protected abstract void add(FileNode var1);

    final void add(AbstractDistribution distribution) {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.add(i, distribution.getSizeAt(i), distribution.getCountAt(i));
        }
    }

    protected final void add(int rowIndex, long size, long count) {
        int n = rowIndex;
        this.sizes[n] = this.sizes[n] + size;
        int n2 = rowIndex;
        this.counts[n2] = this.counts[n2] + count;
        this.sizeTotal += size;
        this.countTotal += count;
    }

    public String toString() {
        TableModel model = this.getTableModel();
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        for (int row = 0; row < this.getRowCount(); ++row) {
            builder.append("\n");
            builder.append(model.getValueAt(row, 0));
            builder.append(": size=");
            builder.append(model.getValueAt(row, 1));
            builder.append("; count=");
            builder.append(model.getValueAt(row, 3));
        }
        builder.append("\nTotal: size=" + this.getSizeTotal());
        builder.append("; count=" + this.getCountTotal());
        return builder.toString();
    }

    static final class ArrayDistributionTableModel
    implements TableModel {
        private static final String[] COLUMN_NAME_KEY_SUFFIXES = new String[]{"title", "size", "sizePercent", "count", "countPercent"};
        private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, Long.class, Float.class, Long.class, Float.class};
        private final AbstractDistribution distribution;

        ArrayDistributionTableModel(AbstractDistribution distribution) {
            this.distribution = distribution;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAME_KEY_SUFFIXES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String key = this.distribution.getKeyPrefix() + ".columnName." + COLUMN_NAME_KEY_SUFFIXES[columnIndex];
            return RESOURCES.getString(key, new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.distribution.getRowCount();
        }

        private String getRowName(int rowIndex) {
            String key = this.distribution.getKeyPrefix() + ".rowName[" + rowIndex + "]";
            return RESOURCES.getString(key, new Object[0]);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getRowName(rowIndex);
                }
                case 1: {
                    return this.distribution.getSizeAt(rowIndex);
                }
                case 2: {
                    float size = this.distribution.getSizeAt(rowIndex);
                    long sizeTotal = this.distribution.sizeTotal;
                    return Float.valueOf(sizeTotal == 0L ? 1.0f : size / (float)sizeTotal);
                }
                case 3: {
                    return this.distribution.getCountAt(rowIndex);
                }
                case 4: {
                    float count = this.distribution.getCountAt(rowIndex);
                    long countTotal = this.distribution.countTotal;
                    return Float.valueOf(countTotal == 0L ? 1.0f : count / (float)countTotal);
                }
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Distribution table models are not editable.");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

